package com.paystack.android.ui.paymentchannels.card.auth.address

import com.paystack.android.core.api.models.AddressState

internal data class AddressFormState(
    val streetAddress: String = "",
    val zipCode: String = "",
    val city: String = "",
    val selectedStateIndex: Int? = null,
    val stateList: List<AddressState> = emptyList(),
    val isSubmitting: Boolean = false,
    val isLoadingStates: Boolean = false
) {
    val isFormValid: Boolean
        get() = streetAddress.isNotEmpty() &&
            zipCode.isNotEmpty() &&
            city.isNotEmpty() &&
            selectedStateIndex != null

    val selectedStateCode: String?
        get() = selectedStateIndex?.let { stateList[it].abbreviation }
}
