package com.paystack.android.ui.components.views.inputs

import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.input.ImeAction
import androidx.compose.ui.text.input.KeyboardType
import com.paystack.android.ui.components.views.inputs.textfield.StackTextField

@Composable
fun PrimaryTextInputField(
    text: String,
    onTextChanged: (String) -> Unit,
    label: String,
    placeholder: String,
    modifier: Modifier = Modifier,
    maxLength: Int? = null,
    keyboardType: KeyboardType = KeyboardType.Text,
    imeAction: ImeAction = ImeAction.Done,
) {
    StackTextField(
        modifier = modifier,
        value = text,
        onValueChange = { updatedText ->
            if (maxLength == null) {
                onTextChanged(updatedText)
            } else {
                if (updatedText.length <= maxLength) {
                    onTextChanged(updatedText)
                }
            }
        },
        label = { Text(text = label) },
        placeholder = { Text(text = placeholder) },
        keyboardOptions = KeyboardOptions.Default.copy(
            keyboardType = keyboardType,
            imeAction = imeAction
        ),
        singleLine = true,
    )
}
