package com.paystack.android.ui.components

import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.paystack.android.ui.theme.badgeHorizontalPadding
import com.paystack.android.ui.theme.shapes
import com.paystack.androiddesignsystem.PaystackTheme

@Composable
internal fun WarningBadge(
    text: String,
    modifier: Modifier = Modifier,
) {
    Box(
        modifier = modifier
            .border(
                width = BorderThickness,
                color = PaystackTheme.colors.feedbackColors.warning04,
                shape = PaystackTheme.shapes.badge
            )
            .background(
                color = PaystackTheme.colors.feedbackColors.warning05,
                shape = PaystackTheme.shapes.badge
            )
            .padding(
                horizontal = PaystackTheme.dimensions.badgeHorizontalPadding,
                vertical = PaystackTheme.dimensions.spacing.half
            ),
        contentAlignment = Alignment.Center
    ) {
        Text(
            text = text.uppercase(), color = PaystackTheme.colors.feedbackColors.warning01,
            style = PaystackTheme.typography.body.smallTextM
        )
    }
}

private val BorderThickness = 1.dp
