package com.paystack.android.ui.data

import com.paystack.android.core.Paystack
import com.paystack.android.core.api.cards
import com.paystack.android.core.api.mobileMoney
import com.paystack.android.core.api.transactions
import com.paystack.android.ui.data.transaction.TransactionRepository
import com.paystack.android.ui.data.transaction.TransactionRepositoryImpl

internal fun dataComponent() = DataModule(Paystack.Builder.instance.build())

internal interface DataComponent {
    val transactionRepository: TransactionRepository
}

internal class DataModule constructor(private val paystack: Paystack) : DataComponent {
    override val transactionRepository: TransactionRepository
        get() = TransactionRepositoryImpl(
            paystack.transactions,
            paystack.cards,
            paystack.mobileMoney
        )
}
