/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.ui.components.views.inputs.validators;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TransformedText;
import com.paystack.android.ui.components.views.inputs.validators.CardType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lcom/paystack/android/ui/components/views/inputs/validators/CardNumberFormatter;", "", "()V", "formatAmexCardNumbers", "Landroidx/compose/ui/text/input/TransformedText;", "cardNumber", "", "formatCardNumberByType", "cardType", "Lcom/paystack/android/ui/components/views/inputs/validators/CardType;", "Landroidx/compose/ui/text/AnnotatedString;", "formatOtherCreditCards", "formatVerveCardNumbers", "paystack-ui_release"})
@SourceDebugExtension(value={"SMAP\nCardNumberFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardNumberFormatter.kt\ncom/paystack/android/ui/components/views/inputs/validators/CardNumberFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1855#2,2:167\n1855#2,2:169\n1855#2,2:171\n*S KotlinDebug\n*F\n+ 1 CardNumberFormatter.kt\ncom/paystack/android/ui/components/views/inputs/validators/CardNumberFormatter\n*L\n52#1:167,2\n89#1:169,2\n139#1:171,2\n*E\n"})
public final class CardNumberFormatter {
    @NotNull
    public static final CardNumberFormatter INSTANCE = new CardNumberFormatter();

    private CardNumberFormatter() {
    }

    @NotNull
    public final TransformedText formatCardNumberByType(@NotNull CardType cardType, @NotNull AnnotatedString cardNumber) {
        TransformedText transformedText;
        Intrinsics.checkNotNullParameter((Object)((Object)cardType), (String)"cardType");
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        String number = cardNumber.getText();
        switch (WhenMappings.$EnumSwitchMapping$0[cardType.ordinal()]) {
            case 1: {
                transformedText = this.formatAmexCardNumbers(number);
                break;
            }
            case 2: {
                transformedText = this.formatVerveCardNumbers(number);
                break;
            }
            default: {
                transformedText = this.formatOtherCreditCards(number);
            }
        }
        return transformedText;
    }

    private final TransformedText formatAmexCardNumbers(String cardNumber) {
        String trimmedAmexCardNumber = cardNumber.length() > 15 ? StringsKt.substring((String)cardNumber, (IntRange)new IntRange(0, 14)) : cardNumber;
        Object output = null;
        output = "";
        Iterable $this$forEach$iv = (Iterable)StringsKt.getIndices((CharSequence)trimmedAmexCardNumber);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            output = "" + output + trimmedAmexCardNumber.charAt(index);
            if (index == 14) continue;
            switch (index) {
                case 3: 
                case 9: {
                    output = output + " ";
                }
            }
        }
        OffsetMapping amexCardOffsetTranslator2 = new OffsetMapping(){

            public int originalToTransformed(int offset) {
                if (offset <= 3) {
                    return offset;
                }
                if (offset <= 9) {
                    return offset + 1;
                }
                if (offset <= 15) {
                    return offset + 2;
                }
                return 17;
            }

            public int transformedToOriginal(int offset) {
                if (offset <= 4) {
                    return offset;
                }
                if (offset <= 9) {
                    return offset - 1;
                }
                if (offset <= 17) {
                    return offset - 2;
                }
                return 15;
            }
        };
        return new TransformedText(new AnnotatedString((String)output, null, null, 6, null), amexCardOffsetTranslator2);
    }

    private final TransformedText formatVerveCardNumbers(String cardNumber) {
        String trimmedVerveCardNumber = cardNumber.length() == 19 ? StringsKt.substring((String)cardNumber, (IntRange)new IntRange(0, 18)) : cardNumber;
        Object output = null;
        output = "";
        Iterable $this$forEach$iv = (Iterable)StringsKt.getIndices((CharSequence)trimmedVerveCardNumber);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            output = "" + output + trimmedVerveCardNumber.charAt(index);
            if (index == 18 || index % 5 != 4) continue;
            output = output + " ";
        }
        OffsetMapping verveCardOffsetTranslator2 = new OffsetMapping(){

            public int originalToTransformed(int offset) {
                if (offset <= 4) {
                    return offset;
                }
                if (offset <= 9) {
                    return offset + 1;
                }
                if (offset <= 14) {
                    return offset + 2;
                }
                if (offset <= 19) {
                    return offset + 3;
                }
                return 23;
            }

            public int transformedToOriginal(int offset) {
                if (offset <= 5) {
                    return offset;
                }
                if (offset <= 11) {
                    return offset - 1;
                }
                if (offset <= 17) {
                    return offset - 2;
                }
                if (offset <= 23) {
                    return offset - 3;
                }
                return 19;
            }
        };
        return new TransformedText(new AnnotatedString((String)output, null, null, 6, null), verveCardOffsetTranslator2);
    }

    private final TransformedText formatOtherCreditCards(String cardNumber) {
        String trimmedCardNumber = cardNumber.length() > 19 ? StringsKt.substring((String)cardNumber, (IntRange)new IntRange(0, 18)) : cardNumber;
        Ref.ObjectRef output = new Ref.ObjectRef();
        output.element = "";
        int lastValidIndex = trimmedCardNumber.length() - 1;
        Iterable $this$forEach$iv = (Iterable)StringsKt.getIndices((CharSequence)trimmedCardNumber);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            output.element = "" + output.element + trimmedCardNumber.charAt(index);
            if (index % 4 != 3 || index == lastValidIndex) continue;
            output.element = output.element + " ";
        }
        OffsetMapping creditCardOffsetTranslator2 = new OffsetMapping(trimmedCardNumber, (Ref.ObjectRef<String>)output){
            final /* synthetic */ String $trimmedCardNumber;
            final /* synthetic */ Ref.ObjectRef<String> $output;
            {
                this.$trimmedCardNumber = $trimmedCardNumber;
                this.$output = $output;
            }

            public int originalToTransformed(int offset) {
                return offset >= this.$trimmedCardNumber.length() ? ((String)this.$output.element).length() : offset + offset / 4;
            }

            public int transformedToOriginal(int offset) {
                return offset >= ((String)this.$output.element).length() ? this.$trimmedCardNumber.length() : offset - offset / 5;
            }
        };
        return new TransformedText(new AnnotatedString((String)output.element, null, null, 6, null), creditCardOffsetTranslator2);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CardType.values().length];
            try {
                nArray[CardType.AMEX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardType.VERVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

