/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.ui;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.paystack.android.core.api.models.AccessCodeData;
import com.paystack.android.core.api.models.PaymentChannel;
import com.paystack.android.core.api.models.PaystackError;
import com.paystack.android.core.logging.Logger;
import com.paystack.android.ui.PaymentProcessState;
import com.paystack.android.ui.data.DataComponentKt;
import com.paystack.android.ui.data.transaction.TransactionRepository;
import com.paystack.android.ui.models.PaymentChannelMenuItem;
import com.paystack.android.ui.paymentchannels.PaymentChannelMenuBuilder;
import com.paystack.android.ui.utilities.StringProvider;
import com.paystack.android.ui.utilities.UtilitiesComponentKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/paystack/android/ui/PaymentProcessViewModel;", "Landroidx/lifecycle/ViewModel;", "accessCodeData", "Lcom/paystack/android/core/api/models/AccessCodeData;", "transactionRepository", "Lcom/paystack/android/ui/data/transaction/TransactionRepository;", "channelMenuBuilder", "Lcom/paystack/android/ui/paymentchannels/PaymentChannelMenuBuilder;", "(Lcom/paystack/android/core/api/models/AccessCodeData;Lcom/paystack/android/ui/data/transaction/TransactionRepository;Lcom/paystack/android/ui/paymentchannels/PaymentChannelMenuBuilder;)V", "_menuItems", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/paystack/android/ui/models/PaymentChannelMenuItem;", "_state", "Lcom/paystack/android/ui/PaymentProcessState;", "getAccessCodeData", "()Lcom/paystack/android/core/api/models/AccessCodeData;", "menuItems", "Lkotlinx/coroutines/flow/StateFlow;", "getMenuItems", "()Lkotlinx/coroutines/flow/StateFlow;", "state", "getState", "buildChannelMenu", "", "onPaymentChannelSelected", "paymentChannel", "Lcom/paystack/android/core/api/models/PaymentChannel;", "providerKey", "", "Factory", "paystack-ui_release"})
@SourceDebugExtension(value={"SMAP\nPaymentProcessViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentProcessViewModel.kt\ncom/paystack/android/ui/PaymentProcessViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,86:1\n766#2:87\n857#2,2:88\n230#3,5:90\n230#3,5:95\n*S KotlinDebug\n*F\n+ 1 PaymentProcessViewModel.kt\ncom/paystack/android/ui/PaymentProcessViewModel\n*L\n38#1:87\n38#1:88,2\n56#1:90,5\n61#1:95,5\n*E\n"})
public final class PaymentProcessViewModel
extends ViewModel {
    @NotNull
    private final AccessCodeData accessCodeData;
    @NotNull
    private final TransactionRepository transactionRepository;
    @NotNull
    private final PaymentChannelMenuBuilder channelMenuBuilder;
    @NotNull
    private final MutableStateFlow<PaymentProcessState> _state;
    @NotNull
    private final StateFlow<PaymentProcessState> state;
    @NotNull
    private final MutableStateFlow<List<PaymentChannelMenuItem>> _menuItems;
    @NotNull
    private final StateFlow<List<PaymentChannelMenuItem>> menuItems;

    public PaymentProcessViewModel(@NotNull AccessCodeData accessCodeData, @NotNull TransactionRepository transactionRepository, @NotNull PaymentChannelMenuBuilder channelMenuBuilder) {
        Intrinsics.checkNotNullParameter((Object)accessCodeData, (String)"accessCodeData");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)channelMenuBuilder, (String)"channelMenuBuilder");
        this.accessCodeData = accessCodeData;
        this.transactionRepository = transactionRepository;
        this.channelMenuBuilder = channelMenuBuilder;
        this._state = StateFlowKt.MutableStateFlow((Object)PaymentProcessState.SelectPaymentChannel.INSTANCE);
        this.state = FlowKt.asStateFlow(this._state);
        this._menuItems = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.menuItems = FlowKt.asStateFlow(this._menuItems);
        this.buildChannelMenu();
    }

    @NotNull
    public final AccessCodeData getAccessCodeData() {
        return this.accessCodeData;
    }

    @NotNull
    public final StateFlow<PaymentProcessState> getState() {
        return this.state;
    }

    @NotNull
    public final StateFlow<List<PaymentChannelMenuItem>> getMenuItems() {
        return this.menuItems;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildChannelMenu() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.accessCodeData.getChannels();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PaymentChannel it = (PaymentChannel)element$iv$iv;
            boolean bl = false;
            if (!this.transactionRepository.getSupportedPaymentChannels().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List supportedChannels = (List)destination$iv$iv;
        if (supportedChannels.isEmpty()) {
            PaystackError error = new PaystackError("No supported payment methods on transaction", null, 2, null);
            Logger.INSTANCE.error((Throwable)error);
            this._state.setValue((Object)new PaymentProcessState.Error((Throwable)error));
            return;
        }
        List<PaymentChannelMenuItem> items2 = this.channelMenuBuilder.build(supportedChannels, this.accessCodeData.getChannelOptions());
        boolean bl = false;
        this._menuItems.setValue(items2);
        if (items2.size() == 1) {
            PaymentChannelMenuItem menuItem = (PaymentChannelMenuItem)CollectionsKt.first(items2);
            this.onPaymentChannelSelected(menuItem.getPaymentChannel(), menuItem.getProviderKey());
        } else {
            PaymentProcessState nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<PaymentProcessState> $this$update$iv = this._state;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                PaymentProcessState it = (PaymentProcessState)prevValue$iv;
                boolean bl2 = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (PaymentProcessState)PaymentProcessState.SelectPaymentChannel.INSTANCE)));
        }
    }

    public final void onPaymentChannelSelected(@NotNull PaymentChannel paymentChannel, @NotNull String providerKey) {
        PaymentProcessState nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)paymentChannel, (String)"paymentChannel");
        Intrinsics.checkNotNullParameter((Object)providerKey, (String)"providerKey");
        MutableStateFlow<PaymentProcessState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            PaymentProcessState it = (PaymentProcessState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (PaymentProcessState)new PaymentProcessState.PaymentChannelProcess(paymentChannel, providerKey))));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ%\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/paystack/android/ui/PaymentProcessViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "context", "Landroid/content/Context;", "accessCodeData", "Lcom/paystack/android/core/api/models/AccessCodeData;", "transactionRepository", "Lcom/paystack/android/ui/data/transaction/TransactionRepository;", "stringProvider", "Lcom/paystack/android/ui/utilities/StringProvider;", "(Landroid/content/Context;Lcom/paystack/android/core/api/models/AccessCodeData;Lcom/paystack/android/ui/data/transaction/TransactionRepository;Lcom/paystack/android/ui/utilities/StringProvider;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "paystack-ui_release"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    implements ViewModelProvider.Factory {
        @NotNull
        private final Context context;
        @NotNull
        private final AccessCodeData accessCodeData;
        @NotNull
        private final TransactionRepository transactionRepository;
        @NotNull
        private final StringProvider stringProvider;
        public static final int $stable = 8;

        public Factory(@NotNull Context context, @NotNull AccessCodeData accessCodeData, @NotNull TransactionRepository transactionRepository, @NotNull StringProvider stringProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessCodeData, (String)"accessCodeData");
            Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
            Intrinsics.checkNotNullParameter((Object)stringProvider, (String)"stringProvider");
            this.context = context;
            this.accessCodeData = accessCodeData;
            this.transactionRepository = transactionRepository;
            this.stringProvider = stringProvider;
        }

        public /* synthetic */ Factory(Context context, AccessCodeData accessCodeData, TransactionRepository transactionRepository, StringProvider stringProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                transactionRepository = DataComponentKt.dataComponent().getTransactionRepository();
            }
            if ((n & 8) != 0) {
                stringProvider = UtilitiesComponentKt.utilitiesComponent(context).getStringProvider();
            }
            this(context, accessCodeData, transactionRepository, stringProvider);
        }

        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            if (modelClass.isAssignableFrom(PaymentProcessViewModel.class)) {
                return (T)((Object)new PaymentProcessViewModel(this.accessCodeData, this.transactionRepository, new PaymentChannelMenuBuilder(this.stringProvider)));
            }
            throw new IllegalArgumentException("Unknown ViewModel class");
        }
    }
}

