package com.paystack.android.ui.components.views.inputs

import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.input.KeyboardType
import com.paystack.android.ui.R
import com.paystack.android.ui.components.views.inputs.textfield.StackTextField

@Composable
internal fun CVVInputField(
    modifier: Modifier = Modifier,
    inputCVVText: String,
    maxInputLength: Int,
    onTextChange: (String) -> Unit
) {
    StackTextField(
        modifier = modifier,
        value = inputCVVText,
        onValueChange = { cvvValue ->
            if (cvvValue.length <= maxInputLength) {
                onTextChange(cvvValue)
            }
        },
        label = { Text(text = stringResource(id = R.string.pstk_card_payment_card_cvv_label)) },
        placeholder = { stringResource(id = R.string.pstk_card_payment_card_expiry_placeholder) },
        keyboardOptions = KeyboardOptions.Default.copy(keyboardType = KeyboardType.Number),
        singleLine = true
    )
}
