package com.paystack.android.ui.components.bottomsheet

import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.SheetState
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Job
import kotlinx.coroutines.launch

@OptIn(ExperimentalMaterial3Api::class)
class BottomSheetDelegateImpl constructor(
    private val state: SheetState,
    private val scope: CoroutineScope
) : BottomSheetDelegate {

    override fun hide(): Job = scope.launch {
        state.hide()
    }

    override fun show(): Job = scope.launch {
        state.expand()
    }
}
