package com.paystack.android_sdk.ui.paymentchannels.card

sealed class CardPaymentsState {
    object CardDetails : CardPaymentsState()

    object CardPin : CardPaymentsState()

    data class Error(val message: String, val isRecoverable: Boolean = false) : CardPaymentsState()

    object DateOfBirthAuthentication : CardPaymentsState()

    data class AddressAuthentication(val countryCode: String) : CardPaymentsState()

    object PhoneNumberAuth : CardPaymentsState()

    data class OtpAuth(val instruction: String?) : CardPaymentsState()

    data class RedirectAuth(val authUrl: String) : CardPaymentsState()

    object Pending : CardPaymentsState()
}
