package com.paystack.android_sdk.ui.paymentchannels.card

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import com.paystack.android_sdk.ui.R
import com.paystack.android_sdk.ui.components.buttons.SecondaryButton
import com.paystack.androiddesignsystem.PaystackTheme

@Composable
internal fun CardPaymentError(
    errorMessage: String,
    isTestTransaction: Boolean,
    onRetryClick: () -> Unit,
    modifier: Modifier = Modifier,
) {
    Column(
        modifier = modifier,
        horizontalAlignment = Alignment.CenterHorizontally,
    ) {
        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.triple))

        Image(
            painter = painterResource(R.drawable.pstk_ic_warning),
            contentDescription = stringResource(R.string.pstk_error)
        )
        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.double))

        Text(
            text = errorMessage,
            textAlign = TextAlign.Center,
            modifier = Modifier
                .fillMaxWidth()
                .padding(horizontal = PaystackTheme.dimensions.spacing.triple),
            style = PaystackTheme.typography.body.body16M,
        )

        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.triple))

        SecondaryButton(
            text = stringResource(
                if (isTestTransaction) {
                    R.string.pstk_retry_with_test_details
                } else {
                    R.string.pstk_card_payment_error_btn_try_another_card
                }
            ),
            onClick = onRetryClick,
            modifier = Modifier.fillMaxWidth()
        )
    }
}

@Composable
@Preview
internal fun CardPaymentErrorPreview() {
    PaystackTheme {
        Surface(
            modifier = Modifier.fillMaxSize()
        ) {
            CardPaymentError(
                modifier = Modifier.padding(PaystackTheme.dimensions.spacing.double),
                errorMessage = "Street address does not match",
                isTestTransaction = true,
                onRetryClick = {}
            )
        }
    }
}
