package com.paystack.android_sdk.ui.paymentsheet

import android.content.Context
import android.content.Intent
import android.os.Parcelable
import androidx.activity.result.contract.ActivityResultContract
import androidx.core.os.bundleOf
import kotlinx.parcelize.Parcelize

internal class PaymentSheetResultContract :
    ActivityResultContract<PaymentSheetResultContract.Args, PaymentSheetResult>() {
    override fun createIntent(context: Context, input: Args): Intent {
        return Intent(context, PaymentSheetActivity::class.java)
            .putExtras(input.toBundle())
    }

    override fun parseResult(resultCode: Int, intent: Intent?): PaymentSheetResult {
        val paymentResult = intent?.getParcelableExtra<Result>(EXTRA_RESULT)?.paymentResult
        return paymentResult ?: PaymentSheetResult.Failed(
            error = IllegalArgumentException("Failed to retrieve a PaymentResult."),
            reference = null
        )
    }

    @Parcelize
    data class Args internal constructor(
        internal val accessCode: String,
    ) : Parcelable {
        internal fun toBundle() = bundleOf(EXTRA_ACCESS_CODE to accessCode)
    }

    @Parcelize
    internal data class Result(val paymentResult: PaymentSheetResult) : Parcelable {
        fun toBundle() = bundleOf(EXTRA_RESULT to this)
    }

    internal companion object {
        private const val EXTRA_RESULT = "com.paystack.android.ui.PaymentSheetContract.extra_result"

        const val EXTRA_ACCESS_CODE = "transaction_access_code"
    }
}
