package com.paystack.android_sdk.ui.paymentsheet

import androidx.activity.ComponentActivity
import androidx.fragment.app.Fragment

class PaymentSheet internal constructor(
    private val paymentSheetLauncher: PaymentSheetLauncher
) {

    /**
     * Constructor to be used when launching the payment sheet from an Activity.
     *
     * @param activity  the Activity that launches the payment sheet.
     * @param callback  called with the result of the payment after the payment sheet is dismissed.
     */
    constructor(
        activity: ComponentActivity,
        callback: PaymentSheetResultCallback
    ) : this(DefaultPaymentSheetLauncher(activity, callback))

    /**
     * Constructor to be used when launching the payment sheet from an Activity.
     *
     * @param fragment  the fragment that launches payment sheet.
     * @param callback  called with the result of the payment after the payment sheet is dismissed.
     */
    constructor(
        fragment: Fragment,
        callback: PaymentSheetResultCallback
    ) : this(DefaultPaymentSheetLauncher(fragment, callback))

    fun launch(accessCode: String) {
        paymentSheetLauncher.launch(accessCode)
    }
}
