package com.paystack.android_sdk.ui.paymentchannels.card.auth.phone

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.paystack.android_sdk.core.api.models.AccessCodeData
import com.paystack.android_sdk.ui.data.transaction.TransactionRepository
import com.paystack.android_sdk.ui.models.Charge
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update
import kotlinx.coroutines.launch

internal class PhoneNumberAuthViewModel(
    private val transactionAccessData: AccessCodeData,
    private val transactionRepository: TransactionRepository,
) : ViewModel() {
    private val _state = MutableStateFlow(PhoneNumberAuthState())
    val state: StateFlow<PhoneNumberAuthState> = _state.asStateFlow()

    private val _result = MutableStateFlow<Result<Charge>?>(null)
    val result = _result.asStateFlow()

    fun onPhoneNumberChanged(phoneNumber: String) {
        _state.update { it.copy(phoneNumber = phoneNumber) }
    }

    fun submit() {
        viewModelScope.launch {
            _state.update { it.copy(isSubmitting = true) }
            _result.value = transactionRepository.authenticateWithPhone(
                accessCode = transactionAccessData.accessCode,
                phoneNumber = state.value.phoneNumber
            )
            _state.update { it.copy(isSubmitting = false) }
        }
    }
}
