package com.paystack.android_sdk.ui.paymentchannels.card.auth.otp

import android.os.Parcelable
import androidx.annotation.OpenForTesting
import kotlinx.parcelize.Parcelize

@Parcelize
internal data class OtpAuthState(
    val otp: String = "",
    val isSubmitting: Boolean = false,
    val otpResendAttempts: Int = 0,
    val otpResendDelayMillis: Long = 0L,
) : Parcelable {
    val isValid: Boolean
        get() = otp.isNotBlank()
    val otpResendLimited: Boolean
        get() = otpResendAttempts >= RESEND_OTP_MAX_ATTEMPTS
    val enableResendOtp: Boolean
        get() = otpResendDelayMillis == 0L

    @OpenForTesting
    companion object {
        const val RESEND_OTP_MAX_ATTEMPTS = 2
    }
}
