package com.paystack.android_sdk.ui.components.bottomsheet

/**
 * This class contains the current state of user action, bottom sheet type and content
 *
 * @property bottomSheetContent - the Composable to show in the Bottom Sheet when in a particular state
 * @property bottomSheetViewType - The type of Bottom Sheet to display
 * @property bottomSheetAction - Current state of the BottomSheet, e.g. HIDE or SHOW
 */
data class ModalBottomSheetViewState(
    val bottomSheetContent: BottomSheetContent = BottomSheetContent.InitialSheetContent,
    val bottomSheetViewType: BottomSheetViewType = BottomSheetViewType.INITIAL,
    val bottomSheetAction: BottomSheetActions = BottomSheetActions.INITIAL
)
