package com.paystack.android_sdk.ui.utilities

import com.paystack.android_sdk.core.api.models.PaystackError
import retrofit2.HttpException

/**
 * Is true when [PaystackError] represents a failure we cannot recover from.
 * Display a generic error message and end payment flow.
 */
internal val PaystackError.isFatal: Boolean
    get() = cause != null && cause !is HttpException
