/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android_sdk.ui.paymentchannels.card;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import com.paystack.android_sdk.core.api.models.AccessCodeData;
import com.paystack.android_sdk.core.api.models.PaystackError;
import com.paystack.android_sdk.core.api.models.TransactionStatus;
import com.paystack.android_sdk.core.logging.Logger;
import com.paystack.android_sdk.ui.R;
import com.paystack.android_sdk.ui.data.transaction.TransactionRepository;
import com.paystack.android_sdk.ui.models.Charge;
import com.paystack.android_sdk.ui.paymentchannels.card.CardPaymentViewModel;
import com.paystack.android_sdk.ui.paymentchannels.card.CardPaymentsState;
import com.paystack.android_sdk.ui.utilities.PaystackErrorExtKt;
import com.paystack.android_sdk.ui.utilities.StringProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 02\u00020\u0001:\u00010BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001e\u001a\u00020\u000bH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\rH\u0002J\b\u0010#\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\nH\u0002J\u0006\u0010&\u001a\u00020\u000bJ\u0006\u0010'\u001a\u00020\u000bJ\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\nH\u0002J\u001c\u0010)\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u001c\u0010.\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0+\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0006\u0010/\u001a\u00020\u000bR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"Lcom/paystack/android_sdk/ui/paymentchannels/card/CardPaymentViewModel;", "Landroidx/lifecycle/ViewModel;", "transactionRepository", "Lcom/paystack/android_sdk/ui/data/transaction/TransactionRepository;", "transactionAccessData", "Lcom/paystack/android_sdk/core/api/models/AccessCodeData;", "stringProvider", "Lcom/paystack/android_sdk/ui/utilities/StringProvider;", "onPaymentComplete", "Lkotlin/Function1;", "Lcom/paystack/android_sdk/ui/models/Charge;", "", "onError", "", "(Lcom/paystack/android_sdk/ui/data/transaction/TransactionRepository;Lcom/paystack/android_sdk/core/api/models/AccessCodeData;Lcom/paystack/android_sdk/ui/utilities/StringProvider;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "_cardPaymentsState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/paystack/android_sdk/ui/paymentchannels/card/CardPaymentsState;", "cardFlowViewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "getCardFlowViewModelStoreOwner", "()Landroidx/lifecycle/ViewModelStoreOwner;", "cardPaymentsState", "Lkotlinx/coroutines/flow/StateFlow;", "getCardPaymentsState", "()Lkotlinx/coroutines/flow/StateFlow;", "paymentFlowVmStores", "", "", "Landroidx/lifecycle/ViewModelStore;", "checkPendingCharge", "handleAddressAuth", "charge", "handleFailure", "error", "handlePending", "handleRedirect", "handleTimeout", "onDateOfBirthAuth", "onPinAuth", "parseTransaction", "process3dsResponse", "result", "Lkotlin/Result;", "Lcom/paystack/android_sdk/core/api/models/TransactionStatus;", "(Ljava/lang/Object;)V", "processCardChargeResponse", "restartCardPayment", "Companion", "paystack-ui_release"})
@SourceDebugExtension(value={"SMAP\nCardPaymentViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardPaymentViewModel.kt\ncom/paystack/android_sdk/ui/paymentchannels/card/CardPaymentViewModel\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n230#2,5:188\n230#2,5:193\n230#2,5:198\n230#2,5:204\n230#2,5:209\n230#2,5:214\n230#2,5:219\n230#2,5:224\n230#2,5:229\n230#2,5:234\n230#2,5:239\n230#2,5:244\n230#2,5:249\n230#2,5:254\n230#2,5:259\n1#3:203\n*S KotlinDebug\n*F\n+ 1 CardPaymentViewModel.kt\ncom/paystack/android_sdk/ui/paymentchannels/card/CardPaymentViewModel\n*L\n79#1:188,5\n83#1:193,5\n87#1:198,5\n112#1:204,5\n117#1:209,5\n118#1:214,5\n119#1:219,5\n121#1:224,5\n129#1:229,5\n138#1:234,5\n143#1:239,5\n149#1:244,5\n159#1:249,5\n166#1:254,5\n171#1:259,5\n*E\n"})
public final class CardPaymentViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransactionRepository transactionRepository;
    @NotNull
    private final AccessCodeData transactionAccessData;
    @NotNull
    private final StringProvider stringProvider;
    @NotNull
    private final Function1<Charge, Unit> onPaymentComplete;
    @NotNull
    private final Function1<Throwable, Unit> onError;
    @NotNull
    private final MutableStateFlow<CardPaymentsState> _cardPaymentsState;
    @NotNull
    private final Map<String, ViewModelStore> paymentFlowVmStores;
    @NotNull
    private final ViewModelStoreOwner cardFlowViewModelStoreOwner;
    private static final long CHECK_PENDING_DELAY_MILLIS = 5000L;

    public CardPaymentViewModel(@NotNull TransactionRepository transactionRepository, @NotNull AccessCodeData transactionAccessData, @NotNull StringProvider stringProvider, @NotNull Function1<? super Charge, Unit> onPaymentComplete, @NotNull Function1<? super Throwable, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)transactionAccessData, (String)"transactionAccessData");
        Intrinsics.checkNotNullParameter((Object)stringProvider, (String)"stringProvider");
        Intrinsics.checkNotNullParameter(onPaymentComplete, (String)"onPaymentComplete");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.transactionRepository = transactionRepository;
        this.transactionAccessData = transactionAccessData;
        this.stringProvider = stringProvider;
        this.onPaymentComplete = onPaymentComplete;
        this.onError = onError;
        this._cardPaymentsState = StateFlowKt.MutableStateFlow((Object)CardPaymentsState.CardDetails.INSTANCE);
        this.paymentFlowVmStores = new LinkedHashMap();
        this.cardFlowViewModelStoreOwner = new ViewModelStoreOwner(this){
            final /* synthetic */ CardPaymentViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public ViewModelStore getViewModelStore() {
                String string2 = this.this$0.getCardPaymentsState().getValue().getClass().getCanonicalName();
                if (string2 == null) {
                    cardFlowViewModelStoreOwner.1 var2_1 = this;
                    CardPaymentViewModel cardPaymentViewModel = this.this$0;
                    cardFlowViewModelStoreOwner.1 $this$_get_viewModelStore__u24lambda_u240 = var2_1;
                    boolean bl = false;
                    Logger.INSTANCE.error("Unable to get canonical name for " + cardPaymentViewModel.getCardPaymentsState().getValue().getClass(), null);
                    return new ViewModelStore();
                }
                String key = string2;
                ViewModelStore viewModelStore = (ViewModelStore)CardPaymentViewModel.access$getPaymentFlowVmStores$p(this.this$0).get(key);
                if (viewModelStore == null) {
                    cardFlowViewModelStoreOwner.1 var2_2 = this;
                    CardPaymentViewModel cardPaymentViewModel = this.this$0;
                    cardFlowViewModelStoreOwner.1 $this$_get_viewModelStore__u24lambda_u241 = var2_2;
                    boolean bl = false;
                    ViewModelStore store = new ViewModelStore();
                    CardPaymentViewModel.access$getPaymentFlowVmStores$p(cardPaymentViewModel).put(key, store);
                    viewModelStore = store;
                }
                return viewModelStore;
            }
        };
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)this.getCardPaymentsState()), (Function2)((Function2)new Function2<CardPaymentsState, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ CardPaymentViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$filterTo$iv$iv;
                        ResultKt.throwOnFailure((Object)object);
                        CardPaymentsState it = (CardPaymentsState)this.L$0;
                        String string2 = it.getClass().getCanonicalName();
                        if (string2 == null) {
                            return Unit.INSTANCE;
                        }
                        String currentViewModelStoreKey = string2;
                        Iterable $this$filter$iv = this.this$0.paymentFlowVmStores.keySet();
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            String key = (String)element$iv$iv;
                            boolean bl = false;
                            if (!(!Intrinsics.areEqual((Object)key, (Object)currentViewModelStoreKey))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List obsoleteKeys = (List)destination$iv$iv;
                        this.this$0.paymentFlowVmStores.keySet().removeAll(CollectionsKt.toSet((Iterable)obsoleteKeys));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CardPaymentsState p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this));
    }

    @NotNull
    public final StateFlow<CardPaymentsState> getCardPaymentsState() {
        return (StateFlow)this._cardPaymentsState;
    }

    @NotNull
    public final ViewModelStoreOwner getCardFlowViewModelStoreOwner() {
        return this.cardFlowViewModelStoreOwner;
    }

    public final void onPinAuth() {
        CardPaymentsState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            CardPaymentsState it = (CardPaymentsState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)CardPaymentsState.CardPin.INSTANCE)));
    }

    public final void onDateOfBirthAuth() {
        CardPaymentsState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            CardPaymentsState it = (CardPaymentsState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)CardPaymentsState.DateOfBirthAuthentication.INSTANCE)));
    }

    public final void restartCardPayment() {
        CardPaymentsState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            CardPaymentsState it = (CardPaymentsState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)CardPaymentsState.CardDetails.INSTANCE)));
    }

    public final void processCardChargeResponse(@NotNull Object result) {
        block1: {
            Throwable throwable;
            Object object = result;
            if (Result.isSuccess-impl((Object)object)) {
                Charge transaction = (Charge)object;
                boolean bl = false;
                this.parseTransaction(transaction);
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block1;
            Throwable it = throwable = throwable2;
            boolean bl = false;
            this.handleFailure(it);
        }
    }

    public final void process3dsResponse(@NotNull Object result) {
        Object object = result;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl = false;
            String string2 = it.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            Logger.INSTANCE.error(string2, it);
        }
        this.handlePending();
    }

    private final void parseTransaction(Charge charge) {
        switch (WhenMappings.$EnumSwitchMapping$0[charge.getStatus().ordinal()]) {
            case 1: {
                this.onPaymentComplete.invoke((Object)charge);
                break;
            }
            case 2: {
                CardPaymentsState nextValue$iv;
                Object prevValue$iv;
                String string2 = charge.getMessage();
                if (string2 == null) {
                    string2 = this.stringProvider.getString(R.string.generic_error_msg);
                }
                String message = string2;
                MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
                boolean $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    CardPaymentsState it = (CardPaymentsState)prevValue$iv;
                    boolean bl = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)new CardPaymentsState.Error(message, true))));
                break;
            }
            case 3: {
                CardPaymentsState nextValue$iv;
                Object prevValue$iv;
                MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
                boolean $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    CardPaymentsState it = (CardPaymentsState)prevValue$iv;
                    boolean bl = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)new CardPaymentsState.OtpAuth(charge.getDisplayText()))));
                break;
            }
            case 4: {
                CardPaymentsState nextValue$iv;
                Object prevValue$iv;
                MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
                boolean $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    CardPaymentsState it = (CardPaymentsState)prevValue$iv;
                    boolean bl = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)CardPaymentsState.DateOfBirthAuthentication.INSTANCE)));
                break;
            }
            case 5: {
                CardPaymentsState nextValue$iv;
                Object prevValue$iv;
                MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
                boolean $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    CardPaymentsState it = (CardPaymentsState)prevValue$iv;
                    boolean bl = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)CardPaymentsState.CardPin.INSTANCE)));
                break;
            }
            case 6: {
                this.handleAddressAuth(charge);
                break;
            }
            case 7: {
                CardPaymentsState nextValue$iv;
                Object prevValue$iv;
                MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
                boolean $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    CardPaymentsState it = (CardPaymentsState)prevValue$iv;
                    boolean bl = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)CardPaymentsState.PhoneNumberAuth.INSTANCE)));
                break;
            }
            case 8: {
                this.handleRedirect(charge);
                break;
            }
            case 9: {
                this.handlePending();
                break;
            }
            case 10: {
                this.handleTimeout(charge);
            }
        }
    }

    private final void handleAddressAuth(Charge charge) {
        String string2;
        CardPaymentsState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            CardPaymentsState it = (CardPaymentsState)prevValue$iv;
            boolean bl = false;
            string2 = charge.getCountryCode();
            if (string2 != null) continue;
            string2 = "";
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)new CardPaymentsState.AddressAuthentication(string2))));
    }

    private final void handleRedirect(Charge charge) {
        CardPaymentsState nextValue$iv;
        Object prevValue$iv;
        String errorMessage = this.stringProvider.getString(R.string.generic_error_msg);
        String authUrl = charge.getAuthUrl();
        if (authUrl == null) {
            CardPaymentsState nextValue$iv2;
            Object prevValue$iv2;
            MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
            boolean $i$f$update = false;
            do {
                prevValue$iv2 = $this$update$iv.getValue();
                CardPaymentsState it = (CardPaymentsState)prevValue$iv2;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv2, (Object)(nextValue$iv2 = (CardPaymentsState)new CardPaymentsState.Error(errorMessage, false, 2, null))));
            this.onError.invoke((Object)new PaystackError((Throwable)new IllegalStateException("No auth url found")));
            return;
        }
        MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            CardPaymentsState it = (CardPaymentsState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)new CardPaymentsState.RedirectAuth(authUrl))));
    }

    private final void handleTimeout(Charge charge) {
        CardPaymentsState nextValue$iv;
        Object prevValue$iv;
        String string2 = charge.getDisplayText();
        if (string2 == null) {
            string2 = this.stringProvider.getString(R.string.transaction_timed_out);
        }
        String message = string2;
        MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            CardPaymentsState it = (CardPaymentsState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)new CardPaymentsState.Error(message, false))));
        this.onError.invoke((Object)new PaystackError(message, null, 2, null));
    }

    private final void handleFailure(Throwable error) {
        CardPaymentsState nextValue$iv;
        Object prevValue$iv;
        String string2 = error.getMessage();
        if (string2 == null) {
            string2 = "";
        }
        Logger.INSTANCE.error(string2, error);
        if (error instanceof PaystackError && !PaystackErrorExtKt.isFatal((PaystackError)error)) {
            CardPaymentsState nextValue$iv2;
            Object prevValue$iv2;
            MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
            boolean $i$f$update = false;
            do {
                prevValue$iv2 = $this$update$iv.getValue();
                CardPaymentsState it = (CardPaymentsState)prevValue$iv2;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv2, (Object)(nextValue$iv2 = (CardPaymentsState)new CardPaymentsState.Error(((PaystackError)error).getMessage(), true))));
            return;
        }
        String message = this.stringProvider.getString(R.string.generic_error_msg);
        MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            CardPaymentsState it = (CardPaymentsState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)new CardPaymentsState.Error(message, false, 2, null))));
        this.onError.invoke((Object)error);
    }

    private final void handlePending() {
        CardPaymentsState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<CardPaymentsState> $this$update$iv = this._cardPaymentsState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            CardPaymentsState it = (CardPaymentsState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (CardPaymentsState)CardPaymentsState.Pending.INSTANCE)));
        this.checkPendingCharge();
    }

    private final void checkPendingCharge() {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CardPaymentViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = CardPaymentViewModel.access$getTransactionRepository$p(this.this$0).checkPendingCharge-gIAlu-s(CardPaymentViewModel.access$getTransactionAccessData$p(this.this$0).getAccessCode(), (Continuation<? super Result<Charge>>)((Continuation)this));
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = ((Result)$result).unbox-impl();
lbl21:
                        // 2 sources

                        result = v1;
                        this.this$0.processCardChargeResponse(result);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ TransactionRepository access$getTransactionRepository$p(CardPaymentViewModel $this) {
        return $this.transactionRepository;
    }

    public static final /* synthetic */ AccessCodeData access$getTransactionAccessData$p(CardPaymentViewModel $this) {
        return $this.transactionAccessData;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/paystack/android_sdk/ui/paymentchannels/card/CardPaymentViewModel$Companion;", "", "()V", "CHECK_PENDING_DELAY_MILLIS", "", "paystack-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TransactionStatus.values().length];
            try {
                nArray[TransactionStatus.Success.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.Failed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.SentOtp.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.SendBirthday.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.SendPin.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.SendAddress.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.SendPhone.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.OpenUrl.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.Pending.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionStatus.Timeout.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

