/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.ui.paymentchannels.card.cardform.models;

import androidx.annotation.StringRes;
import com.paystack.android.core.api.models.CardParams;
import com.paystack.android.ui.R;
import com.paystack.android.ui.components.views.inputs.validators.CardType;
import com.paystack.android.ui.components.views.inputs.validators.CardValidationUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\b\u0018\u0000 &2\u00020\u0001:\u0002&'B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0014H\u00d6\u0001J\u0006\u0010#\u001a\u00020$J\t\u0010%\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006("}, d2={"Lcom/paystack/android/ui/paymentchannels/card/cardform/models/TestCard;", "", "expectedResult", "Lcom/paystack/android/ui/paymentchannels/card/cardform/models/TestCard$ExpectedResult;", "number", "", "cvv", "month", "year", "(Lcom/paystack/android/ui/paymentchannels/card/cardform/models/TestCard$ExpectedResult;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "cardScheme", "Lcom/paystack/android/ui/components/views/inputs/validators/CardType;", "getCardScheme", "()Lcom/paystack/android/ui/components/views/inputs/validators/CardType;", "getCvv", "()Ljava/lang/String;", "getExpectedResult", "()Lcom/paystack/android/ui/paymentchannels/card/cardform/models/TestCard$ExpectedResult;", "getMonth", "nameRes", "", "getNameRes", "()I", "getNumber", "getYear", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toCardParams", "Lcom/paystack/android/core/api/models/CardParams;", "toString", "Companion", "ExpectedResult", "paystack-ui_release"})
public final class TestCard {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExpectedResult expectedResult;
    @NotNull
    private final String number;
    @NotNull
    private final String cvv;
    @NotNull
    private final String month;
    @NotNull
    private final String year;

    public TestCard(@NotNull ExpectedResult expectedResult, @NotNull String number, @NotNull String cvv, @NotNull String month, @NotNull String year) {
        Intrinsics.checkNotNullParameter((Object)((Object)expectedResult), (String)"expectedResult");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)cvv, (String)"cvv");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        this.expectedResult = expectedResult;
        this.number = number;
        this.cvv = cvv;
        this.month = month;
        this.year = year;
    }

    @NotNull
    public final ExpectedResult getExpectedResult() {
        return this.expectedResult;
    }

    @NotNull
    public final String getNumber() {
        return this.number;
    }

    @NotNull
    public final String getCvv() {
        return this.cvv;
    }

    @NotNull
    public final String getMonth() {
        return this.month;
    }

    @NotNull
    public final String getYear() {
        return this.year;
    }

    @StringRes
    public final int getNameRes() {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[this.expectedResult.ordinal()]) {
            case 1: {
                n = R.string.pstk_success;
                break;
            }
            case 2: {
                n = R.string.pstk_bank_authentication;
                break;
            }
            case 3: {
                n = R.string.pstk_declined;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @NotNull
    public final CardType getCardScheme() {
        return CardValidationUtils.INSTANCE.checkCardScheme(this.number);
    }

    @NotNull
    public final CardParams toCardParams() {
        return new CardParams(this.number, this.cvv, this.month, this.year, null, 16, null);
    }

    @NotNull
    public final ExpectedResult component1() {
        return this.expectedResult;
    }

    @NotNull
    public final String component2() {
        return this.number;
    }

    @NotNull
    public final String component3() {
        return this.cvv;
    }

    @NotNull
    public final String component4() {
        return this.month;
    }

    @NotNull
    public final String component5() {
        return this.year;
    }

    @NotNull
    public final TestCard copy(@NotNull ExpectedResult expectedResult, @NotNull String number, @NotNull String cvv, @NotNull String month, @NotNull String year) {
        Intrinsics.checkNotNullParameter((Object)((Object)expectedResult), (String)"expectedResult");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)cvv, (String)"cvv");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        return new TestCard(expectedResult, number, cvv, month, year);
    }

    public static /* synthetic */ TestCard copy$default(TestCard testCard, ExpectedResult expectedResult, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            expectedResult = testCard.expectedResult;
        }
        if ((n & 2) != 0) {
            string2 = testCard.number;
        }
        if ((n & 4) != 0) {
            string3 = testCard.cvv;
        }
        if ((n & 8) != 0) {
            string4 = testCard.month;
        }
        if ((n & 0x10) != 0) {
            string5 = testCard.year;
        }
        return testCard.copy(expectedResult, string2, string3, string4, string5);
    }

    @NotNull
    public String toString() {
        return "TestCard(expectedResult=" + this.expectedResult + ", number=" + this.number + ", cvv=" + this.cvv + ", month=" + this.month + ", year=" + this.year + ")";
    }

    public int hashCode() {
        int result = this.expectedResult.hashCode();
        result = result * 31 + this.number.hashCode();
        result = result * 31 + this.cvv.hashCode();
        result = result * 31 + this.month.hashCode();
        result = result * 31 + this.year.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TestCard)) {
            return false;
        }
        TestCard testCard = (TestCard)other;
        if (this.expectedResult != testCard.expectedResult) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.number, (Object)testCard.number)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cvv, (Object)testCard.cvv)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.month, (Object)testCard.month)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.year, (Object)testCard.year);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0006"}, d2={"Lcom/paystack/android/ui/paymentchannels/card/cardform/models/TestCard$Companion;", "", "()V", "all", "", "Lcom/paystack/android/ui/paymentchannels/card/cardform/models/TestCard;", "paystack-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<TestCard> all() {
            Object[] objectArray = new TestCard[]{new TestCard(ExpectedResult.SUCCESS, "4084084084084081", "408", "12", "30"), new TestCard(ExpectedResult.BANK_AUTH, "4084080000000409", "000", "01", "30"), new TestCard(ExpectedResult.DECLINED, "4084080000005408", "001", "01", "30")};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/paystack/android/ui/paymentchannels/card/cardform/models/TestCard$ExpectedResult;", "", "(Ljava/lang/String;I)V", "SUCCESS", "BANK_AUTH", "DECLINED", "paystack-ui_release"})
    public static final class ExpectedResult
    extends Enum<ExpectedResult> {
        public static final /* enum */ ExpectedResult SUCCESS = new ExpectedResult();
        public static final /* enum */ ExpectedResult BANK_AUTH = new ExpectedResult();
        public static final /* enum */ ExpectedResult DECLINED = new ExpectedResult();
        private static final /* synthetic */ ExpectedResult[] $VALUES;

        public static ExpectedResult[] values() {
            return (ExpectedResult[])$VALUES.clone();
        }

        public static ExpectedResult valueOf(String value) {
            return Enum.valueOf(ExpectedResult.class, value);
        }

        static {
            $VALUES = expectedResultArray = new ExpectedResult[]{ExpectedResult.SUCCESS, ExpectedResult.BANK_AUTH, ExpectedResult.DECLINED};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExpectedResult.values().length];
            try {
                nArray[ExpectedResult.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExpectedResult.BANK_AUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExpectedResult.DECLINED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

