package com.paystack.android.ui.paymentchannels.mobilemoney

import android.content.Context
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import com.paystack.android.core.api.models.AccessCodeData
import com.paystack.android.ui.data.dataComponent
import com.paystack.android.ui.models.Charge
import com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.MpesaViewModel
import com.paystack.android.ui.utilities.utilitiesComponent

@Suppress("UNCHECKED_CAST")
internal class MobileMoneyViewModelProviderFactory(
    private val context: Context,
    private val transactionAccessData: AccessCodeData,
    private val onPaymentComplete: (Charge) -> Unit,
    private val onError: (Throwable) -> Unit,
    private val providerKey: String,
) : ViewModelProvider.Factory {

    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        return when (modelClass) {
            MpesaViewModel::class.java -> MpesaViewModel(
                accessCodeData = transactionAccessData,
                providerKey = providerKey,
                onPaymentComplete = onPaymentComplete,
                onError = onError,
                transactionRepository = dataComponent().transactionRepository,
                stringProvider = utilitiesComponent(context).stringProvider
            ) as T

            else -> throw IllegalArgumentException("Unknown ViewModel class")
        }
    }
}
