package com.paystack.androiddesignsystem.typography

import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.Font
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.sp
import com.paystack.androiddesignsystem.R

private val graphikFontFamily = FontFamily(
    Font(R.font.graphik_regular, FontWeight.Normal),
    Font(R.font.graphik_medium, FontWeight.Medium)
)

data class BodyTypography(

    /**
     * To emphasize important information, usually short and not a whole sentence
     * R: Regular
     */
    val body16R: TextStyle = TextStyle(
        fontFamily = graphikFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 16.sp,
        lineHeight = 24.sp
    ),
    /**
     * To emphasize important information, usually short and not a whole sentence
     * M: Medium
     */
    val body16M: TextStyle = TextStyle(
        fontFamily = graphikFontFamily,
        fontWeight = FontWeight.Medium,
        fontSize = 16.sp,
        lineHeight = 24.sp
    ),
    /**
     * For 1-2 line sentences, usually for descriptions or more information
     * R: Regular
     */
    val body14R: TextStyle = TextStyle(
        fontFamily = graphikFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 14.sp,
        lineHeight = 21.sp
    ),
    /**
     * To emphasize important information, usually short and not a whole sentence
     * M: Medium
     */
    val body14M: TextStyle = TextStyle(
        fontFamily = graphikFontFamily,
        fontWeight = FontWeight.Medium,
        fontSize = 14.sp,
        lineHeight = 21.sp
    ),
    /**
     * Card information, such as titles for Name and Email
     * R: Regular
     */
    val body12R: TextStyle = TextStyle(
        fontFamily = graphikFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 12.sp,
        lineHeight = 18.sp
    ),
    /**
     * Card information, such as titles for Name and Email
     * M: Medium
     */
    val body12M: TextStyle = TextStyle(
        fontFamily = graphikFontFamily,
        fontWeight = FontWeight.Medium,
        fontSize = 12.sp,
        lineHeight = 18.sp
    ),
    /**
     * Secondary information, such as time stamps and process labels
     * R: Regular
     */
    val smallTextR: TextStyle = TextStyle(
        fontFamily = graphikFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 10.sp,
        lineHeight = 15.sp
    ),
    /**
     * Secondary information, such as time stamps and process labels
     * M: Medium
     */
    val smallTextM: TextStyle = TextStyle(
        fontFamily = graphikFontFamily,
        fontWeight = FontWeight.Medium,
        fontSize = 10.sp,
        lineHeight = 15.sp
    )
)
