package com.paystack.androiddesignsystem.dimensions

import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp

data class BorderRadius(
    /**
     * For very small icons, shapes, etc..
     */
    val xSmall: Dp = 1.dp,
    /**
     * For small icons and boxes, such as checkboxes
     */
    val small: Dp = 4.dp,
    /**
     * Use this for text inputs, dropdowns, menus, labels and pagination. Small buttons on Web
     */
    val medium: Dp = 6.dp,
    /**
     * Use this for containers and popups: cards, modals, tooltips and toasts. Full screen buttons on Mobile
     */
    val large: Dp = 8.dp
)
