package com.paystack.androiddesignsystem.typography

import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.Font
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.sp
import com.paystack.androiddesignsystem.R

private val graphikFontFamily = FontFamily(
    Font(R.font.graphik_regular, FontWeight.Normal),
    Font(R.font.graphik_semibold, FontWeight.SemiBold)
)

private val boingFontFamily = FontFamily(
    Font(R.font.boing_semi_bold, FontWeight.SemiBold)
)

data class HeadingTypography(
    /**
     * Highlighting the most important information on the page (usually a number) Example: Amount of credit, or money to pay (NGN1,000)
     */
    val heading1: TextStyle = TextStyle(
        fontFamily = boingFontFamily,
        fontWeight = FontWeight.SemiBold,
        fontSize = 34.sp,
        lineHeight = 48.sp
    ),
    /**
     * Highlighting the most important information on the page (usually a number) Example: Amount of credit, or money to pay (NGN1,000)
     */
    val heading2: TextStyle = TextStyle(
        fontFamily = boingFontFamily,
        fontWeight = FontWeight.SemiBold,
        fontSize = 24.sp,
        lineHeight = 36.sp
    ),
    /**
     * Page title in header for mobile
     */
    val heading3: TextStyle = TextStyle(
        fontFamily = boingFontFamily,
        fontWeight = FontWeight.SemiBold,
        fontSize = 20.sp,
        lineHeight = 30.sp
    ),
    /**
     * Secondary title to the page
     */
    val subtitle1: TextStyle = TextStyle(
        fontFamily = boingFontFamily,
        fontWeight = FontWeight.SemiBold,
        fontSize = 18.sp,
        lineHeight = 27.sp
    ),
    /**
     * Secondary title to the page
     */
    val subtitle2: TextStyle = TextStyle(
        fontFamily = boingFontFamily,
        fontWeight = FontWeight.SemiBold,
        fontSize = 16.sp,
        lineHeight = 24.sp
    ),
    /**
     * Secondary subtitle
     */
    val secondarySubtitleRegular: TextStyle = TextStyle(
        fontFamily = graphikFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 12.sp,
        lineHeight = 18.sp
    ),
    /**
     * Secondary subtitle or chips
     */
    val secondarySubtitleMedium: TextStyle = TextStyle(
        fontFamily = graphikFontFamily,
        fontWeight = FontWeight.SemiBold,
        fontSize = 12.sp,
        lineHeight = 18.sp
    )
)
