// Generated by delombok at Fri Sep 09 13:25:35 CDT 2016
package com.paypal.api.payments;

import com.paypal.base.rest.PayPalModel;
import java.util.List;

public class BankAccount extends PayPalModel {
	/**
	 * ID of the bank account being saved for later use.
	 */
	private String id;
	/**
	 * Account number in either IBAN (max length 34) or BBAN (max length 17) format.
	 */
	private String accountNumber;
	/**
	 * Type of the bank account number (International or Basic Bank Account Number). For more information refer to http://en.wikipedia.org/wiki/International_Bank_Account_Number.
	 */
	private String accountNumberType;
	/**
	 * Routing transit number (aka Bank Code) of the bank (typically for domestic use only - for international use, IBAN includes bank code). For more information refer to http://en.wikipedia.org/wiki/Bank_code.
	 */
	private String routingNumber;
	/**
	 * Type of the bank account.
	 */
	private String accountType;
	/**
	 * A customer designated name.
	 */
	private String accountName;
	/**
	 * Type of the check when this information was obtained through a check by the facilitator or merchant.
	 */
	private String checkType;
	/**
	 * How the check was obtained from the customer, if check was the source of the information provided.
	 */
	private String authType;
	/**
	 * Time at which the authorization (or check) was captured. Use this field if the user authorization needs to be captured due to any privacy requirements.
	 */
	private String authCaptureTimestamp;
	/**
	 * Name of the bank.
	 */
	private String bankName;
	/**
	 * 2 letter country code of the Bank.
	 */
	private String countryCode;
	/**
	 * Account holder's first name.
	 */
	private String firstName;
	/**
	 * Account holder's last name.
	 */
	private String lastName;
	/**
	 * Birth date of the bank account holder.
	 */
	private String birthDate;
	/**
	 * Billing address.
	 */
	private Address billingAddress;
	/**
	 * State of this funding instrument.
	 */
	private String state;
	/**
	 * Confirmation status of a bank account.
	 */
	private String confirmationStatus;
	/**
	 * [DEPRECATED] Use external_customer_id instead.
	 */
	private String payerId;
	/**
	 * A unique identifier of the customer to whom this bank account belongs to. Generated and provided by the facilitator. This is required when creating or using a stored funding instrument in vault.
	 */
	private String externalCustomerId;
	/**
	 * A unique identifier of the merchant for which this bank account has been stored for. Generated and provided by the facilitator so it can be used to restrict the usage of the bank account to the specific merchnt.
	 */
	private String merchantId;
	/**
	 * Time the resource was created.
	 */
	private String createTime;
	/**
	 * Time the resource was last updated.
	 */
	private String updateTime;
	/**
	 * Date/Time until this resource can be used to fund a payment.
	 */
	private String validUntil;
	/**
	 */
	private List<DefinitionsLinkdescription> links;

	/**
	 * Default Constructor
	 */
	public BankAccount() {
	}

	/**
	 * Parameterized Constructor
	 */
	public BankAccount(String accountNumber, String accountNumberType) {
		this.accountNumber = accountNumber;
		this.accountNumberType = accountNumberType;
	}

	/**
	 * ID of the bank account being saved for later use.
	 */
	@java.lang.SuppressWarnings("all")
	public String getId() {
		return this.id;
	}

	/**
	 * Account number in either IBAN (max length 34) or BBAN (max length 17) format.
	 */
	@java.lang.SuppressWarnings("all")
	public String getAccountNumber() {
		return this.accountNumber;
	}

	/**
	 * Type of the bank account number (International or Basic Bank Account Number). For more information refer to http://en.wikipedia.org/wiki/International_Bank_Account_Number.
	 */
	@java.lang.SuppressWarnings("all")
	public String getAccountNumberType() {
		return this.accountNumberType;
	}

	/**
	 * Routing transit number (aka Bank Code) of the bank (typically for domestic use only - for international use, IBAN includes bank code). For more information refer to http://en.wikipedia.org/wiki/Bank_code.
	 */
	@java.lang.SuppressWarnings("all")
	public String getRoutingNumber() {
		return this.routingNumber;
	}

	/**
	 * Type of the bank account.
	 */
	@java.lang.SuppressWarnings("all")
	public String getAccountType() {
		return this.accountType;
	}

	/**
	 * A customer designated name.
	 */
	@java.lang.SuppressWarnings("all")
	public String getAccountName() {
		return this.accountName;
	}

	/**
	 * Type of the check when this information was obtained through a check by the facilitator or merchant.
	 */
	@java.lang.SuppressWarnings("all")
	public String getCheckType() {
		return this.checkType;
	}

	/**
	 * How the check was obtained from the customer, if check was the source of the information provided.
	 */
	@java.lang.SuppressWarnings("all")
	public String getAuthType() {
		return this.authType;
	}

	/**
	 * Time at which the authorization (or check) was captured. Use this field if the user authorization needs to be captured due to any privacy requirements.
	 */
	@java.lang.SuppressWarnings("all")
	public String getAuthCaptureTimestamp() {
		return this.authCaptureTimestamp;
	}

	/**
	 * Name of the bank.
	 */
	@java.lang.SuppressWarnings("all")
	public String getBankName() {
		return this.bankName;
	}

	/**
	 * 2 letter country code of the Bank.
	 */
	@java.lang.SuppressWarnings("all")
	public String getCountryCode() {
		return this.countryCode;
	}

	/**
	 * Account holder's first name.
	 */
	@java.lang.SuppressWarnings("all")
	public String getFirstName() {
		return this.firstName;
	}

	/**
	 * Account holder's last name.
	 */
	@java.lang.SuppressWarnings("all")
	public String getLastName() {
		return this.lastName;
	}

	/**
	 * Birth date of the bank account holder.
	 */
	@java.lang.SuppressWarnings("all")
	public String getBirthDate() {
		return this.birthDate;
	}

	/**
	 * Billing address.
	 */
	@java.lang.SuppressWarnings("all")
	public Address getBillingAddress() {
		return this.billingAddress;
	}

	/**
	 * State of this funding instrument.
	 */
	@java.lang.SuppressWarnings("all")
	public String getState() {
		return this.state;
	}

	/**
	 * Confirmation status of a bank account.
	 */
	@java.lang.SuppressWarnings("all")
	public String getConfirmationStatus() {
		return this.confirmationStatus;
	}

	/**
	 * [DEPRECATED] Use external_customer_id instead.
	 */
	@java.lang.SuppressWarnings("all")
	public String getPayerId() {
		return this.payerId;
	}

	/**
	 * A unique identifier of the customer to whom this bank account belongs to. Generated and provided by the facilitator. This is required when creating or using a stored funding instrument in vault.
	 */
	@java.lang.SuppressWarnings("all")
	public String getExternalCustomerId() {
		return this.externalCustomerId;
	}

	/**
	 * A unique identifier of the merchant for which this bank account has been stored for. Generated and provided by the facilitator so it can be used to restrict the usage of the bank account to the specific merchnt.
	 */
	@java.lang.SuppressWarnings("all")
	public String getMerchantId() {
		return this.merchantId;
	}

	/**
	 * Time the resource was created.
	 */
	@java.lang.SuppressWarnings("all")
	public String getCreateTime() {
		return this.createTime;
	}

	/**
	 * Time the resource was last updated.
	 */
	@java.lang.SuppressWarnings("all")
	public String getUpdateTime() {
		return this.updateTime;
	}

	/**
	 * Date/Time until this resource can be used to fund a payment.
	 */
	@java.lang.SuppressWarnings("all")
	public String getValidUntil() {
		return this.validUntil;
	}

	/**
	 */
	@java.lang.SuppressWarnings("all")
	public List<DefinitionsLinkdescription> getLinks() {
		return this.links;
	}

	/**
	 * ID of the bank account being saved for later use.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setId(final String id) {
		this.id = id;
		return this;
	}

	/**
	 * Account number in either IBAN (max length 34) or BBAN (max length 17) format.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setAccountNumber(final String accountNumber) {
		this.accountNumber = accountNumber;
		return this;
	}

	/**
	 * Type of the bank account number (International or Basic Bank Account Number). For more information refer to http://en.wikipedia.org/wiki/International_Bank_Account_Number.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setAccountNumberType(final String accountNumberType) {
		this.accountNumberType = accountNumberType;
		return this;
	}

	/**
	 * Routing transit number (aka Bank Code) of the bank (typically for domestic use only - for international use, IBAN includes bank code). For more information refer to http://en.wikipedia.org/wiki/Bank_code.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setRoutingNumber(final String routingNumber) {
		this.routingNumber = routingNumber;
		return this;
	}

	/**
	 * Type of the bank account.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setAccountType(final String accountType) {
		this.accountType = accountType;
		return this;
	}

	/**
	 * A customer designated name.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setAccountName(final String accountName) {
		this.accountName = accountName;
		return this;
	}

	/**
	 * Type of the check when this information was obtained through a check by the facilitator or merchant.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setCheckType(final String checkType) {
		this.checkType = checkType;
		return this;
	}

	/**
	 * How the check was obtained from the customer, if check was the source of the information provided.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setAuthType(final String authType) {
		this.authType = authType;
		return this;
	}

	/**
	 * Time at which the authorization (or check) was captured. Use this field if the user authorization needs to be captured due to any privacy requirements.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setAuthCaptureTimestamp(final String authCaptureTimestamp) {
		this.authCaptureTimestamp = authCaptureTimestamp;
		return this;
	}

	/**
	 * Name of the bank.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setBankName(final String bankName) {
		this.bankName = bankName;
		return this;
	}

	/**
	 * 2 letter country code of the Bank.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setCountryCode(final String countryCode) {
		this.countryCode = countryCode;
		return this;
	}

	/**
	 * Account holder's first name.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setFirstName(final String firstName) {
		this.firstName = firstName;
		return this;
	}

	/**
	 * Account holder's last name.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setLastName(final String lastName) {
		this.lastName = lastName;
		return this;
	}

	/**
	 * Birth date of the bank account holder.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setBirthDate(final String birthDate) {
		this.birthDate = birthDate;
		return this;
	}

	/**
	 * Billing address.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setBillingAddress(final Address billingAddress) {
		this.billingAddress = billingAddress;
		return this;
	}

	/**
	 * State of this funding instrument.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setState(final String state) {
		this.state = state;
		return this;
	}

	/**
	 * Confirmation status of a bank account.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setConfirmationStatus(final String confirmationStatus) {
		this.confirmationStatus = confirmationStatus;
		return this;
	}

	/**
	 * [DEPRECATED] Use external_customer_id instead.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setPayerId(final String payerId) {
		this.payerId = payerId;
		return this;
	}

	/**
	 * A unique identifier of the customer to whom this bank account belongs to. Generated and provided by the facilitator. This is required when creating or using a stored funding instrument in vault.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setExternalCustomerId(final String externalCustomerId) {
		this.externalCustomerId = externalCustomerId;
		return this;
	}

	/**
	 * A unique identifier of the merchant for which this bank account has been stored for. Generated and provided by the facilitator so it can be used to restrict the usage of the bank account to the specific merchnt.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setMerchantId(final String merchantId) {
		this.merchantId = merchantId;
		return this;
	}

	/**
	 * Time the resource was created.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setCreateTime(final String createTime) {
		this.createTime = createTime;
		return this;
	}

	/**
	 * Time the resource was last updated.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setUpdateTime(final String updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	/**
	 * Date/Time until this resource can be used to fund a payment.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setValidUntil(final String validUntil) {
		this.validUntil = validUntil;
		return this;
	}

	/**
	 *
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public BankAccount setLinks(final List<DefinitionsLinkdescription> links) {
		this.links = links;
		return this;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof BankAccount)) return false;
		final BankAccount other = (BankAccount) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		if (!super.equals(o)) return false;
		final java.lang.Object this$id = this.getId();
		final java.lang.Object other$id = other.getId();
		if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
		final java.lang.Object this$accountNumber = this.getAccountNumber();
		final java.lang.Object other$accountNumber = other.getAccountNumber();
		if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) return false;
		final java.lang.Object this$accountNumberType = this.getAccountNumberType();
		final java.lang.Object other$accountNumberType = other.getAccountNumberType();
		if (this$accountNumberType == null ? other$accountNumberType != null : !this$accountNumberType.equals(other$accountNumberType)) return false;
		final java.lang.Object this$routingNumber = this.getRoutingNumber();
		final java.lang.Object other$routingNumber = other.getRoutingNumber();
		if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) return false;
		final java.lang.Object this$accountType = this.getAccountType();
		final java.lang.Object other$accountType = other.getAccountType();
		if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) return false;
		final java.lang.Object this$accountName = this.getAccountName();
		final java.lang.Object other$accountName = other.getAccountName();
		if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) return false;
		final java.lang.Object this$checkType = this.getCheckType();
		final java.lang.Object other$checkType = other.getCheckType();
		if (this$checkType == null ? other$checkType != null : !this$checkType.equals(other$checkType)) return false;
		final java.lang.Object this$authType = this.getAuthType();
		final java.lang.Object other$authType = other.getAuthType();
		if (this$authType == null ? other$authType != null : !this$authType.equals(other$authType)) return false;
		final java.lang.Object this$authCaptureTimestamp = this.getAuthCaptureTimestamp();
		final java.lang.Object other$authCaptureTimestamp = other.getAuthCaptureTimestamp();
		if (this$authCaptureTimestamp == null ? other$authCaptureTimestamp != null : !this$authCaptureTimestamp.equals(other$authCaptureTimestamp)) return false;
		final java.lang.Object this$bankName = this.getBankName();
		final java.lang.Object other$bankName = other.getBankName();
		if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
		final java.lang.Object this$countryCode = this.getCountryCode();
		final java.lang.Object other$countryCode = other.getCountryCode();
		if (this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode)) return false;
		final java.lang.Object this$firstName = this.getFirstName();
		final java.lang.Object other$firstName = other.getFirstName();
		if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) return false;
		final java.lang.Object this$lastName = this.getLastName();
		final java.lang.Object other$lastName = other.getLastName();
		if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) return false;
		final java.lang.Object this$birthDate = this.getBirthDate();
		final java.lang.Object other$birthDate = other.getBirthDate();
		if (this$birthDate == null ? other$birthDate != null : !this$birthDate.equals(other$birthDate)) return false;
		final java.lang.Object this$billingAddress = this.getBillingAddress();
		final java.lang.Object other$billingAddress = other.getBillingAddress();
		if (this$billingAddress == null ? other$billingAddress != null : !this$billingAddress.equals(other$billingAddress)) return false;
		final java.lang.Object this$state = this.getState();
		final java.lang.Object other$state = other.getState();
		if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
		final java.lang.Object this$confirmationStatus = this.getConfirmationStatus();
		final java.lang.Object other$confirmationStatus = other.getConfirmationStatus();
		if (this$confirmationStatus == null ? other$confirmationStatus != null : !this$confirmationStatus.equals(other$confirmationStatus)) return false;
		final java.lang.Object this$payerId = this.getPayerId();
		final java.lang.Object other$payerId = other.getPayerId();
		if (this$payerId == null ? other$payerId != null : !this$payerId.equals(other$payerId)) return false;
		final java.lang.Object this$externalCustomerId = this.getExternalCustomerId();
		final java.lang.Object other$externalCustomerId = other.getExternalCustomerId();
		if (this$externalCustomerId == null ? other$externalCustomerId != null : !this$externalCustomerId.equals(other$externalCustomerId)) return false;
		final java.lang.Object this$merchantId = this.getMerchantId();
		final java.lang.Object other$merchantId = other.getMerchantId();
		if (this$merchantId == null ? other$merchantId != null : !this$merchantId.equals(other$merchantId)) return false;
		final java.lang.Object this$createTime = this.getCreateTime();
		final java.lang.Object other$createTime = other.getCreateTime();
		if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) return false;
		final java.lang.Object this$updateTime = this.getUpdateTime();
		final java.lang.Object other$updateTime = other.getUpdateTime();
		if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) return false;
		final java.lang.Object this$validUntil = this.getValidUntil();
		final java.lang.Object other$validUntil = other.getValidUntil();
		if (this$validUntil == null ? other$validUntil != null : !this$validUntil.equals(other$validUntil)) return false;
		final java.lang.Object this$links = this.getLinks();
		final java.lang.Object other$links = other.getLinks();
		if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof BankAccount;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		result = result * PRIME + super.hashCode();
		final java.lang.Object $id = this.getId();
		result = result * PRIME + ($id == null ? 43 : $id.hashCode());
		final java.lang.Object $accountNumber = this.getAccountNumber();
		result = result * PRIME + ($accountNumber == null ? 43 : $accountNumber.hashCode());
		final java.lang.Object $accountNumberType = this.getAccountNumberType();
		result = result * PRIME + ($accountNumberType == null ? 43 : $accountNumberType.hashCode());
		final java.lang.Object $routingNumber = this.getRoutingNumber();
		result = result * PRIME + ($routingNumber == null ? 43 : $routingNumber.hashCode());
		final java.lang.Object $accountType = this.getAccountType();
		result = result * PRIME + ($accountType == null ? 43 : $accountType.hashCode());
		final java.lang.Object $accountName = this.getAccountName();
		result = result * PRIME + ($accountName == null ? 43 : $accountName.hashCode());
		final java.lang.Object $checkType = this.getCheckType();
		result = result * PRIME + ($checkType == null ? 43 : $checkType.hashCode());
		final java.lang.Object $authType = this.getAuthType();
		result = result * PRIME + ($authType == null ? 43 : $authType.hashCode());
		final java.lang.Object $authCaptureTimestamp = this.getAuthCaptureTimestamp();
		result = result * PRIME + ($authCaptureTimestamp == null ? 43 : $authCaptureTimestamp.hashCode());
		final java.lang.Object $bankName = this.getBankName();
		result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
		final java.lang.Object $countryCode = this.getCountryCode();
		result = result * PRIME + ($countryCode == null ? 43 : $countryCode.hashCode());
		final java.lang.Object $firstName = this.getFirstName();
		result = result * PRIME + ($firstName == null ? 43 : $firstName.hashCode());
		final java.lang.Object $lastName = this.getLastName();
		result = result * PRIME + ($lastName == null ? 43 : $lastName.hashCode());
		final java.lang.Object $birthDate = this.getBirthDate();
		result = result * PRIME + ($birthDate == null ? 43 : $birthDate.hashCode());
		final java.lang.Object $billingAddress = this.getBillingAddress();
		result = result * PRIME + ($billingAddress == null ? 43 : $billingAddress.hashCode());
		final java.lang.Object $state = this.getState();
		result = result * PRIME + ($state == null ? 43 : $state.hashCode());
		final java.lang.Object $confirmationStatus = this.getConfirmationStatus();
		result = result * PRIME + ($confirmationStatus == null ? 43 : $confirmationStatus.hashCode());
		final java.lang.Object $payerId = this.getPayerId();
		result = result * PRIME + ($payerId == null ? 43 : $payerId.hashCode());
		final java.lang.Object $externalCustomerId = this.getExternalCustomerId();
		result = result * PRIME + ($externalCustomerId == null ? 43 : $externalCustomerId.hashCode());
		final java.lang.Object $merchantId = this.getMerchantId();
		result = result * PRIME + ($merchantId == null ? 43 : $merchantId.hashCode());
		final java.lang.Object $createTime = this.getCreateTime();
		result = result * PRIME + ($createTime == null ? 43 : $createTime.hashCode());
		final java.lang.Object $updateTime = this.getUpdateTime();
		result = result * PRIME + ($updateTime == null ? 43 : $updateTime.hashCode());
		final java.lang.Object $validUntil = this.getValidUntil();
		result = result * PRIME + ($validUntil == null ? 43 : $validUntil.hashCode());
		final java.lang.Object $links = this.getLinks();
		result = result * PRIME + ($links == null ? 43 : $links.hashCode());
		return result;
	}
}
