/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.paypal.base.ConfigManager;
import com.paypal.base.ConnectionManager;
import com.paypal.base.HttpConfiguration;
import com.paypal.base.HttpConnection;
import com.paypal.base.SDKUtil;
import com.paypal.base.SDKVersion;
import com.paypal.base.codec.binary.Base64;
import com.paypal.base.exception.ClientActionRequiredException;
import com.paypal.base.exception.HttpErrorException;
import com.paypal.base.rest.AccessToken;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.sdk.info.SDKVersionImpl;
import com.paypal.base.util.UserAgentHeader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OAuthTokenCredential {
    private static final Logger log = LoggerFactory.getLogger(OAuthTokenCredential.class);
    private static Map<String, AccessToken> ACCESS_TOKENS = new ConcurrentHashMap<String, AccessToken>();
    private static String OAUTH_TOKEN_PATH = "/v1/oauth2/token";
    private String clientID;
    private String clientSecret;
    private Map<String, String> headers = new HashMap<String, String>();
    private String refreshToken;
    @Deprecated
    private final AccessToken __accessToken;
    private Map<String, String> configurationMap;
    private SDKVersion sdkVersion;

    public static void setOAUTH_TOKEN_PATH(String oauthTokenPath) {
        OAUTH_TOKEN_PATH = oauthTokenPath;
    }

    @Deprecated
    OAuthTokenCredential(String accessToken) {
        this.__accessToken = new AccessToken(accessToken, 1L);
    }

    public OAuthTokenCredential(String clientID, String clientSecret) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.configurationMap = SDKUtil.combineDefaultMap(ConfigManager.getInstance().getConfigurationMap());
        this.sdkVersion = new SDKVersionImpl();
        this.__accessToken = null;
    }

    public OAuthTokenCredential(String clientID, String clientSecret, Map<String, String> configurationMap) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.configurationMap = SDKUtil.combineDefaultMap(configurationMap);
        this.sdkVersion = new SDKVersionImpl();
        this.__accessToken = null;
    }

    synchronized OAuthTokenCredential setRefreshToken(String refreshToken) {
        if (!this.hasCredentials()) {
            throw new IllegalArgumentException("ClientID and Secret are required. Please use OAuthTokenCredential(String clientID, String clientSecret)");
        }
        this.refreshToken = refreshToken;
        return this;
    }

    public boolean hasCredentials() {
        return this.clientID != null && this.clientSecret != null;
    }

    public OAuthTokenCredential setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public OAuthTokenCredential addHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public OAuthTokenCredential addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken() throws PayPalRESTException {
        if (this.__accessToken != null) {
            return this.__accessToken.getAccessToken();
        }
        Map<String, AccessToken> map = ACCESS_TOKENS;
        synchronized (map) {
            if (this.isRegenerationRequired()) {
                this.generateAccessToken();
            }
            return ACCESS_TOKENS.get(this.getCacheTokenKey()).getAccessToken();
        }
    }

    private boolean isRegenerationRequired() {
        AccessToken token = ACCESS_TOKENS.get(this.getCacheTokenKey());
        if (token == null) {
            return this.hasCredentials();
        }
        return token.getAccessToken() == null || this.hasCredentials() && token.expiresIn() <= 0L;
    }

    public String getAuthorizationHeader() throws PayPalRESTException {
        String base64EncodedString = this.generateBase64String(this.clientID + ":" + this.clientSecret);
        return "Basic " + base64EncodedString;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public long expiresIn() {
        AccessToken token = ACCESS_TOKENS.get(this.getCacheTokenKey());
        return token != null ? token.getExpires() : -1L;
    }

    public OAuthTokenCredential addConfiguration(String key, String value) {
        if (this.configurationMap == null) {
            this.configurationMap = new HashMap<String, String>();
        }
        this.configurationMap.put(key, value);
        return this;
    }

    public OAuthTokenCredential addConfigurations(Map<String, String> configurations) {
        if (this.configurationMap == null) {
            this.configurationMap = new HashMap<String, String>();
        }
        this.configurationMap.putAll(configurations);
        return this;
    }

    public OAuthTokenCredential setConfigurations(Map<String, String> configurations) {
        this.configurationMap = configurations;
        return this;
    }

    public Map<String, String> getConfigurations() {
        return this.configurationMap;
    }

    public String getConfiguration(String key) {
        if (this.configurationMap != null) {
            return this.configurationMap.get(key);
        }
        return null;
    }

    private synchronized void generateAccessToken() throws PayPalRESTException {
        String base64ClientID = this.generateBase64String(this.clientID + ":" + this.clientSecret);
        try {
            HttpConnection connection = ConnectionManager.getInstance().getConnection();
            HttpConfiguration httpConfiguration = this.getOAuthHttpConfiguration();
            connection.createAndconfigureHttpConnection(httpConfiguration);
            this.headers.put("Authorization", "Basic " + base64ClientID);
            this.headers.put("Accept", "application/json");
            this.headers.put("Content-Type", "application/x-www-form-urlencoded");
            UserAgentHeader userAgentHeader = new UserAgentHeader(this.sdkVersion != null ? this.sdkVersion.getSDKId() : null, this.sdkVersion != null ? this.sdkVersion.getSDKVersion() : null);
            this.headers.putAll(userAgentHeader.getHeader());
            String postRequest = this.getRequestPayload();
            String mode = this.configurationMap.get("mode");
            if ("live".equalsIgnoreCase(mode) && log.isDebugEnabled()) {
                log.warn("Log level cannot be set to DEBUG in live mode. Skipping request/response logging...");
            }
            if (!"live".equalsIgnoreCase(mode)) {
                log.debug("request header: " + this.headers.toString());
                log.debug("request body: " + postRequest);
            }
            String jsonResponse = connection.execute("", postRequest, this.headers);
            if (!"live".equalsIgnoreCase(mode)) {
                log.debug("response header: " + connection.getResponseHeaderMap().toString());
                log.debug("response: " + jsonResponse);
            }
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse(jsonResponse);
            String accessToken = jsonElement.getAsJsonObject().get("token_type").getAsString() + " " + jsonElement.getAsJsonObject().get("access_token").getAsString();
            long tokenLifeTime = jsonElement.getAsJsonObject().get("expires_in").getAsLong();
            long expires = new Date().getTime() / 1000L + tokenLifeTime;
            ACCESS_TOKENS.put(this.getCacheTokenKey(), new AccessToken(accessToken, expires));
        }
        catch (ClientActionRequiredException e) {
            throw PayPalRESTException.createFromHttpErrorException(e);
        }
        catch (HttpErrorException e) {
            throw PayPalRESTException.createFromHttpErrorException(e);
        }
        catch (Exception e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        finally {
            this.headers.put("Content-Type", "application/json");
        }
    }

    private String getCacheTokenKey() {
        return this.clientID + ":" + this.clientSecret + ":" + this.refreshToken;
    }

    private String generateBase64String(String clientCredentials) throws PayPalRESTException {
        String base64ClientID = null;
        byte[] encoded = null;
        try {
            encoded = Base64.encodeBase64(clientCredentials.getBytes("UTF-8"));
            base64ClientID = new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return base64ClientID;
    }

    protected String getRequestPayload() {
        if (this.refreshToken != null) {
            return String.format("grant_type=refresh_token&refresh_token=%s", this.refreshToken);
        }
        return "grant_type=client_credentials";
    }

    protected HttpConfiguration getOAuthHttpConfiguration() throws MalformedURLException {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setHttpMethod("POST");
        String mode = this.configurationMap.get("mode");
        String endPointUrl = this.configurationMap.get("oauth.EndPoint");
        if (endPointUrl == null || endPointUrl.trim().isEmpty()) {
            if ("sandbox".equalsIgnoreCase(mode)) {
                endPointUrl = "https://api.sandbox.paypal.com/";
            } else if ("live".equalsIgnoreCase(mode)) {
                endPointUrl = "https://api.paypal.com/";
            } else if (endPointUrl == null || endPointUrl.length() <= 0) {
                endPointUrl = this.configurationMap.get("service.EndPoint");
            }
        }
        if (endPointUrl == null || endPointUrl.trim().length() <= 0) {
            throw new MalformedURLException("oauth.Endpoint, mode or service.EndPoint not set not configured to sandbox/live ");
        }
        if (Boolean.parseBoolean(this.configurationMap.get("http.UseProxy"))) {
            httpConfiguration.setProxySet(true);
            httpConfiguration.setProxyHost(this.configurationMap.get("http.ProxyHost"));
            httpConfiguration.setProxyPort(Integer.parseInt(this.configurationMap.get("http.ProxyPort")));
            String proxyUserName = this.configurationMap.get("http.ProxyUserName");
            String proxyPassword = this.configurationMap.get("http.ProxyPassword");
            if (proxyUserName != null && proxyPassword != null) {
                httpConfiguration.setProxyUserName(proxyUserName);
                httpConfiguration.setProxyPassword(proxyPassword);
            }
        }
        endPointUrl = endPointUrl.endsWith("/") ? endPointUrl.substring(0, endPointUrl.length() - 1) : endPointUrl;
        endPointUrl = endPointUrl + OAUTH_TOKEN_PATH;
        httpConfiguration.setEndPointUrl(endPointUrl);
        httpConfiguration.setGoogleAppEngine(Boolean.parseBoolean(this.configurationMap.get("http.GoogleAppEngine")));
        return httpConfiguration;
    }
}

