/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Currency;
import com.paypal.api.payments.DetailedRefund;
import com.paypal.api.payments.FmfDetails;
import com.paypal.api.payments.Links;
import com.paypal.api.payments.ProcessorResponse;
import com.paypal.api.payments.Refund;
import com.paypal.api.payments.RefundRequest;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.util.List;

public class Sale
extends PayPalResource {
    private String id;
    private String purchaseUnitReferenceId;
    private Amount amount;
    private String paymentMode;
    private String state;
    private String reasonCode;
    private String protectionEligibility;
    private String protectionEligibilityType;
    private String clearingTime;
    private String paymentHoldStatus;
    private List<String> paymentHoldReasons;
    private Currency transactionFee;
    private Currency receivableAmount;
    private String exchangeRate;
    private FmfDetails fmfDetails;
    private String receiptId;
    private String parentPayment;
    private ProcessorResponse processorResponse;
    private String billingAgreementId;
    private String createTime;
    private String updateTime;
    private List<Links> links;

    public Sale() {
    }

    public Sale(String id, Amount amount, String state, String parentPayment, String createTime) {
        this.id = id;
        this.amount = amount;
        this.state = state;
        this.parentPayment = parentPayment;
        this.createTime = createTime;
    }

    public static Sale get(String accessToken, String saleId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Sale.get(apiContext, saleId);
    }

    public static Sale get(APIContext apiContext, String saleId) throws PayPalRESTException {
        if (saleId == null) {
            throw new IllegalArgumentException("saleId cannot be null");
        }
        Object[] parameters = new Object[]{saleId};
        String pattern = "v1/payments/sale/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Sale.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Sale.class);
    }

    @Deprecated
    public Refund refund(String accessToken, Refund refund) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.refund(apiContext, refund);
    }

    @Deprecated
    public Refund refund(APIContext apiContext, Refund refund) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (refund == null) {
            throw new IllegalArgumentException("refund cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/sale/{0}/refund";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = refund.toJSON();
        Refund refundResponse = Sale.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Refund.class);
        apiContext.setRequestId(null);
        return refundResponse;
    }

    public DetailedRefund refund(APIContext apiContext, RefundRequest refundRequest) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (refundRequest == null) {
            throw new IllegalArgumentException("refundRequest cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/sale/{0}/refund";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = refundRequest.toJSON();
        return Sale.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, DetailedRefund.class);
    }

    public String getId() {
        return this.id;
    }

    public String getPurchaseUnitReferenceId() {
        return this.purchaseUnitReferenceId;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public String getState() {
        return this.state;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public String getProtectionEligibility() {
        return this.protectionEligibility;
    }

    public String getProtectionEligibilityType() {
        return this.protectionEligibilityType;
    }

    public String getClearingTime() {
        return this.clearingTime;
    }

    public String getPaymentHoldStatus() {
        return this.paymentHoldStatus;
    }

    public List<String> getPaymentHoldReasons() {
        return this.paymentHoldReasons;
    }

    public Currency getTransactionFee() {
        return this.transactionFee;
    }

    public Currency getReceivableAmount() {
        return this.receivableAmount;
    }

    public String getExchangeRate() {
        return this.exchangeRate;
    }

    public FmfDetails getFmfDetails() {
        return this.fmfDetails;
    }

    public String getReceiptId() {
        return this.receiptId;
    }

    public String getParentPayment() {
        return this.parentPayment;
    }

    public ProcessorResponse getProcessorResponse() {
        return this.processorResponse;
    }

    public String getBillingAgreementId() {
        return this.billingAgreementId;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Sale setId(String id) {
        this.id = id;
        return this;
    }

    public Sale setPurchaseUnitReferenceId(String purchaseUnitReferenceId) {
        this.purchaseUnitReferenceId = purchaseUnitReferenceId;
        return this;
    }

    public Sale setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Sale setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
        return this;
    }

    public Sale setState(String state) {
        this.state = state;
        return this;
    }

    public Sale setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    public Sale setProtectionEligibility(String protectionEligibility) {
        this.protectionEligibility = protectionEligibility;
        return this;
    }

    public Sale setProtectionEligibilityType(String protectionEligibilityType) {
        this.protectionEligibilityType = protectionEligibilityType;
        return this;
    }

    public Sale setClearingTime(String clearingTime) {
        this.clearingTime = clearingTime;
        return this;
    }

    public Sale setPaymentHoldStatus(String paymentHoldStatus) {
        this.paymentHoldStatus = paymentHoldStatus;
        return this;
    }

    public Sale setPaymentHoldReasons(List<String> paymentHoldReasons) {
        this.paymentHoldReasons = paymentHoldReasons;
        return this;
    }

    public Sale setTransactionFee(Currency transactionFee) {
        this.transactionFee = transactionFee;
        return this;
    }

    public Sale setReceivableAmount(Currency receivableAmount) {
        this.receivableAmount = receivableAmount;
        return this;
    }

    public Sale setExchangeRate(String exchangeRate) {
        this.exchangeRate = exchangeRate;
        return this;
    }

    public Sale setFmfDetails(FmfDetails fmfDetails) {
        this.fmfDetails = fmfDetails;
        return this;
    }

    public Sale setReceiptId(String receiptId) {
        this.receiptId = receiptId;
        return this;
    }

    public Sale setParentPayment(String parentPayment) {
        this.parentPayment = parentPayment;
        return this;
    }

    public Sale setProcessorResponse(ProcessorResponse processorResponse) {
        this.processorResponse = processorResponse;
        return this;
    }

    public Sale setBillingAgreementId(String billingAgreementId) {
        this.billingAgreementId = billingAgreementId;
        return this;
    }

    public Sale setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public Sale setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public Sale setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sale)) {
            return false;
        }
        Sale other = (Sale)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$purchaseUnitReferenceId = this.getPurchaseUnitReferenceId();
        String other$purchaseUnitReferenceId = other.getPurchaseUnitReferenceId();
        if (this$purchaseUnitReferenceId == null ? other$purchaseUnitReferenceId != null : !this$purchaseUnitReferenceId.equals(other$purchaseUnitReferenceId)) {
            return false;
        }
        Amount this$amount = this.getAmount();
        Amount other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$paymentMode = this.getPaymentMode();
        String other$paymentMode = other.getPaymentMode();
        if (this$paymentMode == null ? other$paymentMode != null : !this$paymentMode.equals(other$paymentMode)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$reasonCode = this.getReasonCode();
        String other$reasonCode = other.getReasonCode();
        if (this$reasonCode == null ? other$reasonCode != null : !this$reasonCode.equals(other$reasonCode)) {
            return false;
        }
        String this$protectionEligibility = this.getProtectionEligibility();
        String other$protectionEligibility = other.getProtectionEligibility();
        if (this$protectionEligibility == null ? other$protectionEligibility != null : !this$protectionEligibility.equals(other$protectionEligibility)) {
            return false;
        }
        String this$protectionEligibilityType = this.getProtectionEligibilityType();
        String other$protectionEligibilityType = other.getProtectionEligibilityType();
        if (this$protectionEligibilityType == null ? other$protectionEligibilityType != null : !this$protectionEligibilityType.equals(other$protectionEligibilityType)) {
            return false;
        }
        String this$clearingTime = this.getClearingTime();
        String other$clearingTime = other.getClearingTime();
        if (this$clearingTime == null ? other$clearingTime != null : !this$clearingTime.equals(other$clearingTime)) {
            return false;
        }
        String this$paymentHoldStatus = this.getPaymentHoldStatus();
        String other$paymentHoldStatus = other.getPaymentHoldStatus();
        if (this$paymentHoldStatus == null ? other$paymentHoldStatus != null : !this$paymentHoldStatus.equals(other$paymentHoldStatus)) {
            return false;
        }
        List<String> this$paymentHoldReasons = this.getPaymentHoldReasons();
        List<String> other$paymentHoldReasons = other.getPaymentHoldReasons();
        if (this$paymentHoldReasons == null ? other$paymentHoldReasons != null : !((Object)this$paymentHoldReasons).equals(other$paymentHoldReasons)) {
            return false;
        }
        Currency this$transactionFee = this.getTransactionFee();
        Currency other$transactionFee = other.getTransactionFee();
        if (this$transactionFee == null ? other$transactionFee != null : !((Object)this$transactionFee).equals(other$transactionFee)) {
            return false;
        }
        Currency this$receivableAmount = this.getReceivableAmount();
        Currency other$receivableAmount = other.getReceivableAmount();
        if (this$receivableAmount == null ? other$receivableAmount != null : !((Object)this$receivableAmount).equals(other$receivableAmount)) {
            return false;
        }
        String this$exchangeRate = this.getExchangeRate();
        String other$exchangeRate = other.getExchangeRate();
        if (this$exchangeRate == null ? other$exchangeRate != null : !this$exchangeRate.equals(other$exchangeRate)) {
            return false;
        }
        FmfDetails this$fmfDetails = this.getFmfDetails();
        FmfDetails other$fmfDetails = other.getFmfDetails();
        if (this$fmfDetails == null ? other$fmfDetails != null : !((Object)this$fmfDetails).equals(other$fmfDetails)) {
            return false;
        }
        String this$receiptId = this.getReceiptId();
        String other$receiptId = other.getReceiptId();
        if (this$receiptId == null ? other$receiptId != null : !this$receiptId.equals(other$receiptId)) {
            return false;
        }
        String this$parentPayment = this.getParentPayment();
        String other$parentPayment = other.getParentPayment();
        if (this$parentPayment == null ? other$parentPayment != null : !this$parentPayment.equals(other$parentPayment)) {
            return false;
        }
        ProcessorResponse this$processorResponse = this.getProcessorResponse();
        ProcessorResponse other$processorResponse = other.getProcessorResponse();
        if (this$processorResponse == null ? other$processorResponse != null : !((Object)this$processorResponse).equals(other$processorResponse)) {
            return false;
        }
        String this$billingAgreementId = this.getBillingAgreementId();
        String other$billingAgreementId = other.getBillingAgreementId();
        if (this$billingAgreementId == null ? other$billingAgreementId != null : !this$billingAgreementId.equals(other$billingAgreementId)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        List<Links> this$links = this.getLinks();
        List<Links> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Sale;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $purchaseUnitReferenceId = this.getPurchaseUnitReferenceId();
        result = result * 59 + ($purchaseUnitReferenceId == null ? 43 : $purchaseUnitReferenceId.hashCode());
        Amount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $paymentMode = this.getPaymentMode();
        result = result * 59 + ($paymentMode == null ? 43 : $paymentMode.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $reasonCode = this.getReasonCode();
        result = result * 59 + ($reasonCode == null ? 43 : $reasonCode.hashCode());
        String $protectionEligibility = this.getProtectionEligibility();
        result = result * 59 + ($protectionEligibility == null ? 43 : $protectionEligibility.hashCode());
        String $protectionEligibilityType = this.getProtectionEligibilityType();
        result = result * 59 + ($protectionEligibilityType == null ? 43 : $protectionEligibilityType.hashCode());
        String $clearingTime = this.getClearingTime();
        result = result * 59 + ($clearingTime == null ? 43 : $clearingTime.hashCode());
        String $paymentHoldStatus = this.getPaymentHoldStatus();
        result = result * 59 + ($paymentHoldStatus == null ? 43 : $paymentHoldStatus.hashCode());
        List<String> $paymentHoldReasons = this.getPaymentHoldReasons();
        result = result * 59 + ($paymentHoldReasons == null ? 43 : ((Object)$paymentHoldReasons).hashCode());
        Currency $transactionFee = this.getTransactionFee();
        result = result * 59 + ($transactionFee == null ? 43 : ((Object)$transactionFee).hashCode());
        Currency $receivableAmount = this.getReceivableAmount();
        result = result * 59 + ($receivableAmount == null ? 43 : ((Object)$receivableAmount).hashCode());
        String $exchangeRate = this.getExchangeRate();
        result = result * 59 + ($exchangeRate == null ? 43 : $exchangeRate.hashCode());
        FmfDetails $fmfDetails = this.getFmfDetails();
        result = result * 59 + ($fmfDetails == null ? 43 : ((Object)$fmfDetails).hashCode());
        String $receiptId = this.getReceiptId();
        result = result * 59 + ($receiptId == null ? 43 : $receiptId.hashCode());
        String $parentPayment = this.getParentPayment();
        result = result * 59 + ($parentPayment == null ? 43 : $parentPayment.hashCode());
        ProcessorResponse $processorResponse = this.getProcessorResponse();
        result = result * 59 + ($processorResponse == null ? 43 : ((Object)$processorResponse).hashCode());
        String $billingAgreementId = this.getBillingAgreementId();
        result = result * 59 + ($billingAgreementId == null ? 43 : $billingAgreementId.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        List<Links> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }
}

