// Generated by delombok at Tue Jan 31 13:36:37 CST 2017
package com.paypal.api.payments;

import com.paypal.base.rest.*;
import java.util.List;

public class Sale extends PayPalResource {
	/**
	 * Identifier of the sale transaction.
	 */
	private String id;
	/**
	 * Identifier to the purchase or transaction unit corresponding to this sale transaction.
	 */
	private String purchaseUnitReferenceId;
	/**
	 * Amount being collected.
	 */
	private Amount amount;
	/**
	 * Specifies payment mode of the transaction. Only supported when the `payment_method` is set to `paypal`.
	 */
	private String paymentMode;
	/**
	 * State of the sale transaction.
	 */
	private String state;
	/**
	 * Reason code for the transaction state being Pending or Reversed. Only supported when the `payment_method` is set to `paypal`.
	 */
	private String reasonCode;
	/**
	 * The level of seller protection in force for the transaction. Only supported when the `payment_method` is set to `paypal`.
	 */
	private String protectionEligibility;
	/**
	 * The kind of seller protection in force for the transaction. It is returned only when protection_eligibility is ELIGIBLE or PARTIALLY_ELIGIBLE. Only supported when the `payment_method` is set to `paypal`.
	 */
	private String protectionEligibilityType;
	/**
	 * Expected clearing time for eCheck Transactions. Returned when payment is made with eCheck. Only supported when the `payment_method` is set to `paypal`.
	 */
	private String clearingTime;
	/**
	 * Status of the Recipient Fund. For now, it will be returned only when fund status is held
	 */
	private String paymentHoldStatus;
	/**
	 * Reasons for PayPal holding recipient fund. It is set only if payment hold status is held
	 */
	private List<String> paymentHoldReasons;
	/**
	 * Transaction fee applicable for this payment.
	 */
	private Currency transactionFee;
	/**
	 * Net amount the merchant receives for this transaction in their receivable currency. Returned only in cross-currency use cases where a merchant bills a buyer in a non-primary currency for that buyer.
	 */
	private Currency receivableAmount;
	/**
	 * Exchange rate applied for this transaction. Returned only in cross-currency use cases where a merchant bills a buyer in a non-primary currency for that buyer.
	 */
	private String exchangeRate;
	/**
	 * Fraud Management Filter (FMF) details applied for the payment that could result in accept, deny, or pending action. Returned in a payment response only if the merchant has enabled FMF in the profile settings and one of the fraud filters was triggered based on those settings. See [Fraud Management Filters Summary](/docs/classic/fmf/integration-guide/FMFSummary/) for more information.
	 */
	private FmfDetails fmfDetails;
	/**
	 * Receipt id is a payment identification number returned for guest users to identify the payment.
	 */
	private String receiptId;
	/**
	 * ID of the payment resource on which this transaction is based.
	 */
	private String parentPayment;
	/**
	 * Response codes returned by the processor concerning the submitted payment. Only supported when the `payment_method` is set to `credit_card`.
	 */
	private ProcessorResponse processorResponse;
	/**
	 * ID of the billing agreement used as reference to execute this transaction.
	 */
	private String billingAgreementId;
	/**
	 * Time of sale as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6)
	 */
	private String createTime;
	/**
	 * Time the resource was last updated in UTC ISO8601 format.
	 */
	private String updateTime;
	/**
	 */
	private List<Links> links;

	/**
	 * Default Constructor
	 */
	public Sale() {
	}

	/**
	 * Parameterized Constructor
	 */
	public Sale(String id, Amount amount, String state, String parentPayment, String createTime) {
		this.id = id;
		this.amount = amount;
		this.state = state;
		this.parentPayment = parentPayment;
		this.createTime = createTime;
	}

	/**
	 * Shows details for a sale, by ID. Returns only sales that were created through the REST API.
	 * @deprecated Please use {@link #get(APIContext, String)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param saleId
	 * String
	 * @return Sale
	 * @throws PayPalRESTException
	 */
	public static Sale get(String accessToken, String saleId) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return get(apiContext, saleId);
	}

	/**
	 * Shows details for a sale, by ID. Returns only sales that were created through the REST API.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param saleId
	 * String
	 * @return Sale
	 * @throws PayPalRESTException
	 */
	public static Sale get(APIContext apiContext, String saleId) throws PayPalRESTException {
		if (saleId == null) {
			throw new IllegalArgumentException("saleId cannot be null");
		}
		Object[] parameters = new Object[] {saleId};
		String pattern = "v1/payments/sale/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		return configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Sale.class);
	}

	/**
	 * Creates (and processes) a new Refund Transaction added as a related resource.
	 * @deprecated Please use {@link #refund(APIContext, Refund)} instead.
	 *
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param refund
	 * Refund
	 * @return Refund
	 * @throws PayPalRESTException
	 */
	@Deprecated
	public Refund refund(String accessToken, Refund refund) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return refund(apiContext, refund);
	}

	/**
	 * @deprecated Please use {@link #refund(APIContext, RefundRequest)} instead
	 *
	 * Refunds a sale, by ID. For a full refund, include an empty payload in the JSON request body. For a partial refund, include an `amount` object in the JSON request body.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param refund
	 * Refund
	 * @return Refund
	 * @throws PayPalRESTException
	 */
	@Deprecated
	public Refund refund(APIContext apiContext, Refund refund) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		if (refund == null) {
			throw new IllegalArgumentException("refund cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/payments/sale/{0}/refund";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = refund.toJSON();
		Refund refundResponse = configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Refund.class);
		apiContext.setRequestId(null);
		return refundResponse;
	}

	/**
	 * Refunds a sale, by ID. For a full refund, include an empty payload in the JSON request body. For a partial refund, include an `amount` object in the JSON request body.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param refundRequest
	 * RefundRequest
	 * @return DetailedRefund
	 * @throws PayPalRESTException
	 */
	public DetailedRefund refund(APIContext apiContext, RefundRequest refundRequest) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		if (refundRequest == null) {
			throw new IllegalArgumentException("refundRequest cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/payments/sale/{0}/refund";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = refundRequest.toJSON();
		return configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, DetailedRefund.class);
	}

	/**
	 * Identifier of the sale transaction.
	 */
	@java.lang.SuppressWarnings("all")
	public String getId() {
		return this.id;
	}

	/**
	 * Identifier to the purchase or transaction unit corresponding to this sale transaction.
	 */
	@java.lang.SuppressWarnings("all")
	public String getPurchaseUnitReferenceId() {
		return this.purchaseUnitReferenceId;
	}

	/**
	 * Amount being collected.
	 */
	@java.lang.SuppressWarnings("all")
	public Amount getAmount() {
		return this.amount;
	}

	/**
	 * Specifies payment mode of the transaction. Only supported when the `payment_method` is set to `paypal`.
	 */
	@java.lang.SuppressWarnings("all")
	public String getPaymentMode() {
		return this.paymentMode;
	}

	/**
	 * State of the sale transaction.
	 */
	@java.lang.SuppressWarnings("all")
	public String getState() {
		return this.state;
	}

	/**
	 * Reason code for the transaction state being Pending or Reversed. Only supported when the `payment_method` is set to `paypal`.
	 */
	@java.lang.SuppressWarnings("all")
	public String getReasonCode() {
		return this.reasonCode;
	}

	/**
	 * The level of seller protection in force for the transaction. Only supported when the `payment_method` is set to `paypal`.
	 */
	@java.lang.SuppressWarnings("all")
	public String getProtectionEligibility() {
		return this.protectionEligibility;
	}

	/**
	 * The kind of seller protection in force for the transaction. It is returned only when protection_eligibility is ELIGIBLE or PARTIALLY_ELIGIBLE. Only supported when the `payment_method` is set to `paypal`.
	 */
	@java.lang.SuppressWarnings("all")
	public String getProtectionEligibilityType() {
		return this.protectionEligibilityType;
	}

	/**
	 * Expected clearing time for eCheck Transactions. Returned when payment is made with eCheck. Only supported when the `payment_method` is set to `paypal`.
	 */
	@java.lang.SuppressWarnings("all")
	public String getClearingTime() {
		return this.clearingTime;
	}

	/**
	 * Status of the Recipient Fund. For now, it will be returned only when fund status is held
	 */
	@java.lang.SuppressWarnings("all")
	public String getPaymentHoldStatus() {
		return this.paymentHoldStatus;
	}

	/**
	 * Reasons for PayPal holding recipient fund. It is set only if payment hold status is held
	 */
	@java.lang.SuppressWarnings("all")
	public List<String> getPaymentHoldReasons() {
		return this.paymentHoldReasons;
	}

	/**
	 * Transaction fee applicable for this payment.
	 */
	@java.lang.SuppressWarnings("all")
	public Currency getTransactionFee() {
		return this.transactionFee;
	}

	/**
	 * Net amount the merchant receives for this transaction in their receivable currency. Returned only in cross-currency use cases where a merchant bills a buyer in a non-primary currency for that buyer.
	 */
	@java.lang.SuppressWarnings("all")
	public Currency getReceivableAmount() {
		return this.receivableAmount;
	}

	/**
	 * Exchange rate applied for this transaction. Returned only in cross-currency use cases where a merchant bills a buyer in a non-primary currency for that buyer.
	 */
	@java.lang.SuppressWarnings("all")
	public String getExchangeRate() {
		return this.exchangeRate;
	}

	/**
	 * Fraud Management Filter (FMF) details applied for the payment that could result in accept, deny, or pending action. Returned in a payment response only if the merchant has enabled FMF in the profile settings and one of the fraud filters was triggered based on those settings. See [Fraud Management Filters Summary](/docs/classic/fmf/integration-guide/FMFSummary/) for more information.
	 */
	@java.lang.SuppressWarnings("all")
	public FmfDetails getFmfDetails() {
		return this.fmfDetails;
	}

	/**
	 * Receipt id is a payment identification number returned for guest users to identify the payment.
	 */
	@java.lang.SuppressWarnings("all")
	public String getReceiptId() {
		return this.receiptId;
	}

	/**
	 * ID of the payment resource on which this transaction is based.
	 */
	@java.lang.SuppressWarnings("all")
	public String getParentPayment() {
		return this.parentPayment;
	}

	/**
	 * Response codes returned by the processor concerning the submitted payment. Only supported when the `payment_method` is set to `credit_card`.
	 */
	@java.lang.SuppressWarnings("all")
	public ProcessorResponse getProcessorResponse() {
		return this.processorResponse;
	}

	/**
	 * ID of the billing agreement used as reference to execute this transaction.
	 */
	@java.lang.SuppressWarnings("all")
	public String getBillingAgreementId() {
		return this.billingAgreementId;
	}

	/**
	 * Time of sale as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6)
	 */
	@java.lang.SuppressWarnings("all")
	public String getCreateTime() {
		return this.createTime;
	}

	/**
	 * Time the resource was last updated in UTC ISO8601 format.
	 */
	@java.lang.SuppressWarnings("all")
	public String getUpdateTime() {
		return this.updateTime;
	}

	/**
	 */
	@java.lang.SuppressWarnings("all")
	public List<Links> getLinks() {
		return this.links;
	}

	/**
	 * Identifier of the sale transaction.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setId(final String id) {
		this.id = id;
		return this;
	}

	/**
	 * Identifier to the purchase or transaction unit corresponding to this sale transaction.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setPurchaseUnitReferenceId(final String purchaseUnitReferenceId) {
		this.purchaseUnitReferenceId = purchaseUnitReferenceId;
		return this;
	}

	/**
	 * Amount being collected.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setAmount(final Amount amount) {
		this.amount = amount;
		return this;
	}

	/**
	 * Specifies payment mode of the transaction. Only supported when the `payment_method` is set to `paypal`.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setPaymentMode(final String paymentMode) {
		this.paymentMode = paymentMode;
		return this;
	}

	/**
	 * State of the sale transaction.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setState(final String state) {
		this.state = state;
		return this;
	}

	/**
	 * Reason code for the transaction state being Pending or Reversed. Only supported when the `payment_method` is set to `paypal`.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setReasonCode(final String reasonCode) {
		this.reasonCode = reasonCode;
		return this;
	}

	/**
	 * The level of seller protection in force for the transaction. Only supported when the `payment_method` is set to `paypal`.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setProtectionEligibility(final String protectionEligibility) {
		this.protectionEligibility = protectionEligibility;
		return this;
	}

	/**
	 * The kind of seller protection in force for the transaction. It is returned only when protection_eligibility is ELIGIBLE or PARTIALLY_ELIGIBLE. Only supported when the `payment_method` is set to `paypal`.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setProtectionEligibilityType(final String protectionEligibilityType) {
		this.protectionEligibilityType = protectionEligibilityType;
		return this;
	}

	/**
	 * Expected clearing time for eCheck Transactions. Returned when payment is made with eCheck. Only supported when the `payment_method` is set to `paypal`.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setClearingTime(final String clearingTime) {
		this.clearingTime = clearingTime;
		return this;
	}

	/**
	 * Status of the Recipient Fund. For now, it will be returned only when fund status is held
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setPaymentHoldStatus(final String paymentHoldStatus) {
		this.paymentHoldStatus = paymentHoldStatus;
		return this;
	}

	/**
	 * Reasons for PayPal holding recipient fund. It is set only if payment hold status is held
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setPaymentHoldReasons(final List<String> paymentHoldReasons) {
		this.paymentHoldReasons = paymentHoldReasons;
		return this;
	}

	/**
	 * Transaction fee applicable for this payment.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setTransactionFee(final Currency transactionFee) {
		this.transactionFee = transactionFee;
		return this;
	}

	/**
	 * Net amount the merchant receives for this transaction in their receivable currency. Returned only in cross-currency use cases where a merchant bills a buyer in a non-primary currency for that buyer.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setReceivableAmount(final Currency receivableAmount) {
		this.receivableAmount = receivableAmount;
		return this;
	}

	/**
	 * Exchange rate applied for this transaction. Returned only in cross-currency use cases where a merchant bills a buyer in a non-primary currency for that buyer.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setExchangeRate(final String exchangeRate) {
		this.exchangeRate = exchangeRate;
		return this;
	}

	/**
	 * Fraud Management Filter (FMF) details applied for the payment that could result in accept, deny, or pending action. Returned in a payment response only if the merchant has enabled FMF in the profile settings and one of the fraud filters was triggered based on those settings. See [Fraud Management Filters Summary](/docs/classic/fmf/integration-guide/FMFSummary/) for more information.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setFmfDetails(final FmfDetails fmfDetails) {
		this.fmfDetails = fmfDetails;
		return this;
	}

	/**
	 * Receipt id is a payment identification number returned for guest users to identify the payment.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setReceiptId(final String receiptId) {
		this.receiptId = receiptId;
		return this;
	}

	/**
	 * ID of the payment resource on which this transaction is based.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setParentPayment(final String parentPayment) {
		this.parentPayment = parentPayment;
		return this;
	}

	/**
	 * Response codes returned by the processor concerning the submitted payment. Only supported when the `payment_method` is set to `credit_card`.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setProcessorResponse(final ProcessorResponse processorResponse) {
		this.processorResponse = processorResponse;
		return this;
	}

	/**
	 * ID of the billing agreement used as reference to execute this transaction.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setBillingAgreementId(final String billingAgreementId) {
		this.billingAgreementId = billingAgreementId;
		return this;
	}

	/**
	 * Time of sale as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6)
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setCreateTime(final String createTime) {
		this.createTime = createTime;
		return this;
	}

	/**
	 * Time the resource was last updated in UTC ISO8601 format.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setUpdateTime(final String updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	/**
	 *
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Sale setLinks(final List<Links> links) {
		this.links = links;
		return this;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof Sale)) return false;
		final Sale other = (Sale) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		if (!super.equals(o)) return false;
		final java.lang.Object this$id = this.getId();
		final java.lang.Object other$id = other.getId();
		if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
		final java.lang.Object this$purchaseUnitReferenceId = this.getPurchaseUnitReferenceId();
		final java.lang.Object other$purchaseUnitReferenceId = other.getPurchaseUnitReferenceId();
		if (this$purchaseUnitReferenceId == null ? other$purchaseUnitReferenceId != null : !this$purchaseUnitReferenceId.equals(other$purchaseUnitReferenceId)) return false;
		final java.lang.Object this$amount = this.getAmount();
		final java.lang.Object other$amount = other.getAmount();
		if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
		final java.lang.Object this$paymentMode = this.getPaymentMode();
		final java.lang.Object other$paymentMode = other.getPaymentMode();
		if (this$paymentMode == null ? other$paymentMode != null : !this$paymentMode.equals(other$paymentMode)) return false;
		final java.lang.Object this$state = this.getState();
		final java.lang.Object other$state = other.getState();
		if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
		final java.lang.Object this$reasonCode = this.getReasonCode();
		final java.lang.Object other$reasonCode = other.getReasonCode();
		if (this$reasonCode == null ? other$reasonCode != null : !this$reasonCode.equals(other$reasonCode)) return false;
		final java.lang.Object this$protectionEligibility = this.getProtectionEligibility();
		final java.lang.Object other$protectionEligibility = other.getProtectionEligibility();
		if (this$protectionEligibility == null ? other$protectionEligibility != null : !this$protectionEligibility.equals(other$protectionEligibility)) return false;
		final java.lang.Object this$protectionEligibilityType = this.getProtectionEligibilityType();
		final java.lang.Object other$protectionEligibilityType = other.getProtectionEligibilityType();
		if (this$protectionEligibilityType == null ? other$protectionEligibilityType != null : !this$protectionEligibilityType.equals(other$protectionEligibilityType)) return false;
		final java.lang.Object this$clearingTime = this.getClearingTime();
		final java.lang.Object other$clearingTime = other.getClearingTime();
		if (this$clearingTime == null ? other$clearingTime != null : !this$clearingTime.equals(other$clearingTime)) return false;
		final java.lang.Object this$paymentHoldStatus = this.getPaymentHoldStatus();
		final java.lang.Object other$paymentHoldStatus = other.getPaymentHoldStatus();
		if (this$paymentHoldStatus == null ? other$paymentHoldStatus != null : !this$paymentHoldStatus.equals(other$paymentHoldStatus)) return false;
		final java.lang.Object this$paymentHoldReasons = this.getPaymentHoldReasons();
		final java.lang.Object other$paymentHoldReasons = other.getPaymentHoldReasons();
		if (this$paymentHoldReasons == null ? other$paymentHoldReasons != null : !this$paymentHoldReasons.equals(other$paymentHoldReasons)) return false;
		final java.lang.Object this$transactionFee = this.getTransactionFee();
		final java.lang.Object other$transactionFee = other.getTransactionFee();
		if (this$transactionFee == null ? other$transactionFee != null : !this$transactionFee.equals(other$transactionFee)) return false;
		final java.lang.Object this$receivableAmount = this.getReceivableAmount();
		final java.lang.Object other$receivableAmount = other.getReceivableAmount();
		if (this$receivableAmount == null ? other$receivableAmount != null : !this$receivableAmount.equals(other$receivableAmount)) return false;
		final java.lang.Object this$exchangeRate = this.getExchangeRate();
		final java.lang.Object other$exchangeRate = other.getExchangeRate();
		if (this$exchangeRate == null ? other$exchangeRate != null : !this$exchangeRate.equals(other$exchangeRate)) return false;
		final java.lang.Object this$fmfDetails = this.getFmfDetails();
		final java.lang.Object other$fmfDetails = other.getFmfDetails();
		if (this$fmfDetails == null ? other$fmfDetails != null : !this$fmfDetails.equals(other$fmfDetails)) return false;
		final java.lang.Object this$receiptId = this.getReceiptId();
		final java.lang.Object other$receiptId = other.getReceiptId();
		if (this$receiptId == null ? other$receiptId != null : !this$receiptId.equals(other$receiptId)) return false;
		final java.lang.Object this$parentPayment = this.getParentPayment();
		final java.lang.Object other$parentPayment = other.getParentPayment();
		if (this$parentPayment == null ? other$parentPayment != null : !this$parentPayment.equals(other$parentPayment)) return false;
		final java.lang.Object this$processorResponse = this.getProcessorResponse();
		final java.lang.Object other$processorResponse = other.getProcessorResponse();
		if (this$processorResponse == null ? other$processorResponse != null : !this$processorResponse.equals(other$processorResponse)) return false;
		final java.lang.Object this$billingAgreementId = this.getBillingAgreementId();
		final java.lang.Object other$billingAgreementId = other.getBillingAgreementId();
		if (this$billingAgreementId == null ? other$billingAgreementId != null : !this$billingAgreementId.equals(other$billingAgreementId)) return false;
		final java.lang.Object this$createTime = this.getCreateTime();
		final java.lang.Object other$createTime = other.getCreateTime();
		if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) return false;
		final java.lang.Object this$updateTime = this.getUpdateTime();
		final java.lang.Object other$updateTime = other.getUpdateTime();
		if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) return false;
		final java.lang.Object this$links = this.getLinks();
		final java.lang.Object other$links = other.getLinks();
		if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof Sale;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		result = result * PRIME + super.hashCode();
		final java.lang.Object $id = this.getId();
		result = result * PRIME + ($id == null ? 43 : $id.hashCode());
		final java.lang.Object $purchaseUnitReferenceId = this.getPurchaseUnitReferenceId();
		result = result * PRIME + ($purchaseUnitReferenceId == null ? 43 : $purchaseUnitReferenceId.hashCode());
		final java.lang.Object $amount = this.getAmount();
		result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
		final java.lang.Object $paymentMode = this.getPaymentMode();
		result = result * PRIME + ($paymentMode == null ? 43 : $paymentMode.hashCode());
		final java.lang.Object $state = this.getState();
		result = result * PRIME + ($state == null ? 43 : $state.hashCode());
		final java.lang.Object $reasonCode = this.getReasonCode();
		result = result * PRIME + ($reasonCode == null ? 43 : $reasonCode.hashCode());
		final java.lang.Object $protectionEligibility = this.getProtectionEligibility();
		result = result * PRIME + ($protectionEligibility == null ? 43 : $protectionEligibility.hashCode());
		final java.lang.Object $protectionEligibilityType = this.getProtectionEligibilityType();
		result = result * PRIME + ($protectionEligibilityType == null ? 43 : $protectionEligibilityType.hashCode());
		final java.lang.Object $clearingTime = this.getClearingTime();
		result = result * PRIME + ($clearingTime == null ? 43 : $clearingTime.hashCode());
		final java.lang.Object $paymentHoldStatus = this.getPaymentHoldStatus();
		result = result * PRIME + ($paymentHoldStatus == null ? 43 : $paymentHoldStatus.hashCode());
		final java.lang.Object $paymentHoldReasons = this.getPaymentHoldReasons();
		result = result * PRIME + ($paymentHoldReasons == null ? 43 : $paymentHoldReasons.hashCode());
		final java.lang.Object $transactionFee = this.getTransactionFee();
		result = result * PRIME + ($transactionFee == null ? 43 : $transactionFee.hashCode());
		final java.lang.Object $receivableAmount = this.getReceivableAmount();
		result = result * PRIME + ($receivableAmount == null ? 43 : $receivableAmount.hashCode());
		final java.lang.Object $exchangeRate = this.getExchangeRate();
		result = result * PRIME + ($exchangeRate == null ? 43 : $exchangeRate.hashCode());
		final java.lang.Object $fmfDetails = this.getFmfDetails();
		result = result * PRIME + ($fmfDetails == null ? 43 : $fmfDetails.hashCode());
		final java.lang.Object $receiptId = this.getReceiptId();
		result = result * PRIME + ($receiptId == null ? 43 : $receiptId.hashCode());
		final java.lang.Object $parentPayment = this.getParentPayment();
		result = result * PRIME + ($parentPayment == null ? 43 : $parentPayment.hashCode());
		final java.lang.Object $processorResponse = this.getProcessorResponse();
		result = result * PRIME + ($processorResponse == null ? 43 : $processorResponse.hashCode());
		final java.lang.Object $billingAgreementId = this.getBillingAgreementId();
		result = result * PRIME + ($billingAgreementId == null ? 43 : $billingAgreementId.hashCode());
		final java.lang.Object $createTime = this.getCreateTime();
		result = result * PRIME + ($createTime == null ? 43 : $createTime.hashCode());
		final java.lang.Object $updateTime = this.getUpdateTime();
		result = result * PRIME + ($updateTime == null ? 43 : $updateTime.hashCode());
		final java.lang.Object $links = this.getLinks();
		result = result * PRIME + ($links == null ? 43 : $links.hashCode());
		return result;
	}
}
