/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.EventType;
import com.paypal.api.payments.Links;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.JSONFormatter;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import com.paypal.base.sdk.info.SDKVersionImpl;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Webhook {
    private String id;
    private String url;
    private List<EventType> eventTypes;
    private List<Links> links;

    public Webhook() {
    }

    public Webhook(String url, List<EventType> eventTypes) {
        this.url = url;
        this.eventTypes = eventTypes;
    }

    public Webhook setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Webhook setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public Webhook setEventTypes(List<EventType> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
    }

    public List<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public Webhook setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Webhook create(String accessToken, Webhook webhook) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext, webhook);
    }

    public Webhook create(APIContext apiContext, Webhook webhook) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        if (webhook == null) {
            throw new IllegalArgumentException("webhook cannot be null");
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        Object[] parameters = new Object[]{};
        String pattern = "v1/notifications/webhooks";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = webhook.toJSON();
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Webhook.class);
    }

    public Webhook get(String accessToken, String webhookId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.get(apiContext, webhookId);
    }

    public Webhook get(APIContext apiContext, String webhookId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        if (webhookId == null) {
            throw new IllegalArgumentException("webhookId cannot be null");
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        Object[] parameters = new Object[]{webhookId};
        String pattern = "v1/notifications/webhooks/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Webhook.class);
    }

    public Webhook update(String accessToken, String webhookId, String patchRequest) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.update(apiContext, webhookId, patchRequest);
    }

    public Webhook update(APIContext apiContext, String webhookId, String patchRequest) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        if (webhookId == null) {
            throw new IllegalArgumentException("webhookId cannot be null");
        }
        if (patchRequest == null) {
            throw new IllegalArgumentException("patchRequest cannot be null");
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        Object[] parameters = new Object[]{webhookId};
        String pattern = "v1/notifications/webhooks/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = patchRequest;
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.PATCH, resourcePath, payLoad, Webhook.class);
    }

    public void delete(String accessToken, String webhookId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.delete(apiContext, webhookId);
    }

    public void delete(APIContext apiContext, String webhookId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        if (webhookId == null) {
            throw new IllegalArgumentException("webhookId cannot be null");
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        Object[] parameters = new Object[]{webhookId};
        String pattern = "v1/notifications/webhooks/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        PayPalResource.configureAndExecute(apiContext, HttpMethod.DELETE, resourcePath, payLoad, null);
    }

    public String toJSON() {
        return JSONFormatter.toJSON(this);
    }

    public String toString() {
        return this.toJSON();
    }
}

