/*
 * Decompiled with CFR 0.152.
 */
package com.paymennt.crypto;

import com.paymennt.crypto.bip32.Network;
import com.paymennt.crypto.bip32.wallet.key.Curve;

public enum CoinType {
    BITCOIN(Curve.BITCOIN, 0L, 1L, false),
    SOLANA(Curve.ED25519, 501L, 501L, true),
    SEMUX(Curve.ED25519, 7562605L, 7562605L, true);

    private final Curve curve;
    private final long coinType;
    private final long testCoinType;
    private boolean alwaysHardened;

    private CoinType(Curve curve, long coinType, long testCoinType, boolean alwaysHardened) {
        this.curve = curve;
        this.coinType = coinType;
        this.testCoinType = testCoinType;
        this.alwaysHardened = alwaysHardened;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public long getCoinType(Network network) {
        return network == Network.MAINNET ? this.coinType : this.testCoinType;
    }

    public boolean getAlwaysHardened() {
        return this.alwaysHardened;
    }
}

