/*
 * Decompiled with CFR 0.152.
 */
package com.payline.kit.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DisplayUtils {
    private static final Logger logger = Logger.getLogger(DisplayUtils.class.getName());

    private DisplayUtils() {
    }

    public static String objectDetails(Object obj) {
        StringBuffer out = new StringBuffer();
        try {
            if (obj != null) {
                Class<?> cl = obj.getClass();
                if (obj instanceof List) {
                    out.append(DisplayUtils.arrayDetails((List)obj));
                } else if (cl.isPrimitive() || cl.getName().contains("String")) {
                    out.append(out.append("<li>" + cl.getName() + " => " + obj + "</li>"));
                } else {
                    Method[] methods;
                    out.append("<ul><li class=\"object\">");
                    out.append(cl.getName());
                    out.append("</li>");
                    for (Method m : methods = cl.getDeclaredMethods()) {
                        String methodName = m.getName();
                        Class<?> retType = m.getReturnType();
                        Class<?>[] paramTypes = m.getParameterTypes();
                        if (!methodName.startsWith("get") || !Modifier.toString(m.getModifiers()).equalsIgnoreCase("public") || paramTypes.length != 0) continue;
                        try {
                            if (retType.isPrimitive() || retType.getName().contains("String")) {
                                Object r = m.invoke(obj, new Object[0]);
                                String result = null;
                                if (r != null) {
                                    result = r.toString();
                                }
                                if (result != null && result.startsWith("http")) {
                                    result = "<a href=\"" + result + "\">" + result + "</a>";
                                }
                                out.append("<li>" + methodName + " => " + result + "</li>");
                                continue;
                            }
                            out.append(DisplayUtils.objectDetails(m.invoke(obj, new Object[0])));
                        }
                        catch (IllegalAccessException ex) {
                            logger.log(Level.SEVERE, "error during introspection :", ex);
                        }
                        catch (InvocationTargetException ex) {
                            logger.log(Level.SEVERE, "error during introspection :", ex);
                        }
                    }
                }
                out.append(" </ul>");
            }
        }
        catch (NoSuchElementException ex) {
            logger.log(Level.SEVERE, "error during introspection :", ex);
        }
        return out.toString();
    }

    public static String arrayDetails(List<?> obj) {
        StringBuffer out = new StringBuffer();
        try {
            if (obj != null) {
                if (obj.size() > 0) {
                    out.append("<ul><li class=\"object\">").append(obj.getClass().getName()).append("</li>");
                }
                for (Object o : obj) {
                    out.append(DisplayUtils.objectDetails(o));
                }
                out.append(" </ul>");
            }
        }
        catch (NoSuchElementException ex) {
            System.out.println(ex.getMessage());
        }
        return out.toString();
    }
}

