/*
 * Decompiled with CFR 0.152.
 */
package com.payline.ws.wrapper;

import com.payline.kit.utils.ConnectParams;
import com.payline.kit.utils.Utils;
import com.payline.ws.model.Authentication3DSecure;
import com.payline.ws.model.Authorization;
import com.payline.ws.model.BankAccountData;
import com.payline.ws.model.Buyer;
import com.payline.ws.model.Card;
import com.payline.ws.model.Cheque;
import com.payline.ws.model.Creditor;
import com.payline.ws.model.DirectPaymentAPI;
import com.payline.ws.model.DoAuthorizationRequest;
import com.payline.ws.model.DoAuthorizationResponse;
import com.payline.ws.model.DoBankTransferRequest;
import com.payline.ws.model.DoBankTransferResponse;
import com.payline.ws.model.DoCaptureRequest;
import com.payline.ws.model.DoCaptureResponse;
import com.payline.ws.model.DoCreditRequest;
import com.payline.ws.model.DoCreditResponse;
import com.payline.ws.model.DoDebitRequest;
import com.payline.ws.model.DoDebitResponse;
import com.payline.ws.model.DoReAuthorizationRequest;
import com.payline.ws.model.DoReAuthorizationResponse;
import com.payline.ws.model.DoRefundRequest;
import com.payline.ws.model.DoRefundResponse;
import com.payline.ws.model.DoResetRequest;
import com.payline.ws.model.DoResetResponse;
import com.payline.ws.model.DoScoringChequeRequest;
import com.payline.ws.model.DoScoringChequeResponse;
import com.payline.ws.model.GetBalanceRequest;
import com.payline.ws.model.GetBalanceResponse;
import com.payline.ws.model.GetEncryptionKeyRequest;
import com.payline.ws.model.GetEncryptionKeyResponse;
import com.payline.ws.model.GetMerchantSettingsRequest;
import com.payline.ws.model.GetMerchantSettingsResponse;
import com.payline.ws.model.GetTokenRequest;
import com.payline.ws.model.GetTokenResponse;
import com.payline.ws.model.IsRegisteredRequest;
import com.payline.ws.model.IsRegisteredResponse;
import com.payline.ws.model.Order;
import com.payline.ws.model.Payment;
import com.payline.ws.model.PrivateDataList;
import com.payline.ws.model.Recurring;
import com.payline.ws.model.Result;
import com.payline.ws.model.SubMerchant;
import com.payline.ws.model.ThreeDSInfo;
import com.payline.ws.model.UnBlockRequest;
import com.payline.ws.model.UnBlockResponse;
import com.payline.ws.model.VerifyAuthenticationRequest;
import com.payline.ws.model.VerifyAuthenticationResponse;
import com.payline.ws.model.VerifyEnrollmentRequest;
import com.payline.ws.model.VerifyEnrollmentResponse;
import com.payline.ws.wrapper.WebServiceWrapper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;

public class DirectPayment
extends WebServiceWrapper {
    private static final Logger logger = Logger.getLogger(DirectPayment.class.getName());
    private boolean initFromFile = true;
    private ConnectParams connectParams;

    public DirectPayment() {
    }

    public DirectPayment(ConnectParams connectParams) {
        this.initFromFile = false;
        this.connectParams = connectParams;
    }

    public final DoAuthorizationResponse doAuthorization(Payment payment, Order order, Buyer buyer, Card card, PrivateDataList privateDataList, Authentication3DSecure authentication3DSecure, BankAccountData bank, String version, SubMerchant subMerchant) {
        this.setException(null);
        DoAuthorizationResponse result = new DoAuthorizationResponse();
        DoAuthorizationRequest parameters = new DoAuthorizationRequest();
        parameters.setPayment(payment);
        parameters.setOrder(order);
        parameters.setBuyer(buyer);
        parameters.setPrivateDataList(privateDataList);
        parameters.setCard(card);
        parameters.setAuthentication3DSecure(authentication3DSecure);
        parameters.setVersion(version);
        parameters.setSubMerchant(subMerchant);
        parameters.setBankAccountData(bank);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.doAuthorization(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doAuthorization call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DoDebitResponse doDebit(Payment payment, Order order, Buyer buyer, Card card, PrivateDataList privateDataList, Authentication3DSecure authentication3DSecure, Authorization authorization, String version, SubMerchant subMerchant) {
        this.setException(null);
        DoDebitResponse result = new DoDebitResponse();
        DoDebitRequest parameters = new DoDebitRequest();
        parameters.setPayment(payment);
        parameters.setAuthorization(authorization);
        parameters.setOrder(order);
        parameters.setBuyer(buyer);
        parameters.setPrivateDataList(privateDataList);
        parameters.setCard(card);
        parameters.setVersion(version);
        parameters.setAuthentication3DSecure(authentication3DSecure);
        parameters.setSubMerchant(subMerchant);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.doDebit(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doDebit call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DoBankTransferResponse doBankTransfer(Payment payment, Creditor creditor, String transationID, String orderID, String comment, String version, PrivateDataList privateDataList) {
        this.setException(null);
        DoBankTransferResponse result = new DoBankTransferResponse();
        DoBankTransferRequest parameters = new DoBankTransferRequest();
        parameters.setPayment(payment);
        parameters.setCreditor(creditor);
        parameters.setTransactionID(transationID);
        parameters.setOrderID(orderID);
        parameters.setComment(comment);
        parameters.setVersion(version);
        parameters.setPrivateDataList(privateDataList);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.doBankTransfer(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doBankTransfer call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DoCaptureResponse doCapture(Payment payment, String transationID, PrivateDataList privateDataList, String sequenceNumber, String version) {
        this.setException(null);
        DoCaptureResponse result = new DoCaptureResponse();
        DoCaptureRequest parameters = new DoCaptureRequest();
        parameters.setPayment(payment);
        parameters.setTransactionID(transationID);
        parameters.setSequenceNumber(sequenceNumber);
        parameters.setPrivateDataList(privateDataList);
        parameters.setVersion(version);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.doCapture(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doCapture call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DoRefundResponse doRefund(Payment payment, String transationID, String comment, PrivateDataList privateDataList, String sequenceNumber, String version, Order order) {
        this.setException(null);
        DoRefundResponse result = new DoRefundResponse();
        DoRefundRequest parameters = new DoRefundRequest();
        parameters.setPayment(payment);
        parameters.setTransactionID(transationID);
        parameters.setComment(comment);
        parameters.setSequenceNumber(sequenceNumber);
        parameters.setPrivateDataList(privateDataList);
        parameters.setVersion(version);
        parameters.setDetails(order.getDetails());
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.doRefund(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doRefund call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DoCreditResponse doCredit(Payment payment, Card card, String comment, Buyer buyer, Order order, PrivateDataList privateDataList, String version, SubMerchant subMerchant) {
        this.setException(null);
        DoCreditResponse result = new DoCreditResponse();
        DoCreditRequest parameters = new DoCreditRequest();
        parameters.setPayment(payment);
        parameters.setCard(card);
        parameters.setComment(comment);
        parameters.setOrder(order);
        parameters.setBuyer(buyer);
        parameters.setPrivateDataList(privateDataList);
        parameters.setVersion(version);
        parameters.setSubMerchant(subMerchant);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.doCredit(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doCredit call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final VerifyEnrollmentResponse verifyEnrollment(Card card, Payment payment, String orderRef, String UsrAgent, String version) {
        return this.verifyEnrollment(card, payment, orderRef, null, null, UsrAgent, version, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public final VerifyEnrollmentResponse verifyEnrollment(Card card, Payment payment, String orderRef, String walletId, String walletCardInd, String UsrAgent, String version, String merchantName, String mdFieldValue, String generateVirtualCvx, String returnURL, Order order, Buyer buyer, SubMerchant subMerchant, Recurring recurring, ThreeDSInfo threeDSinfo, String merchantScore, String transientParam, PrivateDataList privateDataList) {
        this.setException(null);
        VerifyEnrollmentResponse result = new VerifyEnrollmentResponse();
        VerifyEnrollmentRequest parameters = new VerifyEnrollmentRequest();
        parameters.setPayment(payment);
        parameters.setCard(card);
        parameters.setWalletId(walletId);
        parameters.setWalletCardInd(walletCardInd);
        parameters.setOrderRef(orderRef);
        parameters.setUserAgent(UsrAgent);
        parameters.setVersion(version);
        parameters.setMerchantName(merchantName);
        parameters.setMdFieldValue(mdFieldValue);
        parameters.setGenerateVirtualCvx(generateVirtualCvx);
        parameters.setReturnURL(returnURL);
        parameters.setOrder(order);
        parameters.setBuyer(buyer);
        parameters.setSubMerchant(subMerchant);
        parameters.setRecurring(recurring);
        parameters.setThreeDSInfo(threeDSinfo);
        parameters.setMerchantScore(merchantScore);
        parameters.setTransient(transientParam);
        parameters.setPrivateDataList(privateDataList);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.verifyEnrollment(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during verifyEnrollment call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DoResetResponse doReset(String transationID, String comment, String version, String amount, String currency, PrivateDataList privateDataList) {
        return this.doReset(transationID, comment, version, amount, currency, privateDataList, null, null);
    }

    public final DoResetResponse doReset(String transationID, String comment, String version, String amount, String currency, PrivateDataList privateDataList, String sequenceNumber, String media) {
        this.setException(null);
        DoResetResponse result = new DoResetResponse();
        DoResetRequest parameters = new DoResetRequest();
        parameters.setTransactionID(transationID);
        parameters.setComment(comment);
        parameters.setVersion(version);
        parameters.setAmount(amount);
        parameters.setCurrency(currency);
        parameters.setPrivateDataList(privateDataList);
        parameters.setSequenceNumber(sequenceNumber);
        parameters.setMedia(media);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.doReset(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doReset call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final GetBalanceResponse getBalance(String cardID, String contractNumber, String version) {
        this.setException(null);
        GetBalanceResponse result = new GetBalanceResponse();
        GetBalanceRequest parameters = new GetBalanceRequest();
        parameters.setCardID(cardID);
        parameters.setContractNumber(contractNumber);
        parameters.setVersion(version);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.getBalance(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during getBalance call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final GetEncryptionKeyResponse getEncryptionKey() {
        this.setException(null);
        GetEncryptionKeyResponse result = new GetEncryptionKeyResponse();
        GetEncryptionKeyRequest parameters = new GetEncryptionKeyRequest();
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.getEncryptionKey(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during getEncryptionKey call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final GetMerchantSettingsResponse getMerchantSettings(String version) {
        this.setException(null);
        GetMerchantSettingsResponse result = new GetMerchantSettingsResponse();
        GetMerchantSettingsRequest parameters = new GetMerchantSettingsRequest();
        parameters.setVersion(version);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.getMerchantSettings(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during getMerchantSettings call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final GetTokenResponse getToken(String cardNumber, String expirationDate, String contractNumber) {
        GetTokenResponse result = new GetTokenResponse();
        GetTokenRequest parameters = new GetTokenRequest();
        parameters.setCardNumber(cardNumber);
        parameters.setExpirationDate(expirationDate);
        parameters.setContractNumber(contractNumber);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.getToken(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during getToken call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final UnBlockResponse unBlock(String transactionID, String transactionDate, String version) {
        UnBlockResponse result = new UnBlockResponse();
        UnBlockRequest parameters = new UnBlockRequest();
        parameters.setTransactionDate(transactionDate);
        parameters.setVersion(version);
        parameters.setTransactionID(transactionID);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.unBlock(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during unBlock call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DoScoringChequeResponse doScoringCheque(Cheque cheque, Order order, Payment payment, PrivateDataList privatedatalist, String version) {
        this.setException(null);
        DoScoringChequeResponse result = new DoScoringChequeResponse();
        DoScoringChequeRequest parameters = new DoScoringChequeRequest();
        parameters.setCheque(cheque);
        parameters.setOrder(order);
        parameters.setPayment(payment);
        parameters.setPrivateDataList(privatedatalist);
        parameters.setVersion(version);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.doScoringCheque(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doScoringCheque call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DoReAuthorizationResponse doReAuthorization(String transationID, Order order, Payment payment, PrivateDataList privatedatalist, String version) {
        this.setException(null);
        DoReAuthorizationResponse result = new DoReAuthorizationResponse();
        DoReAuthorizationRequest parameters = new DoReAuthorizationRequest();
        parameters.setTransactionID(transationID);
        parameters.setOrder(order);
        parameters.setPayment(payment);
        parameters.setPrivateDataList(privatedatalist);
        parameters.setVersion(version);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.doReAuthorization(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doReAuthorization call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final VerifyAuthenticationResponse verifyAuthentication(String contractNumber, String pares, String md, Card card, String version, String transientParam, PrivateDataList privateDataList) {
        this.setException(null);
        VerifyAuthenticationResponse result = new VerifyAuthenticationResponse();
        VerifyAuthenticationRequest parameters = new VerifyAuthenticationRequest();
        parameters.setContractNumber(contractNumber);
        parameters.setMd(md);
        parameters.setPares(pares);
        parameters.setCard(card);
        parameters.setVersion(version);
        parameters.setTransient(transientParam);
        parameters.setPrivateDataList(privateDataList);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.verifyAuthentication(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during verifyAuthentication call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final IsRegisteredResponse isRegistered(Buyer buyer, Order order, Payment payment, PrivateDataList privatedatalist, String version) {
        IsRegisteredResponse result = new IsRegisteredResponse();
        IsRegisteredRequest parameters = new IsRegisteredRequest();
        parameters.setBuyer(buyer);
        parameters.setOrder(order);
        parameters.setPayment(payment);
        parameters.setPrivateDataList(privatedatalist);
        parameters.setVersion(version);
        try {
            DirectPaymentAPI port = this.initFromFile ? Utils.initServiceDirect() : Utils.initServiceDirect(this.connectParams);
            result = port.isRegistered(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during isRegistered call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }
}

