/*
 * Decompiled with CFR 0.152.
 */
package com.payline.ws.wrapper;

import com.payline.kit.utils.ConnectParams;
import com.payline.kit.utils.PaylineProperties;
import com.payline.kit.utils.Utils;
import com.payline.ws.model.Buyer;
import com.payline.ws.model.ContractNumberWalletList;
import com.payline.ws.model.DoWebPaymentRequest;
import com.payline.ws.model.DoWebPaymentResponse;
import com.payline.ws.model.GetWebPaymentDetailsRequest;
import com.payline.ws.model.GetWebPaymentDetailsResponse;
import com.payline.ws.model.Order;
import com.payline.ws.model.Owner;
import com.payline.ws.model.Payment;
import com.payline.ws.model.PrivateDataList;
import com.payline.ws.model.Recurring;
import com.payline.ws.model.Result;
import com.payline.ws.model.SelectedContractList;
import com.payline.ws.model.SubMerchant;
import com.payline.ws.model.ThreeDSInfo;
import com.payline.ws.model.WebPaymentAPI;
import com.payline.ws.wrapper.WebServiceWrapper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;

public class WebPayment
extends WebServiceWrapper {
    private static final Logger logger = Logger.getLogger(WebPayment.class.getName());
    private boolean initFromFile = true;
    private ConnectParams connectParams;

    public WebPayment() {
    }

    public WebPayment(ConnectParams connectParams) {
        this.initFromFile = false;
        this.connectParams = connectParams;
    }

    public final GetWebPaymentDetailsResponse getWebPaymentDetails(String token, String version) {
        this.setException(null);
        WebPaymentAPI port = null;
        GetWebPaymentDetailsResponse result = new GetWebPaymentDetailsResponse();
        GetWebPaymentDetailsRequest parameters = new GetWebPaymentDetailsRequest();
        parameters.setToken(token);
        parameters.setVersion(version);
        try {
            port = this.initFromFile ? Utils.initServiceWeb() : Utils.initServiceWeb(this.connectParams);
            result = port.getWebPaymentDetails(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during getWebPaymentDetails call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }

    public final DoWebPaymentResponse doWebPayment(String version, Payment payment, Order order, Buyer buyer, PrivateDataList privateDataList, Recurring recurring, String notificationURL, String returnURL, String cancelURL, String languageCode, String securityMode, String customPaymentPageCode, SelectedContractList selectedContractList, SelectedContractList secondSelectedContractList, String customPaymentTemplateURL, String merchantName, SubMerchant subMerchant, String miscData) {
        return this.doWebPayment(version, payment, order, buyer, privateDataList, recurring, notificationURL, returnURL, cancelURL, languageCode, securityMode, customPaymentPageCode, selectedContractList, secondSelectedContractList, customPaymentTemplateURL, merchantName, subMerchant, miscData, null, null, null, null, null, null);
    }

    public final DoWebPaymentResponse doWebPayment(String version, Payment payment, Order order, Buyer buyer, PrivateDataList privateDataList, Recurring recurring, String notificationURL, String returnURL, String cancelURL, String languageCode, String securityMode, String customPaymentPageCode, SelectedContractList selectedContractList, SelectedContractList secondSelectedContractList, String customPaymentTemplateURL, String merchantName, SubMerchant subMerchant, String miscData, Boolean skipSmartDisplay, Owner owner, ContractNumberWalletList contractNumberWalletList, String asynchronousRetryTimeout, ThreeDSInfo threeDSInfo, String merchantScore) {
        this.setException(null);
        DoWebPaymentResponse result = new DoWebPaymentResponse();
        DoWebPaymentRequest parameters = new DoWebPaymentRequest();
        if (this.initFromFile) {
            if (returnURL == null || returnURL.length() == 0) {
                returnURL = PaylineProperties.getString("RETURN_URL");
            }
            if (cancelURL == null || cancelURL.length() == 0) {
                cancelURL = PaylineProperties.getString("CANCEL_URL");
            }
            if (notificationURL == null || notificationURL.length() == 0) {
                notificationURL = PaylineProperties.getString("NOTIFICATION_URL");
            }
            if (payment.getContractNumber() == null || payment.getContractNumber().length() == 0) {
                payment.setContractNumber(PaylineProperties.getString("CONTRACT_NUMBER"));
            }
            if (payment.getAction() == null || payment.getAction().length() == 0) {
                payment.setAction(PaylineProperties.getString("PAYMENT_ACTION"));
            }
            if (payment.getMode() == null || payment.getMode().length() == 0) {
                payment.setMode(PaylineProperties.getString("PAYMENT_MODE"));
            }
            if (selectedContractList == null) {
                String[] contracts;
                String list = PaylineProperties.getString("SELECTED_CONTRACT_LIST");
                selectedContractList = new SelectedContractList();
                for (String con : contracts = list.split(";")) {
                    selectedContractList.getSelectedContract().add(con);
                }
            }
            if (languageCode == null || languageCode.length() == 0) {
                languageCode = PaylineProperties.getString("LANGUAGE_CODE");
            }
            if (securityMode == null || securityMode.length() == 0) {
                securityMode = PaylineProperties.getString("SECURITY_MODE");
            }
        }
        parameters.setVersion(version);
        parameters.setPayment(payment);
        parameters.setOrder(order);
        parameters.setBuyer(buyer);
        parameters.setSkipSmartDisplay(skipSmartDisplay);
        parameters.setOwner(owner);
        parameters.setContractNumberWalletList(contractNumberWalletList);
        if (asynchronousRetryTimeout != null) {
            parameters.setAsynchronousRetryTimeout(asynchronousRetryTimeout);
        }
        parameters.setThreeDSInfo(threeDSInfo);
        parameters.setMerchantScore(merchantScore);
        parameters.setPrivateDataList(privateDataList);
        if (recurring != null && recurring.getAmount().length() > 0) {
            parameters.setRecurring(recurring);
        }
        parameters.setNotificationURL(notificationURL);
        parameters.setReturnURL(returnURL);
        parameters.setCancelURL(cancelURL);
        parameters.setLanguageCode(languageCode);
        parameters.setSecurityMode(securityMode);
        parameters.setCustomPaymentPageCode(customPaymentPageCode);
        parameters.setCustomPaymentTemplateURL(customPaymentTemplateURL);
        parameters.setSelectedContractList(selectedContractList);
        parameters.setSecondSelectedContractList(secondSelectedContractList);
        parameters.setMerchantName(merchantName);
        WebPaymentAPI port = null;
        try {
            port = this.initFromFile ? Utils.initServiceWeb() : Utils.initServiceWeb(this.connectParams);
            result = port.doWebPayment(parameters);
        }
        catch (WebServiceException ex) {
            this.setException((Exception)((Object)ex));
            logger.log(Level.SEVERE, "Error during doWebPayment call : ", ex);
            Result err = new Result();
            err.setCode("XXXXX");
            err.setLongMessage(ex.getMessage());
            err.setShortMessage("EXCEPTION");
            result.setResult(err);
        }
        return result;
    }
}

