/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.os.Bundle;
import android.os.Parcel;
import bolts.Continuation;
import bolts.Task;
import com.parse.AuthenticationCallback;
import com.parse.LogInCallback;
import com.parse.LogOutCallback;
import com.parse.NetworkUserController;
import com.parse.Parse;
import com.parse.ParseAnonymousUtils;
import com.parse.ParseAuthenticationManager;
import com.parse.ParseClassName;
import com.parse.ParseCorePlugins;
import com.parse.ParseCurrentUserController;
import com.parse.ParseEncoder;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseOperationSet;
import com.parse.ParseParcelDecoder;
import com.parse.ParseParcelEncoder;
import com.parse.ParsePlugins;
import com.parse.ParseQuery;
import com.parse.ParseSession;
import com.parse.ParseTaskUtils;
import com.parse.ParseTextUtils;
import com.parse.ParseUserController;
import com.parse.RequestPasswordResetCallback;
import com.parse.SignUpCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@ParseClassName(value="_User")
public class ParseUser
extends ParseObject {
    private static final String KEY_SESSION_TOKEN = "sessionToken";
    private static final String KEY_AUTH_DATA = "authData";
    private static final String KEY_USERNAME = "username";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_EMAIL = "email";
    private static final List<String> READ_ONLY_KEYS = Collections.unmodifiableList(Arrays.asList("sessionToken", "authData"));
    private static final String PARCEL_KEY_IS_CURRENT_USER = "_isCurrentUser";
    private boolean isCurrentUser = false;
    private static final Object isAutoUserEnabledMutex = new Object();
    private static boolean autoUserEnabled;

    public static ParseQuery<ParseUser> getQuery() {
        return ParseQuery.getQuery(ParseUser.class);
    }

    static ParseUserController getUserController() {
        return ParseCorePlugins.getInstance().getUserController();
    }

    static ParseCurrentUserController getCurrentUserController() {
        return ParseCorePlugins.getInstance().getCurrentUserController();
    }

    static ParseAuthenticationManager getAuthenticationManager() {
        return ParseCorePlugins.getInstance().getAuthenticationManager();
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }

    @Override
    boolean isKeyMutable(String key) {
        return !READ_ONLY_KEYS.contains(key);
    }

    State.Builder newStateBuilder(String className) {
        return new State.Builder();
    }

    @Override
    State getState() {
        return (State)super.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLazy() {
        Object object = this.mutex;
        synchronized (object) {
            return this.getObjectId() == null && ParseAnonymousUtils.isLinked(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthenticated() {
        Object object = this.mutex;
        synchronized (object) {
            ParseUser current = ParseUser.getCurrentUser();
            return this.isLazy() || this.getState().sessionToken() != null && current != null && this.getObjectId().equals(current.getObjectId());
        }
    }

    @Override
    public void remove(String key) {
        if (KEY_USERNAME.equals(key)) {
            throw new IllegalArgumentException("Can't remove the username key.");
        }
        super.remove(key);
    }

    @Override
    JSONObject toRest(ParseObject.State state, List<ParseOperationSet> operationSetQueue, ParseEncoder objectEncoder) {
        List<ParseOperationSet> cleanOperationSetQueue = operationSetQueue;
        for (int i = 0; i < operationSetQueue.size(); ++i) {
            ParseOperationSet operations = operationSetQueue.get(i);
            if (!operations.containsKey(KEY_PASSWORD)) continue;
            if (cleanOperationSetQueue == operationSetQueue) {
                cleanOperationSetQueue = new LinkedList<ParseOperationSet>(operationSetQueue);
            }
            ParseOperationSet cleanOperations = new ParseOperationSet(operations);
            cleanOperations.remove(KEY_PASSWORD);
            cleanOperationSetQueue.set(i, cleanOperations);
        }
        return super.toRest(state, cleanOperationSetQueue, objectEncoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> cleanUpAuthDataAsync() {
        Map<String, Map<String, String>> authData;
        ParseAuthenticationManager controller = ParseUser.getAuthenticationManager();
        Object object = this.mutex;
        synchronized (object) {
            authData = this.getState().authData();
            if (authData.size() == 0) {
                return Task.forResult(null);
            }
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        Iterator<Map.Entry<String, Map<String, String>>> i = authData.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = i.next();
            if (entry.getValue() != null) continue;
            i.remove();
            tasks.add(controller.restoreAuthenticationAsync(entry.getKey(), null).makeVoid());
        }
        State newState = this.getState().newBuilder().authData(authData).build();
        this.setState(newState);
        return Task.whenAll(tasks);
    }

    @Override
    Task<Void> handleSaveResultAsync(ParseObject.State result, ParseOperationSet operationsBeforeSave) {
        boolean success;
        boolean bl = success = result != null;
        if (success) {
            operationsBeforeSave.remove(KEY_PASSWORD);
        }
        return super.handleSaveResultAsync(result, operationsBeforeSave);
    }

    @Override
    void validateSaveEventually() throws ParseException {
        if (this.isDirty(KEY_PASSWORD)) {
            throw new ParseException(-1, "Unable to saveEventually on a ParseUser with dirty password");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCurrentUser() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isCurrentUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIsCurrentUser(boolean isCurrentUser) {
        Object object = this.mutex;
        synchronized (object) {
            this.isCurrentUser = isCurrentUser;
        }
    }

    public String getSessionToken() {
        return this.getState().sessionToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> setSessionTokenInBackground(String newSessionToken) {
        Object object = this.mutex;
        synchronized (object) {
            State state = this.getState();
            if (newSessionToken.equals(state.sessionToken())) {
                return Task.forResult(null);
            }
            State.Builder builder = state.newBuilder().sessionToken(newSessionToken);
            this.setState(builder.build());
            return ParseUser.saveCurrentUserAsync(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Map<String, String>> getAuthData() {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Map<String, String>> authData = this.getMap(KEY_AUTH_DATA);
            if (authData == null) {
                authData = new HashMap();
            }
            return authData;
        }
    }

    private Map<String, String> getAuthData(String authType) {
        return this.getAuthData().get(authType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putAuthData(String authType, Map<String, String> authData) {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Map<String, String>> newAuthData = this.getAuthData();
            newAuthData.put(authType, authData);
            this.performPut(KEY_AUTH_DATA, newAuthData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAuthData(String authType) {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Map<String, String>> newAuthData = this.getAuthData();
            newAuthData.remove(authType);
            this.performPut(KEY_AUTH_DATA, newAuthData);
        }
    }

    public void setUsername(String username) {
        this.put(KEY_USERNAME, username);
    }

    public String getUsername() {
        return this.getString(KEY_USERNAME);
    }

    public void setPassword(String password) {
        this.put(KEY_PASSWORD, password);
    }

    String getPassword() {
        return this.getString(KEY_PASSWORD);
    }

    public void setEmail(String email) {
        this.put(KEY_EMAIL, email);
    }

    public String getEmail() {
        return this.getString(KEY_EMAIL);
    }

    public boolean isNew() {
        return this.getState().isNew();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object value) {
        Object object = this.mutex;
        synchronized (object) {
            if (KEY_USERNAME.equals(key)) {
                this.stripAnonymity();
            }
            super.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stripAnonymity() {
        Object object = this.mutex;
        synchronized (object) {
            if (ParseAnonymousUtils.isLinked(this)) {
                if (this.getObjectId() != null) {
                    this.putAuthData("anonymous", null);
                } else {
                    this.removeAuthData("anonymous");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreAnonymity(Map<String, String> anonymousData) {
        Object object = this.mutex;
        synchronized (object) {
            if (anonymousData != null) {
                this.putAuthData("anonymous", anonymousData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateSave() {
        ParseUser current;
        Object object = this.mutex;
        synchronized (object) {
            if (this.getObjectId() == null) {
                throw new IllegalArgumentException("Cannot save a ParseUser until it has been signed up. Call signUp first.");
            }
            if (this.isAuthenticated() || !this.isDirty() || this.isCurrentUser()) {
                return;
            }
        }
        if (!Parse.isLocalDatastoreEnabled() && (current = ParseUser.getCurrentUser()) != null && this.getObjectId().equals(current.getObjectId())) {
            return;
        }
        throw new IllegalArgumentException("Cannot save a ParseUser that is not authenticated.");
    }

    @Override
    Task<Void> saveAsync(String sessionToken, Task<Void> toAwait) {
        return this.saveAsync(sessionToken, this.isLazy(), toAwait);
    }

    Task<Void> saveAsync(String sessionToken, boolean isLazy, Task<Void> toAwait) {
        Task<Void> task = isLazy ? this.resolveLazinessAsync(toAwait) : super.saveAsync(sessionToken, toAwait);
        if (this.isCurrentUser()) {
            return task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return ParseUser.this.cleanUpAuthDataAsync();
                }
            }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return ParseUser.saveCurrentUserAsync(ParseUser.this);
                }
            });
        }
        return task;
    }

    @Override
    void setState(ParseObject.State newState) {
        if (this.isCurrentUser()) {
            State.Builder newStateBuilder = (State.Builder)newState.newBuilder();
            if (this.getSessionToken() != null && newState.get(KEY_SESSION_TOKEN) == null) {
                newStateBuilder.put(KEY_SESSION_TOKEN, this.getSessionToken());
            }
            if (this.getAuthData().size() > 0 && newState.get(KEY_AUTH_DATA) == null) {
                newStateBuilder.put(KEY_AUTH_DATA, this.getAuthData());
            }
            newState = newStateBuilder.build();
        }
        super.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateDelete() {
        Object object = this.mutex;
        synchronized (object) {
            super.validateDelete();
            if (!this.isAuthenticated() && this.isDirty()) {
                throw new IllegalArgumentException("Cannot delete a ParseUser that is not authenticated.");
            }
        }
    }

    public ParseUser fetch() throws ParseException {
        return (ParseUser)super.fetch();
    }

    @Override
    <T extends ParseObject> Task<T> fetchAsync(String sessionToken, Task<Void> toAwait) {
        if (this.isLazy()) {
            return Task.forResult((Object)this);
        }
        Task task = super.fetchAsync(sessionToken, toAwait);
        if (this.isCurrentUser()) {
            return task.onSuccessTask(new Continuation<T, Task<Void>>(){

                public Task<Void> then(Task<T> fetchAsyncTask) throws Exception {
                    return ParseUser.this.cleanUpAuthDataAsync();
                }
            }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return ParseUser.saveCurrentUserAsync(ParseUser.this);
                }
            }).onSuccess(new Continuation<Void, T>(){

                public T then(Task<Void> task) throws Exception {
                    return ParseUser.this;
                }
            });
        }
        return task;
    }

    public Task<Void> signUpInBackground() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseUser.this.signUpAsync(task);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> signUpAsync(Task<Void> toAwait) {
        final ParseUser user = ParseUser.getCurrentUser();
        Object object = this.mutex;
        synchronized (object) {
            String sessionToken;
            String string = sessionToken = user != null ? user.getSessionToken() : null;
            if (ParseTextUtils.isEmpty(this.getUsername())) {
                return Task.forError((Exception)new IllegalArgumentException("Username cannot be missing or blank"));
            }
            if (ParseTextUtils.isEmpty(this.getPassword())) {
                return Task.forError((Exception)new IllegalArgumentException("Password cannot be missing or blank"));
            }
            if (this.getObjectId() != null) {
                Map<String, Map<String, String>> authData = this.getAuthData();
                if (authData.containsKey("anonymous") && authData.get("anonymous") == null) {
                    return this.saveAsync(sessionToken, toAwait);
                }
                return Task.forError((Exception)new IllegalArgumentException("Cannot sign up a user that has already signed up."));
            }
            if (this.operationSetQueue.size() > 1) {
                return Task.forError((Exception)new IllegalArgumentException("Cannot sign up a user that is already signing up."));
            }
            if (user != null && ParseAnonymousUtils.isLinked(user)) {
                if (this == user) {
                    return Task.forError((Exception)new IllegalArgumentException("Attempt to merge currentUser with itself."));
                }
                boolean isLazy = user.isLazy();
                final String oldUsername = user.getUsername();
                final String oldPassword = user.getPassword();
                final Map<String, String> anonymousData = user.getAuthData("anonymous");
                user.copyChangesFrom(this);
                user.setUsername(this.getUsername());
                user.setPassword(this.getPassword());
                this.revert();
                return user.saveAsync(sessionToken, isLazy, toAwait).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Task<Void> then(Task<Void> task) throws Exception {
                        if (task.isCancelled() || task.isFaulted()) {
                            Object object = user.mutex;
                            synchronized (object) {
                                if (oldUsername != null) {
                                    user.setUsername(oldUsername);
                                } else {
                                    user.revert(ParseUser.KEY_USERNAME);
                                }
                                if (oldPassword != null) {
                                    user.setPassword(oldPassword);
                                } else {
                                    user.revert(ParseUser.KEY_PASSWORD);
                                }
                                user.restoreAnonymity(anonymousData);
                            }
                            return task;
                        }
                        user.revert(ParseUser.KEY_PASSWORD);
                        ParseUser.this.revert(ParseUser.KEY_PASSWORD);
                        ParseUser.this.mergeFromObject(user);
                        return ParseUser.saveCurrentUserAsync(ParseUser.this);
                    }
                });
            }
            final ParseOperationSet operations = this.startSave();
            return toAwait.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return ParseUser.getUserController().signUpAsync(ParseUser.this.getState(), operations, sessionToken).continueWithTask((Continuation)new Continuation<State, Task<Void>>(){

                        public Task<Void> then(final Task<State> signUpTask) throws Exception {
                            State result = (State)signUpTask.getResult();
                            return ParseUser.this.handleSaveResultAsync(result, operations).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                public Task<Void> then(Task<Void> task) throws Exception {
                                    if (!signUpTask.isCancelled() && !signUpTask.isFaulted()) {
                                        return ParseUser.saveCurrentUserAsync(ParseUser.this);
                                    }
                                    return signUpTask.makeVoid();
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    public void signUp() throws ParseException {
        ParseTaskUtils.wait(this.signUpInBackground());
    }

    public void signUpInBackground(SignUpCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.signUpInBackground(), callback);
    }

    public static Task<ParseUser> logInInBackground(String username, String password) {
        if (username == null) {
            throw new IllegalArgumentException("Must specify a username for the user to log in with");
        }
        if (password == null) {
            throw new IllegalArgumentException("Must specify a password for the user to log in with");
        }
        return ParseUser.getUserController().logInAsync(username, password).onSuccessTask((Continuation)new Continuation<State, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<State> task) throws Exception {
                State result = (State)task.getResult();
                final ParseUser newCurrent = (ParseUser)ParseObject.from(result);
                return ParseUser.saveCurrentUserAsync(newCurrent).onSuccess((Continuation)new Continuation<Void, ParseUser>(){

                    public ParseUser then(Task<Void> task) throws Exception {
                        return newCurrent;
                    }
                });
            }
        });
    }

    public static ParseUser logIn(String username, String password) throws ParseException {
        return ParseTaskUtils.wait(ParseUser.logInInBackground(username, password));
    }

    public static void logInInBackground(String username, String password, LogInCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseUser.logInInBackground(username, password), callback);
    }

    public static Task<ParseUser> becomeInBackground(String sessionToken) {
        if (sessionToken == null) {
            throw new IllegalArgumentException("Must specify a sessionToken for the user to log in with");
        }
        return ParseUser.getUserController().getUserAsync(sessionToken).onSuccessTask((Continuation)new Continuation<State, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<State> task) throws Exception {
                State result = (State)task.getResult();
                final ParseUser user = (ParseUser)ParseObject.from(result);
                return ParseUser.saveCurrentUserAsync(user).onSuccess((Continuation)new Continuation<Void, ParseUser>(){

                    public ParseUser then(Task<Void> task) throws Exception {
                        return user;
                    }
                });
            }
        });
    }

    public static ParseUser become(String sessionToken) throws ParseException {
        return ParseTaskUtils.wait(ParseUser.becomeInBackground(sessionToken));
    }

    public static void becomeInBackground(String sessionToken, LogInCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseUser.becomeInBackground(sessionToken), callback);
    }

    static Task<ParseUser> getCurrentUserAsync() {
        return ParseUser.getCurrentUserController().getAsync();
    }

    public static ParseUser getCurrentUser() {
        return ParseUser.getCurrentUser(ParseUser.isAutomaticUserEnabled());
    }

    private static ParseUser getCurrentUser(boolean shouldAutoCreateUser) {
        try {
            return ParseTaskUtils.wait(ParseUser.getCurrentUserController().getAsync(shouldAutoCreateUser));
        }
        catch (ParseException e) {
            return null;
        }
    }

    static String getCurrentSessionToken() {
        ParseUser current = ParseUser.getCurrentUser();
        return current != null ? current.getSessionToken() : null;
    }

    static Task<String> getCurrentSessionTokenAsync() {
        return ParseUser.getCurrentUserController().getCurrentSessionTokenAsync();
    }

    private static Task<Void> saveCurrentUserAsync(ParseUser user) {
        return ParseUser.getCurrentUserController().setAsync(user);
    }

    static Task<Void> pinCurrentUserIfNeededAsync(ParseUser user) {
        if (!Parse.isLocalDatastoreEnabled()) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Parse#enableLocalDatastore(Context)`.");
        }
        return ParseUser.getCurrentUserController().setIfNeededAsync(user);
    }

    public static Task<Void> logOutInBackground() {
        return ParseUser.getCurrentUserController().logOutAsync();
    }

    public static void logOutInBackground(LogOutCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseUser.logOutInBackground(), callback);
    }

    public static void logOut() {
        try {
            ParseTaskUtils.wait(ParseUser.logOutInBackground());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    Task<Void> logOutAsync() {
        return this.logOutAsync(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> logOutAsync(boolean revoke) {
        String oldSessionToken;
        ParseAuthenticationManager controller = ParseUser.getAuthenticationManager();
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>();
        Object object = this.mutex;
        synchronized (object) {
            oldSessionToken = this.getState().sessionToken();
            for (Map.Entry<String, Map<String, String>> entry : this.getAuthData().entrySet()) {
                tasks.add(controller.deauthenticateAsync(entry.getKey()));
            }
            State newState = this.getState().newBuilder().sessionToken(null).isNew(false).build();
            this.isCurrentUser = false;
            this.setState(newState);
        }
        if (revoke) {
            tasks.add(ParseSession.revokeAsync(oldSessionToken));
        }
        return Task.whenAll(tasks);
    }

    public static Task<Void> requestPasswordResetInBackground(String email) {
        return ParseUser.getUserController().requestPasswordResetAsync(email);
    }

    public static void requestPasswordReset(String email) throws ParseException {
        ParseTaskUtils.wait(ParseUser.requestPasswordResetInBackground(email));
    }

    public static void requestPasswordResetInBackground(String email, RequestPasswordResetCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParseUser.requestPasswordResetInBackground(email), callback);
    }

    public ParseUser fetchIfNeeded() throws ParseException {
        return (ParseUser)super.fetchIfNeeded();
    }

    public static void registerAuthenticationCallback(String authType, AuthenticationCallback callback) {
        ParseUser.getAuthenticationManager().register(authType, callback);
    }

    public static Task<ParseUser> logInWithInBackground(final String authType, final Map<String, String> authData) {
        if (authType == null) {
            throw new IllegalArgumentException("Invalid authType: " + null);
        }
        Continuation<Void, Task<ParseUser>> logInWithTask = new Continuation<Void, Task<ParseUser>>(){

            public Task<ParseUser> then(Task<Void> task) throws Exception {
                return ParseUser.getUserController().logInAsync(authType, authData).onSuccessTask((Continuation)new Continuation<State, Task<ParseUser>>(){

                    public Task<ParseUser> then(Task<State> task) throws Exception {
                        State result = (State)task.getResult();
                        final ParseUser user = (ParseUser)ParseObject.from(result);
                        return ParseUser.saveCurrentUserAsync(user).onSuccess((Continuation)new Continuation<Void, ParseUser>(){

                            public ParseUser then(Task<Void> task) throws Exception {
                                return user;
                            }
                        });
                    }
                });
            }
        };
        return ParseUser.getCurrentUserController().getAsync(false).onSuccessTask((Continuation)new Continuation<ParseUser, Task<ParseUser>>((Continuation)logInWithTask){
            final /* synthetic */ Continuation val$logInWithTask;
            {
                this.val$logInWithTask = continuation;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<ParseUser> then(Task<ParseUser> task) throws Exception {
                final ParseUser user = (ParseUser)task.getResult();
                if (user != null) {
                    Object object = user.mutex;
                    synchronized (object) {
                        if (ParseAnonymousUtils.isLinked(user)) {
                            if (user.isLazy()) {
                                final Map oldAnonymousData = user.getAuthData("anonymous");
                                return user.taskQueue.enqueue(new Continuation<Void, Task<ParseUser>>(){

                                    public Task<ParseUser> then(Task<Void> toAwait) throws Exception {
                                        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public Task<Void> then(Task<Void> task) throws Exception {
                                                Object object = user.mutex;
                                                synchronized (object) {
                                                    user.stripAnonymity();
                                                    user.putAuthData(authType, authData);
                                                    return user.resolveLazinessAsync(task);
                                                }
                                            }
                                        }).continueWithTask((Continuation)new Continuation<Void, Task<ParseUser>>(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public Task<ParseUser> then(Task<Void> task) throws Exception {
                                                Object object = user.mutex;
                                                synchronized (object) {
                                                    if (task.isFaulted()) {
                                                        user.removeAuthData(authType);
                                                        user.restoreAnonymity(oldAnonymousData);
                                                        return Task.forError((Exception)task.getError());
                                                    }
                                                    if (task.isCancelled()) {
                                                        return Task.cancelled();
                                                    }
                                                    return Task.forResult((Object)user);
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                            return user.linkWithInBackground(authType, authData).continueWithTask((Continuation)new Continuation<Void, Task<ParseUser>>(){

                                public Task<ParseUser> then(Task<Void> task) throws Exception {
                                    Exception error;
                                    if (task.isFaulted() && (error = task.getError()) instanceof ParseException && ((ParseException)error).getCode() == 208) {
                                        return Task.forResult(null).continueWithTask(val$logInWithTask);
                                    }
                                    if (task.isCancelled()) {
                                        return Task.cancelled();
                                    }
                                    return Task.forResult((Object)user);
                                }
                            });
                        }
                    }
                }
                return Task.forResult(null).continueWithTask(this.val$logInWithTask);
            }
        });
    }

    public boolean isLinked(String authType) {
        Map<String, Map<String, String>> authData = this.getAuthData();
        return authData.containsKey(authType) && authData.get(authType) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> synchronizeAllAuthDataAsync() {
        Map<String, Map<String, String>> authData;
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isCurrentUser()) {
                return Task.forResult(null);
            }
            authData = this.getAuthData();
        }
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>(authData.size());
        for (String authType : authData.keySet()) {
            tasks.add(this.synchronizeAuthDataAsync(authType));
        }
        return Task.whenAll(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> synchronizeAuthDataAsync(String authType) {
        Map<String, String> authData;
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isCurrentUser()) {
                return Task.forResult(null);
            }
            authData = this.getAuthData(authType);
        }
        return this.synchronizeAuthDataAsync(ParseUser.getAuthenticationManager(), authType, authData);
    }

    private Task<Void> synchronizeAuthDataAsync(ParseAuthenticationManager manager, final String authType, Map<String, String> authData) {
        return manager.restoreAuthenticationAsync(authType, authData).continueWithTask((Continuation)new Continuation<Boolean, Task<Void>>(){

            public Task<Void> then(Task<Boolean> task) throws Exception {
                boolean success;
                boolean bl = success = !task.isFaulted() && (Boolean)task.getResult() != false;
                if (!success) {
                    return ParseUser.this.unlinkFromInBackground(authType);
                }
                return task.makeVoid();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> linkWithAsync(final String authType, Map<String, String> authData, Task<Void> toAwait, String sessionToken) {
        Object object = this.mutex;
        synchronized (object) {
            boolean isLazy = this.isLazy();
            final Map<String, String> oldAnonymousData = this.getAuthData("anonymous");
            this.stripAnonymity();
            this.putAuthData(authType, authData);
            return this.saveAsync(sessionToken, isLazy, toAwait).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Task<Void> then(Task<Void> task) throws Exception {
                    Object object = ParseUser.this.mutex;
                    synchronized (object) {
                        if (task.isFaulted() || task.isCancelled()) {
                            ParseUser.this.restoreAnonymity(oldAnonymousData);
                            return task;
                        }
                        return ParseUser.this.synchronizeAuthDataAsync(authType);
                    }
                }
            });
        }
    }

    private Task<Void> linkWithAsync(final String authType, final Map<String, String> authData, final String sessionToken) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseUser.this.linkWithAsync(authType, authData, (Task<Void>)task, sessionToken);
            }
        });
    }

    public Task<Void> linkWithInBackground(String authType, Map<String, String> authData) {
        if (authType == null) {
            throw new IllegalArgumentException("Invalid authType: " + null);
        }
        return this.linkWithAsync(authType, authData, this.getSessionToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> unlinkFromInBackground(String authType) {
        if (authType == null) {
            return Task.forResult(null);
        }
        Object object = this.mutex;
        synchronized (object) {
            if (!this.getAuthData().containsKey(authType)) {
                return Task.forResult(null);
            }
            this.putAuthData(authType, null);
        }
        return this.saveInBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> resolveLazinessAsync(Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.getAuthData().size() == 0) {
                return this.signUpAsync(toAwait);
            }
            final ParseOperationSet operations = this.startSave();
            return toAwait.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return ParseUser.getUserController().logInAsync(ParseUser.this.getState(), operations).onSuccessTask((Continuation)new Continuation<State, Task<Void>>(){

                        public Task<Void> then(Task<State> task) throws Exception {
                            final State result = (State)task.getResult();
                            Task resultTask = Parse.isLocalDatastoreEnabled() && !result.isNew() ? Task.forResult((Object)result) : ParseUser.this.handleSaveResultAsync(result, operations).onSuccess((Continuation)new Continuation<Void, State>(){

                                public State then(Task<Void> task) throws Exception {
                                    return result;
                                }
                            });
                            return resultTask.onSuccessTask((Continuation)new Continuation<State, Task<Void>>(){

                                public Task<Void> then(Task<State> task) throws Exception {
                                    State result = (State)task.getResult();
                                    if (!result.isNew()) {
                                        ParseUser newUser = (ParseUser)ParseObject.from(result);
                                        return ParseUser.saveCurrentUserAsync(newUser);
                                    }
                                    return task.makeVoid();
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    @Override
    <T extends ParseObject> Task<T> fetchFromLocalDatastoreAsync() {
        if (this.isLazy()) {
            return Task.forResult((Object)this);
        }
        return super.fetchFromLocalDatastoreAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableAutomaticUser() {
        Object object = isAutoUserEnabledMutex;
        synchronized (object) {
            autoUserEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableAutomaticUser() {
        Object object = isAutoUserEnabledMutex;
        synchronized (object) {
            autoUserEnabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isAutomaticUserEnabled() {
        Object object = isAutoUserEnabledMutex;
        synchronized (object) {
            return autoUserEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Object object = this.mutex;
        synchronized (object) {
            outState.putBoolean(PARCEL_KEY_IS_CURRENT_USER, this.isCurrentUser);
        }
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedState) {
        super.onRestoreInstanceState(savedState);
        this.setIsCurrentUser(savedState.getBoolean(PARCEL_KEY_IS_CURRENT_USER, false));
    }

    public static Task<Void> enableRevocableSessionInBackground() {
        ParseCorePlugins.getInstance().registerUserController(new NetworkUserController(ParsePlugins.get().restClient(), true));
        return ParseUser.getCurrentUserController().getAsync(false).onSuccessTask((Continuation)new Continuation<ParseUser, Task<Void>>(){

            public Task<Void> then(Task<ParseUser> task) throws Exception {
                ParseUser user = (ParseUser)task.getResult();
                if (user == null) {
                    return Task.forResult(null);
                }
                return user.upgradeToRevocableSessionAsync();
            }
        });
    }

    Task<Void> upgradeToRevocableSessionAsync() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return ParseUser.this.upgradeToRevocableSessionAsync((Task<Void>)toAwait);
            }
        });
    }

    private Task<Void> upgradeToRevocableSessionAsync(Task<Void> toAwait) {
        final String sessionToken = this.getSessionToken();
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<String>>(){

            public Task<String> then(Task<Void> task) throws Exception {
                return ParseSession.upgradeToRevocableSessionAsync(sessionToken);
            }
        }).onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String result = (String)task.getResult();
                return ParseUser.this.setSessionTokenInBackground(result);
            }
        });
    }

    static class State
    extends ParseObject.State {
        private final boolean isNew;

        private State(Builder builder) {
            super(builder);
            this.isNew = builder.isNew;
        }

        State(Parcel source, String className, ParseParcelDecoder decoder) {
            super(source, className, decoder);
            this.isNew = source.readByte() == 1;
        }

        public Builder newBuilder() {
            return new Builder(this);
        }

        public String sessionToken() {
            return (String)this.get(ParseUser.KEY_SESSION_TOKEN);
        }

        public Map<String, Map<String, String>> authData() {
            HashMap authData = (HashMap)this.get(ParseUser.KEY_AUTH_DATA);
            if (authData == null) {
                authData = new HashMap();
            }
            return authData;
        }

        public boolean isNew() {
            return this.isNew;
        }

        @Override
        protected void writeToParcel(Parcel dest, ParseParcelEncoder encoder) {
            super.writeToParcel(dest, encoder);
            dest.writeByte(this.isNew ? (byte)1 : 0);
        }

        static class Builder
        extends ParseObject.State.Init<Builder> {
            private boolean isNew;

            public Builder() {
                super("_User");
            }

            Builder(State state) {
                super(state);
                this.isNew = state.isNew();
            }

            @Override
            Builder self() {
                return this;
            }

            @Override
            public State build() {
                return new State(this);
            }

            @Override
            public Builder apply(ParseObject.State other) {
                this.isNew(((State)other).isNew());
                return (Builder)super.apply(other);
            }

            public Builder sessionToken(String sessionToken) {
                return (Builder)this.put(ParseUser.KEY_SESSION_TOKEN, sessionToken);
            }

            public Builder authData(Map<String, Map<String, String>> authData) {
                return (Builder)this.put(ParseUser.KEY_AUTH_DATA, authData);
            }

            public Builder putAuthData(String authType, Map<String, String> authData) {
                HashMap<String, Map<String, String>> newAuthData = (HashMap<String, Map<String, String>>)this.serverData.get(ParseUser.KEY_AUTH_DATA);
                if (newAuthData == null) {
                    newAuthData = new HashMap<String, Map<String, String>>();
                }
                newAuthData.put(authType, authData);
                this.serverData.put(ParseUser.KEY_AUTH_DATA, newAuthData);
                return this;
            }

            public Builder isNew(boolean isNew) {
                this.isNew = isNew;
                return this;
            }
        }
    }
}

