/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.AggregateException;
import bolts.Continuation;
import bolts.Task;
import bolts.TaskCompletionSource;
import com.parse.ParseCallback1;
import com.parse.ParseCallback2;
import com.parse.ParseException;
import com.parse.ParseExecutors;
import java.util.concurrent.CancellationException;

class ParseTaskUtils {
    ParseTaskUtils() {
    }

    static <T> T wait(Task<T> task) throws ParseException {
        try {
            task.waitForCompletion();
            if (task.isFaulted()) {
                Exception error = task.getError();
                if (error instanceof ParseException) {
                    throw (ParseException)error;
                }
                if (error instanceof AggregateException) {
                    throw new ParseException(error);
                }
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new RuntimeException(error);
            }
            if (task.isCancelled()) {
                throw new RuntimeException(new CancellationException());
            }
            return (T)task.getResult();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static Task<Void> callbackOnMainThreadAsync(Task<Void> task, ParseCallback1<ParseException> callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(task, callback, false);
    }

    static Task<Void> callbackOnMainThreadAsync(Task<Void> task, final ParseCallback1<ParseException> callback, boolean reportCancellation) {
        if (callback == null) {
            return task;
        }
        return ParseTaskUtils.callbackOnMainThreadAsync(task, new ParseCallback2<Void, ParseException>(){

            @Override
            public void done(Void aVoid, ParseException e) {
                callback.done(e);
            }
        }, reportCancellation);
    }

    static <T> Task<T> callbackOnMainThreadAsync(Task<T> task, ParseCallback2<T, ParseException> callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(task, callback, false);
    }

    static <T> Task<T> callbackOnMainThreadAsync(Task<T> task, final ParseCallback2<T, ParseException> callback, final boolean reportCancellation) {
        if (callback == null) {
            return task;
        }
        final TaskCompletionSource tcs = new TaskCompletionSource();
        task.continueWith(new Continuation<T, Void>(){

            public Void then(final Task<T> task) throws Exception {
                if (task.isCancelled() && !reportCancellation) {
                    tcs.setCancelled();
                    return null;
                }
                ParseExecutors.main().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Exception error = task.getError();
                            if (error != null && !(error instanceof ParseException)) {
                                error = new ParseException(error);
                            }
                            callback.done(task.getResult(), (ParseException)error);
                        }
                        finally {
                            if (task.isCancelled()) {
                                tcs.setCancelled();
                            } else if (task.isFaulted()) {
                                tcs.setError(task.getError());
                            } else {
                                tcs.setResult(task.getResult());
                            }
                        }
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }
}

