/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.PLog;
import com.parse.ParseCorePlugins;
import com.parse.ParseException;
import com.parse.ParseInstallation;
import com.parse.ParseObjectSubclassingController;
import com.parse.ParsePushChannelsController;
import com.parse.ParsePushController;
import com.parse.ParseQuery;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;
import com.parse.SaveCallback;
import com.parse.SendCallback;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ParsePush {
    static String KEY_DATA_MESSAGE = "alert";
    private static final String TAG = "com.parse.ParsePush";
    final State.Builder builder;

    static ParsePushController getPushController() {
        return ParseCorePlugins.getInstance().getPushController();
    }

    static ParsePushChannelsController getPushChannelsController() {
        return ParseCorePlugins.getInstance().getPushChannelsController();
    }

    private static ParseObjectSubclassingController getSubclassingController() {
        return ParseCorePlugins.getInstance().getSubclassingController();
    }

    private static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public ParsePush() {
        this(new State.Builder());
    }

    public ParsePush(ParsePush push) {
        this(new State.Builder(push.builder.build()));
    }

    private ParsePush(State.Builder builder) {
        this.builder = builder;
    }

    public static Task<Void> subscribeInBackground(String channel) {
        return ParsePush.getPushChannelsController().subscribeInBackground(channel);
    }

    public static void subscribeInBackground(String channel, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParsePush.subscribeInBackground(channel), callback);
    }

    public static Task<Void> unsubscribeInBackground(String channel) {
        return ParsePush.getPushChannelsController().unsubscribeInBackground(channel);
    }

    public static void unsubscribeInBackground(String channel, SaveCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParsePush.unsubscribeInBackground(channel), callback);
    }

    public static Task<Void> sendMessageInBackground(String message, ParseQuery<ParseInstallation> query) {
        ParsePush push = new ParsePush();
        push.setQuery(query);
        push.setMessage(message);
        return push.sendInBackground();
    }

    public static void sendMessageInBackground(String message, ParseQuery<ParseInstallation> query, SendCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParsePush.sendMessageInBackground(message, query), callback);
    }

    public static Task<Void> sendDataInBackground(JSONObject data, ParseQuery<ParseInstallation> query) {
        ParsePush push = new ParsePush();
        push.setQuery(query);
        push.setData(data);
        return push.sendInBackground();
    }

    public static void sendDataInBackground(JSONObject data, ParseQuery<ParseInstallation> query, SendCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(ParsePush.sendDataInBackground(data, query), callback);
    }

    public void setChannel(String channel) {
        this.builder.channelSet(Collections.singletonList(channel));
    }

    public void setChannels(Collection<String> channels) {
        this.builder.channelSet(channels);
    }

    public void setQuery(ParseQuery<ParseInstallation> query) {
        this.builder.query(query);
    }

    public void setExpirationTime(long time) {
        this.builder.expirationTime(time);
    }

    public void setExpirationTimeInterval(long timeInterval) {
        this.builder.expirationTimeInterval(timeInterval);
    }

    public void clearExpiration() {
        this.builder.expirationTime(null);
        this.builder.expirationTimeInterval(null);
    }

    public void setPushTime(long time) {
        this.builder.pushTime(time);
    }

    @Deprecated
    public void setPushToIOS(boolean pushToIOS) {
        this.builder.pushToIOS(pushToIOS);
    }

    @Deprecated
    public void setPushToAndroid(boolean pushToAndroid) {
        this.builder.pushToAndroid(pushToAndroid);
    }

    public void setData(JSONObject data) {
        this.builder.data(data);
    }

    public void setMessage(String message) {
        JSONObject data = new JSONObject();
        try {
            data.put(KEY_DATA_MESSAGE, (Object)message);
        }
        catch (JSONException e) {
            PLog.e(TAG, "JSONException in setMessage", e);
        }
        this.setData(data);
    }

    public Task<Void> sendInBackground() {
        final State state = this.builder.build();
        return ParseUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return ParsePush.getPushController().sendInBackground(state, sessionToken);
            }
        });
    }

    public void send() throws ParseException {
        ParseTaskUtils.wait(this.sendInBackground());
    }

    public void sendInBackground(SendCallback callback) {
        ParseTaskUtils.callbackOnMainThreadAsync(this.sendInBackground(), callback);
    }

    static class State {
        private final Set<String> channelSet;
        private final ParseQuery.State<ParseInstallation> queryState;
        private final Long expirationTime;
        private final Long expirationTimeInterval;
        private final Long pushTime;
        private final Boolean pushToIOS;
        private final Boolean pushToAndroid;
        private final JSONObject data;

        private State(Builder builder) {
            this.channelSet = builder.channelSet == null ? null : Collections.unmodifiableSet(new HashSet(builder.channelSet));
            this.queryState = builder.query == null ? null : builder.query.getBuilder().build();
            this.expirationTime = builder.expirationTime;
            this.expirationTimeInterval = builder.expirationTimeInterval;
            this.pushTime = builder.pushTime;
            this.pushToIOS = builder.pushToIOS;
            this.pushToAndroid = builder.pushToAndroid;
            JSONObject copyData = null;
            try {
                copyData = new JSONObject(builder.data.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.data = copyData;
        }

        public Set<String> channelSet() {
            return this.channelSet;
        }

        public ParseQuery.State<ParseInstallation> queryState() {
            return this.queryState;
        }

        public Long expirationTime() {
            return this.expirationTime;
        }

        public Long expirationTimeInterval() {
            return this.expirationTimeInterval;
        }

        public Long pushTime() {
            return this.pushTime;
        }

        public Boolean pushToIOS() {
            return this.pushToIOS;
        }

        public Boolean pushToAndroid() {
            return this.pushToAndroid;
        }

        public JSONObject data() {
            JSONObject copyData = null;
            try {
                copyData = new JSONObject(this.data.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return copyData;
        }

        static class Builder {
            private Set<String> channelSet;
            private ParseQuery<ParseInstallation> query;
            private Long expirationTime;
            private Long expirationTimeInterval;
            private Long pushTime;
            private Boolean pushToIOS;
            private Boolean pushToAndroid;
            private JSONObject data;

            public Builder() {
            }

            public Builder(State state) {
                this.channelSet = state.channelSet() == null ? null : Collections.unmodifiableSet(new HashSet<String>(state.channelSet()));
                this.query = state.queryState() == null ? null : new ParseQuery(new ParseQuery.State.Builder(state.queryState()));
                this.expirationTime = state.expirationTime();
                this.expirationTimeInterval = state.expirationTimeInterval();
                this.pushTime = state.pushTime();
                this.pushToIOS = state.pushToIOS();
                this.pushToAndroid = state.pushToAndroid();
                JSONObject copyData = null;
                try {
                    copyData = new JSONObject(state.data().toString());
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                this.data = copyData;
            }

            public Builder expirationTime(Long expirationTime) {
                this.expirationTime = expirationTime;
                this.expirationTimeInterval = null;
                return this;
            }

            public Builder expirationTimeInterval(Long expirationTimeInterval) {
                this.expirationTimeInterval = expirationTimeInterval;
                this.expirationTime = null;
                return this;
            }

            public Builder pushTime(Long pushTime) {
                if (pushTime != null) {
                    long now = System.currentTimeMillis() / 1000L;
                    long twoWeeks = 1209600L;
                    ParsePush.checkArgument(pushTime > now, "Scheduled push time can not be in the past");
                    ParsePush.checkArgument(pushTime < now + twoWeeks, "Scheduled push time can not be more than two weeks in the future");
                }
                this.pushTime = pushTime;
                return this;
            }

            public Builder pushToIOS(Boolean pushToIOS) {
                ParsePush.checkArgument(this.query == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
                this.pushToIOS = pushToIOS;
                return this;
            }

            public Builder pushToAndroid(Boolean pushToAndroid) {
                ParsePush.checkArgument(this.query == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
                this.pushToAndroid = pushToAndroid;
                return this;
            }

            public Builder data(JSONObject data) {
                this.data = data;
                return this;
            }

            public Builder channelSet(Collection<String> channelSet) {
                ParsePush.checkArgument(channelSet != null, "channels collection cannot be null");
                for (String channel : channelSet) {
                    ParsePush.checkArgument(channel != null, "channel cannot be null");
                }
                this.channelSet = new HashSet<String>(channelSet);
                this.query = null;
                return this;
            }

            public Builder query(ParseQuery<ParseInstallation> query) {
                ParsePush.checkArgument(query != null, "Cannot target a null query");
                ParsePush.checkArgument(this.pushToIOS == null && this.pushToAndroid == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
                ParsePush.checkArgument(query.getClassName().equals(ParsePush.getSubclassingController().getClassName(ParseInstallation.class)), "Can only push to a query for Installations");
                this.channelSet = null;
                this.query = query;
                return this;
            }

            public State build() {
                if (this.data == null) {
                    throw new IllegalArgumentException("Cannot send a push without calling either setMessage or setData");
                }
                return new State(this);
            }
        }
    }
}

