/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.parse.InstallationId;
import com.parse.ManifestInfo;
import com.parse.Parse;
import com.parse.ParseHttpClient;
import java.io.File;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

class ParsePlugins {
    private static final String INSTALLATION_ID_LOCATION = "installationId";
    private static final Object LOCK = new Object();
    private static ParsePlugins instance;
    final Object lock = new Object();
    private final Parse.Configuration configuration;
    private InstallationId installationId;
    File parseDir;
    File cacheDir;
    File filesDir;
    ParseHttpClient restClient;
    ParseHttpClient fileClient;

    static void initialize(Parse.Configuration configuration) {
        ParsePlugins.set(new ParsePlugins(configuration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void set(ParsePlugins plugins) {
        Object object = LOCK;
        synchronized (object) {
            if (instance != null) {
                throw new IllegalStateException("ParsePlugins is already initialized");
            }
            instance = plugins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParsePlugins get() {
        Object object = LOCK;
        synchronized (object) {
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        Object object = LOCK;
        synchronized (object) {
            instance = null;
        }
    }

    private ParsePlugins(Parse.Configuration configuration) {
        this.configuration = configuration;
    }

    String applicationId() {
        return this.configuration.applicationId;
    }

    String clientKey() {
        return this.configuration.clientKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParseHttpClient fileClient() {
        Object object = this.lock;
        synchronized (object) {
            if (this.fileClient == null) {
                this.fileClient = ParseHttpClient.createClient(this.configuration.clientBuilder);
            }
            return this.fileClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParseHttpClient restClient() {
        Object object = this.lock;
        synchronized (object) {
            if (this.restClient == null) {
                OkHttpClient.Builder clientBuilder = this.configuration.clientBuilder;
                if (clientBuilder == null) {
                    clientBuilder = new OkHttpClient.Builder();
                }
                clientBuilder.interceptors().add(0, new Interceptor(){

                    public Response intercept(Interceptor.Chain chain) throws IOException {
                        Request request = chain.request();
                        Headers.Builder headersBuilder = request.headers().newBuilder().set("X-Parse-Application-Id", ((ParsePlugins)ParsePlugins.this).configuration.applicationId).set("X-Parse-Client-Version", Parse.externalVersionName()).set("X-Parse-App-Build-Version", String.valueOf(ManifestInfo.getVersionCode())).set("X-Parse-App-Display-Version", ManifestInfo.getVersionName()).set("X-Parse-OS-Version", Build.VERSION.RELEASE).set("User-Agent", ParsePlugins.this.userAgent());
                        if (request.header("X-Parse-Installation-Id") == null) {
                            headersBuilder.set("X-Parse-Installation-Id", ParsePlugins.this.installationId().get());
                        }
                        if (((ParsePlugins)ParsePlugins.this).configuration.clientKey != null) {
                            headersBuilder.set("X-Parse-Client-Key", ((ParsePlugins)ParsePlugins.this).configuration.clientKey);
                        }
                        request = request.newBuilder().headers(headersBuilder.build()).build();
                        return chain.proceed(request);
                    }
                });
                this.restClient = ParseHttpClient.createClient(clientBuilder);
            }
            return this.restClient;
        }
    }

    String userAgent() {
        return "Parse Java SDK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstallationId installationId() {
        Object object = this.lock;
        synchronized (object) {
            if (this.installationId == null) {
                this.installationId = new InstallationId(new File(this.getParseDir(), INSTALLATION_ID_LOCATION));
            }
            return this.installationId;
        }
    }

    @Deprecated
    File getParseDir() {
        throw new IllegalStateException("Stub");
    }

    File getCacheDir() {
        throw new IllegalStateException("Stub");
    }

    File getFilesDir() {
        throw new IllegalStateException("Stub");
    }

    private static File createFileDir(File file) {
        if (!file.exists() && !file.mkdirs()) {
            return file;
        }
        return file;
    }

    static class Android
    extends ParsePlugins {
        private final Context applicationContext;

        static void initialize(Context context, Parse.Configuration configuration) {
            ParsePlugins.set(new Android(context, configuration));
        }

        static Android get() {
            return (Android)ParsePlugins.get();
        }

        private Android(Context context, Parse.Configuration configuration) {
            super(configuration);
            this.applicationContext = context.getApplicationContext();
        }

        Context applicationContext() {
            return this.applicationContext;
        }

        @Override
        String userAgent() {
            String packageVersion = "unknown";
            try {
                String packageName = this.applicationContext.getPackageName();
                int versionCode = this.applicationContext.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
                packageVersion = packageName + "/" + versionCode;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            return "Parse Android SDK 1.15.8 (" + packageVersion + ") API Level " + Build.VERSION.SDK_INT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        File getParseDir() {
            Object object = this.lock;
            synchronized (object) {
                if (this.parseDir == null) {
                    this.parseDir = this.applicationContext.getDir("Parse", 0);
                }
                return ParsePlugins.createFileDir(this.parseDir);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        File getCacheDir() {
            Object object = this.lock;
            synchronized (object) {
                if (this.cacheDir == null) {
                    this.cacheDir = new File(this.applicationContext.getCacheDir(), "com.parse");
                }
                return ParsePlugins.createFileDir(this.cacheDir);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        File getFilesDir() {
            Object object = this.lock;
            synchronized (object) {
                if (this.filesDir == null) {
                    this.filesDir = new File(this.applicationContext.getFilesDir(), "com.parse");
                }
                return ParsePlugins.createFileDir(this.filesDir);
            }
        }
    }
}

