/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import bolts.Continuation;
import bolts.Task;
import com.parse.InstallationId;
import com.parse.PLog;
import com.parse.Parse;
import com.parse.ParseClassName;
import com.parse.ParseCorePlugins;
import com.parse.ParseCurrentInstallationController;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseOperationSet;
import com.parse.ParsePlugins;
import com.parse.ParseQuery;
import com.parse.ParseTaskUtils;
import com.parse.PushType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

@ParseClassName(value="_Installation")
public class ParseInstallation
extends ParseObject {
    private static final String TAG = "com.parse.ParseInstallation";
    private static final String KEY_OBJECT_ID = "objectId";
    private static final String KEY_INSTALLATION_ID = "installationId";
    private static final String KEY_DEVICE_TYPE = "deviceType";
    private static final String KEY_APP_NAME = "appName";
    private static final String KEY_APP_IDENTIFIER = "appIdentifier";
    private static final String KEY_PARSE_VERSION = "parseVersion";
    private static final String KEY_DEVICE_TOKEN = "deviceToken";
    private static final String KEY_PUSH_TYPE = "pushType";
    private static final String KEY_TIME_ZONE = "timeZone";
    private static final String KEY_LOCALE = "localeIdentifier";
    private static final String KEY_APP_VERSION = "appVersion";
    static final String KEY_CHANNELS = "channels";
    private static final List<String> READ_ONLY_FIELDS = Collections.unmodifiableList(Arrays.asList("deviceType", "installationId", "deviceToken", "pushType", "timeZone", "localeIdentifier", "appVersion", "appName", "parseVersion", "appIdentifier", "objectId"));

    static ParseCurrentInstallationController getCurrentInstallationController() {
        return ParseCorePlugins.getInstance().getCurrentInstallationController();
    }

    public static ParseInstallation getCurrentInstallation() {
        try {
            return (ParseInstallation)ParseTaskUtils.wait(ParseInstallation.getCurrentInstallationController().getAsync());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static ParseQuery<ParseInstallation> getQuery() {
        return ParseQuery.getQuery(ParseInstallation.class);
    }

    public String getInstallationId() {
        return this.getString(KEY_INSTALLATION_ID);
    }

    @Override
    public void setObjectId(String newObjectId) {
        throw new RuntimeException("Installation's objectId cannot be changed");
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }

    @Override
    boolean isKeyMutable(String key) {
        return !READ_ONLY_FIELDS.contains(key);
    }

    @Override
    void updateBeforeSave() {
        super.updateBeforeSave();
        if (ParseInstallation.getCurrentInstallationController().isCurrent(this)) {
            this.updateTimezone();
            this.updateVersionInfo();
            this.updateDeviceInfo();
            this.updateLocaleIdentifier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends ParseObject> Task<T> fetchAsync(final String sessionToken, final Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            Task<Void> result = this.getObjectId() == null ? this.saveAsync(sessionToken, toAwait) : Task.forResult(null);
            return result.onSuccessTask(new Continuation<Void, Task<T>>(){

                public Task<T> then(Task<Void> task) throws Exception {
                    return ParseInstallation.access$001(ParseInstallation.this, sessionToken, toAwait);
                }
            });
        }
    }

    @Override
    Task<Void> saveAsync(final String sessionToken, final Task<Void> toAwait) {
        return super.saveAsync(sessionToken, toAwait).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<Void> then(Task<Void> task) throws Exception {
                int errCode;
                if (task.getError() != null && task.getError() instanceof ParseException && ((errCode = ((ParseException)task.getError()).getCode()) == 101 || errCode == 135 && ParseInstallation.this.getObjectId() == null)) {
                    Object object = ParseInstallation.this.mutex;
                    synchronized (object) {
                        ParseInstallation.this.setState(((ParseObject.State.Builder)new ParseObject.State.Builder(ParseInstallation.this.getState()).objectId(null)).build());
                        ParseInstallation.this.markAllFieldsDirty();
                        return ParseInstallation.access$101(ParseInstallation.this, sessionToken, toAwait);
                    }
                }
                return task;
            }
        });
    }

    @Override
    Task<Void> handleSaveResultAsync(ParseObject.State result, ParseOperationSet operationsBeforeSave) {
        Task<Void> task = super.handleSaveResultAsync(result, operationsBeforeSave);
        if (result == null) {
            return task;
        }
        return task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseInstallation.getCurrentInstallationController().setAsync(ParseInstallation.this);
            }
        });
    }

    @Override
    Task<Void> handleFetchResultAsync(ParseObject.State newState) {
        return super.handleFetchResultAsync(newState).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseInstallation.getCurrentInstallationController().setAsync(ParseInstallation.this);
            }
        });
    }

    private void updateTimezone() {
        String zone = TimeZone.getDefault().getID();
        if ((zone.indexOf(47) > 0 || zone.equals("GMT")) && !zone.equals(this.get(KEY_TIME_ZONE))) {
            this.performPut(KEY_TIME_ZONE, zone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersionInfo() {
        Object object = this.mutex;
        synchronized (object) {
            try {
                Context context = Parse.getApplicationContext();
                String packageName = context.getPackageName();
                PackageManager pm = context.getPackageManager();
                PackageInfo pkgInfo = pm.getPackageInfo(packageName, 0);
                String appVersion = pkgInfo.versionName;
                String appName = pm.getApplicationLabel(pm.getApplicationInfo(packageName, 0)).toString();
                if (packageName != null && !packageName.equals(this.get(KEY_APP_IDENTIFIER))) {
                    this.performPut(KEY_APP_IDENTIFIER, packageName);
                }
                if (appName != null && !appName.equals(this.get(KEY_APP_NAME))) {
                    this.performPut(KEY_APP_NAME, appName);
                }
                if (appVersion != null && !appVersion.equals(this.get(KEY_APP_VERSION))) {
                    this.performPut(KEY_APP_VERSION, appVersion);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                PLog.w(TAG, "Cannot load package info; will not be saved to installation");
            }
            if (!"1.15.8".equals(this.get(KEY_PARSE_VERSION))) {
                this.performPut(KEY_PARSE_VERSION, "1.15.8");
            }
        }
    }

    private void updateLocaleIdentifier() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (TextUtils.isEmpty((CharSequence)language)) {
            return;
        }
        if (language.equals("iw")) {
            language = "he";
        }
        if (language.equals("in")) {
            language = "id";
        }
        if (language.equals("ji")) {
            language = "yi";
        }
        String localeString = language;
        if (!TextUtils.isEmpty((CharSequence)country)) {
            localeString = String.format(Locale.US, "%s-%s", language, country);
        }
        if (!localeString.equals(this.get(KEY_LOCALE))) {
            this.performPut(KEY_LOCALE, localeString);
        }
    }

    void updateDeviceInfo() {
        this.updateDeviceInfo(ParsePlugins.get().installationId());
    }

    void updateDeviceInfo(InstallationId installationId) {
        String deviceType;
        if (!this.has(KEY_INSTALLATION_ID)) {
            this.performPut(KEY_INSTALLATION_ID, installationId.get());
        }
        if (!(deviceType = "android").equals(this.get(KEY_DEVICE_TYPE))) {
            this.performPut(KEY_DEVICE_TYPE, deviceType);
        }
    }

    PushType getPushType() {
        return PushType.fromString(super.getString(KEY_PUSH_TYPE));
    }

    void setPushType(PushType pushType) {
        if (pushType != null) {
            this.performPut(KEY_PUSH_TYPE, pushType.toString());
        }
    }

    void removePushType() {
        this.performRemove(KEY_PUSH_TYPE);
    }

    String getDeviceToken() {
        return super.getString(KEY_DEVICE_TOKEN);
    }

    void setDeviceToken(String deviceToken) {
        if (deviceToken != null && deviceToken.length() > 0) {
            this.performPut(KEY_DEVICE_TOKEN, deviceToken);
        }
    }

    void removeDeviceToken() {
        this.performRemove(KEY_DEVICE_TOKEN);
    }

    static /* synthetic */ Task access$001(ParseInstallation x0, String x1, Task x2) {
        return super.fetchAsync(x1, (Task<Void>)x2);
    }

    static /* synthetic */ Task access$101(ParseInstallation x0, String x1, Task x2) {
        return super.saveAsync(x1, (Task<Void>)x2);
    }
}

