/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.util.Base64;
import com.parse.ParseACL;
import com.parse.ParseDateFormat;
import com.parse.ParseFieldOperation;
import com.parse.ParseFile;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseRelation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class ParseEncoder {
    ParseEncoder() {
    }

    static boolean isValidType(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Date || value instanceof List || value instanceof Map || value instanceof byte[] || value == JSONObject.NULL || value instanceof ParseObject || value instanceof ParseACL || value instanceof ParseFile || value instanceof ParseGeoPoint || value instanceof ParseRelation;
    }

    public Object encode(Object object) {
        try {
            if (object instanceof ParseObject) {
                return this.encodeRelatedObject((ParseObject)object);
            }
            if (object instanceof ParseQuery.State.Builder) {
                ParseQuery.State.Builder builder = (ParseQuery.State.Builder)object;
                return this.encode(builder.build());
            }
            if (object instanceof ParseQuery.State) {
                ParseQuery.State state = (ParseQuery.State)object;
                return state.toJSON(this);
            }
            if (object instanceof Date) {
                return this.encodeDate((Date)object);
            }
            if (object instanceof byte[]) {
                JSONObject json = new JSONObject();
                json.put("__type", (Object)"Bytes");
                json.put("base64", (Object)Base64.encodeToString((byte[])((byte[])object), (int)2));
                return json;
            }
            if (object instanceof ParseFile) {
                return ((ParseFile)object).encode();
            }
            if (object instanceof ParseGeoPoint) {
                ParseGeoPoint point = (ParseGeoPoint)object;
                JSONObject json = new JSONObject();
                json.put("__type", (Object)"GeoPoint");
                json.put("latitude", point.getLatitude());
                json.put("longitude", point.getLongitude());
                return json;
            }
            if (object instanceof ParseACL) {
                ParseACL acl = (ParseACL)object;
                return acl.toJSONObject(this);
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONObject json = new JSONObject();
                for (Map.Entry pair : map.entrySet()) {
                    json.put((String)pair.getKey(), this.encode(pair.getValue()));
                }
                return json;
            }
            if (object instanceof Collection) {
                JSONArray array = new JSONArray();
                for (Object item : (Collection)object) {
                    array.put(this.encode(item));
                }
                return array;
            }
            if (object instanceof ParseRelation) {
                ParseRelation relation = (ParseRelation)object;
                return relation.encodeToJSON(this);
            }
            if (object instanceof ParseFieldOperation) {
                return ((ParseFieldOperation)object).encode(this);
            }
            if (object instanceof ParseQuery.RelationConstraint) {
                return ((ParseQuery.RelationConstraint)object).encode(this);
            }
            if (object == null) {
                return JSONObject.NULL;
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        if (ParseEncoder.isValidType(object)) {
            return object;
        }
        throw new IllegalArgumentException("invalid type for ParseObject: " + object.getClass().toString());
    }

    protected abstract JSONObject encodeRelatedObject(ParseObject var1);

    protected JSONObject encodeDate(Date date) {
        JSONObject object = new JSONObject();
        String iso = ParseDateFormat.getInstance().format(date);
        try {
            object.put("__type", (Object)"Date");
            object.put("iso", (Object)iso);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return object;
    }
}

