/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import bolts.Continuation;
import bolts.Task;
import com.parse.GcmRegistrar;
import com.parse.ManifestInfo;
import com.parse.OfflineStore;
import com.parse.PLog;
import com.parse.ParseCommandCache;
import com.parse.ParseConfig;
import com.parse.ParseCorePlugins;
import com.parse.ParseEventuallyQueue;
import com.parse.ParseFieldOperations;
import com.parse.ParseFileUtils;
import com.parse.ParseHttpClient;
import com.parse.ParseKeyValueCache;
import com.parse.ParseObject;
import com.parse.ParsePinningEventuallyQueue;
import com.parse.ParsePlugins;
import com.parse.ParseRESTCommand;
import com.parse.ParseUser;
import com.parse.PushService;
import com.parse.PushType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import okhttp3.OkHttpClient;

public class Parse {
    private static final String TAG = "com.parse.Parse";
    private static final String PARSE_SERVER_URL = "com.parse.SERVER_URL";
    private static final String PARSE_APPLICATION_ID = "com.parse.APPLICATION_ID";
    private static final String PARSE_CLIENT_KEY = "com.parse.CLIENT_KEY";
    private static final Object MUTEX = new Object();
    static ParseEventuallyQueue eventuallyQueue = null;
    private static boolean isLocalDatastoreEnabled;
    private static OfflineStore offlineStore;
    private static final Object MUTEX_CALLBACKS;
    private static Set<ParseCallbacks> callbacks;
    public static final int LOG_LEVEL_VERBOSE = 2;
    public static final int LOG_LEVEL_DEBUG = 3;
    public static final int LOG_LEVEL_INFO = 4;
    public static final int LOG_LEVEL_WARNING = 5;
    public static final int LOG_LEVEL_ERROR = 6;
    public static final int LOG_LEVEL_NONE = Integer.MAX_VALUE;

    public static void enableLocalDatastore(Context context) {
        if (Parse.isInitialized()) {
            throw new IllegalStateException("`Parse#enableLocalDatastore(Context)` must be invoked before `Parse#initialize(Context)`");
        }
        isLocalDatastoreEnabled = true;
    }

    static void disableLocalDatastore() {
        Parse.setLocalDatastore(null);
        ParseCorePlugins.getInstance().reset();
    }

    static OfflineStore getLocalDatastore() {
        return offlineStore;
    }

    static void setLocalDatastore(OfflineStore offlineStore) {
        isLocalDatastoreEnabled = offlineStore != null;
        Parse.offlineStore = offlineStore;
    }

    public static boolean isLocalDatastoreEnabled() {
        return isLocalDatastoreEnabled;
    }

    public static void initialize(Context context) {
        Configuration.Builder builder = new Configuration.Builder(context);
        if (builder.server == null) {
            throw new RuntimeException("ServerUrl not defined. You must provide ServerUrl in AndroidManifest.xml.\n<meta-data\n    android:name=\"com.parse.SERVER_URL\"\n    android:value=\"<Your Server Url>\" />");
        }
        if (builder.applicationId == null) {
            throw new RuntimeException("ApplicationId not defined. You must provide ApplicationId in AndroidManifest.xml.\n<meta-data\n    android:name=\"com.parse.APPLICATION_ID\"\n    android:value=\"<Your Application Id>\" />");
        }
        Parse.initialize(builder.setLocalDatastoreEnabled(Parse.isLocalDatastoreEnabled).build());
    }

    public static void initialize(Context context, String applicationId, String clientKey) {
        Parse.initialize(new Configuration.Builder(context).applicationId(applicationId).clientKey(clientKey).setLocalDatastoreEnabled(Parse.isLocalDatastoreEnabled).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Configuration configuration) {
        if (Parse.isInitialized()) {
            PLog.w(TAG, "Parse is already initialized");
            return;
        }
        isLocalDatastoreEnabled = configuration.localDataStoreEnabled;
        ParsePlugins.Android.initialize(configuration.context, configuration);
        try {
            ParseRESTCommand.server = new URL(configuration.server);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        Context applicationContext = configuration.context.getApplicationContext();
        ParseHttpClient.setKeepAlive(true);
        ParseHttpClient.setMaxConnections(20);
        ParseObject.registerParseSubclasses();
        if (configuration.localDataStoreEnabled) {
            offlineStore = new OfflineStore(configuration.context);
        } else {
            ParseKeyValueCache.initialize(configuration.context);
        }
        Parse.checkCacheApplicationId();
        final Context context = configuration.context;
        Task.callInBackground((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Parse.getEventuallyQueue(context);
                return null;
            }
        });
        ParseFieldOperations.registerDefaultDecoders();
        if (!Parse.allParsePushIntentReceiversInternal()) {
            throw new SecurityException("To prevent external tampering to your app's notifications, all receivers registered to handle the following actions must have their exported attributes set to false: com.parse.push.intent.RECEIVE, com.parse.push.intent.OPEN, com.parse.push.intent.DELETE");
        }
        GcmRegistrar.getInstance().registerAsync().continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ParseUser.getCurrentUserAsync().makeVoid();
            }
        }).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                ParseConfig.getCurrentConfig();
                return null;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
        if (ManifestInfo.getPushType() == PushType.PPNS) {
            PushService.startServiceIfRequired(applicationContext);
        }
        Parse.dispatchOnParseInitialized();
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            callbacks = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroy() {
        ParseEventuallyQueue queue;
        Object object = MUTEX;
        synchronized (object) {
            queue = eventuallyQueue;
            eventuallyQueue = null;
        }
        if (queue != null) {
            queue.onDestroy();
        }
        ParseCorePlugins.getInstance().reset();
        ParsePlugins.reset();
    }

    static boolean isInitialized() {
        return ParsePlugins.get() != null;
    }

    static Context getApplicationContext() {
        Parse.checkContext();
        return ParsePlugins.Android.get().applicationContext();
    }

    private static boolean allParsePushIntentReceiversInternal() {
        List<ResolveInfo> intentReceivers = ManifestInfo.getIntentReceivers("com.parse.push.intent.RECEIVE", "com.parse.push.intent.DELETE", "com.parse.push.intent.OPEN");
        for (ResolveInfo resolveInfo : intentReceivers) {
            if (!resolveInfo.activityInfo.exported) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    static File getParseDir() {
        return ParsePlugins.get().getParseDir();
    }

    static File getParseCacheDir() {
        return ParsePlugins.get().getCacheDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getParseCacheDir(String subDir) {
        Object object = MUTEX;
        synchronized (object) {
            File dir = new File(Parse.getParseCacheDir(), subDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
    }

    static File getParseFilesDir() {
        return ParsePlugins.get().getFilesDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getParseFilesDir(String subDir) {
        Object object = MUTEX;
        synchronized (object) {
            File dir = new File(Parse.getParseFilesDir(), subDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkCacheApplicationId() {
        Object object = MUTEX;
        synchronized (object) {
            String applicationId = ParsePlugins.get().applicationId();
            if (applicationId != null) {
                File dir = Parse.getParseCacheDir();
                File applicationIdFile = new File(dir, "applicationId");
                if (applicationIdFile.exists()) {
                    boolean matches = false;
                    try {
                        RandomAccessFile f = new RandomAccessFile(applicationIdFile, "r");
                        byte[] bytes = new byte[(int)f.length()];
                        f.readFully(bytes);
                        f.close();
                        String diskApplicationId = new String(bytes, "UTF-8");
                        matches = diskApplicationId.equals(applicationId);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (!matches) {
                        try {
                            ParseFileUtils.deleteDirectory(dir);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                applicationIdFile = new File(dir, "applicationId");
                try {
                    FileOutputStream out = new FileOutputStream(applicationIdFile);
                    out.write(applicationId.getBytes("UTF-8"));
                    out.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    static ParseEventuallyQueue getEventuallyQueue() {
        Context context = ParsePlugins.Android.get().applicationContext();
        return Parse.getEventuallyQueue(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseEventuallyQueue getEventuallyQueue(Context context) {
        Object object = MUTEX;
        synchronized (object) {
            boolean isLocalDatastoreEnabled = Parse.isLocalDatastoreEnabled();
            if (eventuallyQueue == null || isLocalDatastoreEnabled && eventuallyQueue instanceof ParseCommandCache || !isLocalDatastoreEnabled && eventuallyQueue instanceof ParsePinningEventuallyQueue) {
                Parse.checkContext();
                ParseHttpClient httpClient = ParsePlugins.get().restClient();
                ParseEventuallyQueue parseEventuallyQueue = eventuallyQueue = isLocalDatastoreEnabled ? new ParsePinningEventuallyQueue(context, httpClient) : new ParseCommandCache(context, httpClient);
                if (isLocalDatastoreEnabled && ParseCommandCache.getPendingCount() > 0) {
                    new ParseCommandCache(context, httpClient);
                }
            }
            return eventuallyQueue;
        }
    }

    static void checkInit() {
        if (ParsePlugins.get() == null) {
            throw new RuntimeException("You must call Parse.initialize(Context) before using the Parse library.");
        }
        if (ParsePlugins.get().applicationId() == null) {
            throw new RuntimeException("applicationId is null. You must call Parse.initialize(Context) before using the Parse library.");
        }
    }

    static void checkContext() {
        if (ParsePlugins.Android.get().applicationContext() == null) {
            throw new RuntimeException("applicationContext is null. You must call Parse.initialize(Context) before using the Parse library.");
        }
    }

    static boolean hasPermission(String permission2) {
        return Parse.getApplicationContext().checkCallingOrSelfPermission(permission2) == 0;
    }

    static void requirePermission(String permission2) {
        if (!Parse.hasPermission(permission2)) {
            throw new IllegalStateException("To use this functionality, add this to your AndroidManifest.xml:\n<uses-permission android:name=\"" + permission2 + "\" />");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerParseCallbacks(ParseCallbacks listener) {
        if (Parse.isInitialized()) {
            throw new IllegalStateException("You must register callbacks before Parse.initialize(Context)");
        }
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            if (callbacks == null) {
                return;
            }
            callbacks.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterParseCallbacks(ParseCallbacks listener) {
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            if (callbacks == null) {
                return;
            }
            callbacks.remove(listener);
        }
    }

    private static void dispatchOnParseInitialized() {
        ParseCallbacks[] callbacks = Parse.collectParseCallbacks();
        if (callbacks != null) {
            for (ParseCallbacks callback : callbacks) {
                callback.onParseInitialized();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseCallbacks[] collectParseCallbacks() {
        ParseCallbacks[] callbacks;
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            if (Parse.callbacks == null) {
                return null;
            }
            callbacks = new ParseCallbacks[Parse.callbacks.size()];
            if (Parse.callbacks.size() > 0) {
                callbacks = Parse.callbacks.toArray(callbacks);
            }
        }
        return callbacks;
    }

    public static void setLogLevel(int logLevel) {
        PLog.setLogLevel(logLevel);
    }

    public static int getLogLevel() {
        return PLog.getLogLevel();
    }

    private Parse() {
        throw new AssertionError();
    }

    static String externalVersionName() {
        return "a1.15.8";
    }

    static {
        MUTEX_CALLBACKS = new Object();
        callbacks = new HashSet<ParseCallbacks>();
    }

    static interface ParseCallbacks {
        public void onParseInitialized();
    }

    public static final class Configuration {
        final Context context;
        final String applicationId;
        final String clientKey;
        final String server;
        final boolean localDataStoreEnabled;
        final OkHttpClient.Builder clientBuilder;

        private Configuration(Builder builder) {
            this.context = builder.context;
            this.applicationId = builder.applicationId;
            this.clientKey = builder.clientKey;
            this.server = builder.server;
            this.localDataStoreEnabled = builder.localDataStoreEnabled;
            this.clientBuilder = builder.clientBuilder;
        }

        public static final class Builder {
            private Context context;
            private String applicationId;
            private String clientKey;
            private String server;
            private boolean localDataStoreEnabled;
            private OkHttpClient.Builder clientBuilder;

            public Builder(Context context) {
                Context applicationContext;
                Bundle metaData;
                this.context = context;
                if (context != null && (metaData = ManifestInfo.getApplicationMetadata(applicationContext = context.getApplicationContext())) != null) {
                    this.server(metaData.getString(Parse.PARSE_SERVER_URL));
                    this.applicationId = metaData.getString(Parse.PARSE_APPLICATION_ID);
                    this.clientKey = metaData.getString(Parse.PARSE_CLIENT_KEY);
                }
            }

            public Builder applicationId(String applicationId) {
                this.applicationId = applicationId;
                return this;
            }

            public Builder clientKey(String clientKey) {
                this.clientKey = clientKey;
                return this;
            }

            public Builder server(String server) {
                if (server != null && !server.endsWith("/")) {
                    server = server + "/";
                }
                this.server = server;
                return this;
            }

            public Builder enableLocalDataStore() {
                this.localDataStoreEnabled = true;
                return this;
            }

            private Builder setLocalDatastoreEnabled(boolean enabled) {
                this.localDataStoreEnabled = enabled;
                return this;
            }

            public Builder clientBuilder(OkHttpClient.Builder builder) {
                this.clientBuilder = builder;
                return this;
            }

            public Configuration build() {
                return new Configuration(this);
            }
        }
    }
}

