/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.AbstractQueryController;
import com.parse.PLog;
import com.parse.ParseDecoder;
import com.parse.ParseHttpClient;
import com.parse.ParseKeyValueCache;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseRESTQueryCommand;
import com.parse.ParseUser;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class NetworkQueryController
extends AbstractQueryController {
    private static final String TAG = "NetworkQueryController";
    private final ParseHttpClient restClient;

    public NetworkQueryController(ParseHttpClient restClient) {
        this.restClient = restClient;
    }

    @Override
    public <T extends ParseObject> Task<List<T>> findAsync(ParseQuery.State<T> state, ParseUser user, Task<Void> cancellationToken) {
        String sessionToken = user != null ? user.getSessionToken() : null;
        return this.findAsync(state, sessionToken, true, cancellationToken);
    }

    @Override
    public <T extends ParseObject> Task<Integer> countAsync(ParseQuery.State<T> state, ParseUser user, Task<Void> cancellationToken) {
        String sessionToken = user != null ? user.getSessionToken() : null;
        return this.countAsync(state, sessionToken, true, cancellationToken);
    }

    <T extends ParseObject> Task<List<T>> findAsync(final ParseQuery.State<T> state, String sessionToken, boolean shouldRetry, Task<Void> ct) {
        final long queryStart = System.nanoTime();
        final ParseRESTQueryCommand command = ParseRESTQueryCommand.findCommand(state, sessionToken);
        if (shouldRetry) {
            command.enableRetrying();
        }
        final long querySent = System.nanoTime();
        return command.executeAsync(this.restClient, ct).onSuccess(new Continuation<JSONObject, List<T>>(){

            public List<T> then(Task<JSONObject> task) throws Exception {
                JSONObject json = (JSONObject)task.getResult();
                ParseQuery.CachePolicy policy = state.cachePolicy();
                if (policy != null && policy != ParseQuery.CachePolicy.IGNORE_CACHE) {
                    ParseKeyValueCache.saveToKeyValueCache(command.getCacheKey(), json.toString());
                }
                long queryReceived = System.nanoTime();
                List response = NetworkQueryController.this.convertFindResponse(state, (JSONObject)task.getResult());
                long objectsParsed = System.nanoTime();
                if (json.has("trace")) {
                    Object serverTrace = json.get("trace");
                    PLog.d("ParseQuery", String.format("Query pre-processing took %f seconds\n%s\nClient side parsing took %f seconds\n", Float.valueOf((float)(querySent - queryStart) / 1000000.0f), serverTrace, Float.valueOf((float)(objectsParsed - queryReceived) / 1000000.0f)));
                }
                return response;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    <T extends ParseObject> Task<Integer> countAsync(final ParseQuery.State<T> state, String sessionToken, boolean shouldRetry, Task<Void> ct) {
        final ParseRESTQueryCommand command = ParseRESTQueryCommand.countCommand(state, sessionToken);
        if (shouldRetry) {
            command.enableRetrying();
        }
        return command.executeAsync(this.restClient, ct).onSuccessTask((Continuation)new Continuation<JSONObject, Task<JSONObject>>(){

            public Task<JSONObject> then(Task<JSONObject> task) throws Exception {
                ParseQuery.CachePolicy policy = state.cachePolicy();
                if (policy != null && policy != ParseQuery.CachePolicy.IGNORE_CACHE) {
                    JSONObject result = (JSONObject)task.getResult();
                    ParseKeyValueCache.saveToKeyValueCache(command.getCacheKey(), result.toString());
                }
                return task;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR).onSuccess((Continuation)new Continuation<JSONObject, Integer>(){

            public Integer then(Task<JSONObject> task) throws Exception {
                return ((JSONObject)task.getResult()).optInt("count");
            }
        });
    }

    <T extends ParseObject> List<T> convertFindResponse(ParseQuery.State<T> state, JSONObject response) throws JSONException {
        ArrayList answer = new ArrayList();
        JSONArray results = response.getJSONArray("results");
        if (results == null) {
            PLog.d(TAG, "null results in find response");
        } else {
            String resultClassName = response.optString("className", null);
            if (resultClassName == null) {
                resultClassName = state.className();
            }
            for (int i = 0; i < results.length(); ++i) {
                JSONObject data = results.getJSONObject(i);
                Object object = ParseObject.fromJSON(data, resultClassName, ParseDecoder.get(), state.selectedKeys());
                answer.add(object);
                ParseQuery.RelationConstraint relation = (ParseQuery.RelationConstraint)state.constraints().get("$relatedTo");
                if (relation == null) continue;
                relation.getRelation().addKnownObject((ParseObject)object);
            }
        }
        return answer;
    }
}

