/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ParseDecoder;
import com.parse.ParseHttpClient;
import com.parse.ParseObject;
import com.parse.ParseObjectCoder;
import com.parse.ParseObjectController;
import com.parse.ParseOperationSet;
import com.parse.ParseRESTObjectBatchCommand;
import com.parse.ParseRESTObjectCommand;
import com.parse.PointerEncoder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

class NetworkObjectController
implements ParseObjectController {
    private ParseHttpClient client;
    private ParseObjectCoder coder;

    public NetworkObjectController(ParseHttpClient client) {
        this.client = client;
        this.coder = ParseObjectCoder.get();
    }

    @Override
    public Task<ParseObject.State> fetchAsync(final ParseObject.State state, String sessionToken, final ParseDecoder decoder) {
        ParseRESTObjectCommand command = ParseRESTObjectCommand.getObjectCommand(state.objectId(), state.className(), sessionToken);
        command.enableRetrying();
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, ParseObject.State>(){

            public ParseObject.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                Object builder = ((ParseObject.State.Init)state.newBuilder()).clear();
                return ((ParseObject.State.Init)((ParseObject.State.Init)NetworkObjectController.this.coder.decode(builder, result, decoder)).isComplete(true)).build();
            }
        });
    }

    @Override
    public Task<ParseObject.State> saveAsync(final ParseObject.State state, ParseOperationSet operations, String sessionToken, final ParseDecoder decoder) {
        JSONObject objectJSON = this.coder.encode(state, operations, PointerEncoder.get());
        ParseRESTObjectCommand command = ParseRESTObjectCommand.saveObjectCommand(state, objectJSON, sessionToken);
        command.enableRetrying();
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, ParseObject.State>(){

            public ParseObject.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                Object builder = ((ParseObject.State.Init)state.newBuilder()).clear();
                return ((ParseObject.State.Init)((ParseObject.State.Init)NetworkObjectController.this.coder.decode(builder, result, decoder)).isComplete(false)).build();
            }
        });
    }

    @Override
    public List<Task<ParseObject.State>> saveAllAsync(List<ParseObject.State> states, List<ParseOperationSet> operationsList, String sessionToken, List<ParseDecoder> decoders) {
        int batchSize = states.size();
        ArrayList<ParseRESTObjectCommand> commands = new ArrayList<ParseRESTObjectCommand>(batchSize);
        PointerEncoder encoder = PointerEncoder.get();
        for (int i = 0; i < batchSize; ++i) {
            ParseObject.State state = states.get(i);
            ParseOperationSet operations = operationsList.get(i);
            JSONObject objectJSON = this.coder.encode(state, operations, encoder);
            ParseRESTObjectCommand command = ParseRESTObjectCommand.saveObjectCommand(state, objectJSON, sessionToken);
            commands.add(command);
        }
        List<Task<JSONObject>> batchTasks = ParseRESTObjectBatchCommand.executeBatch(this.client, commands, sessionToken);
        ArrayList<Task<ParseObject.State>> tasks = new ArrayList<Task<ParseObject.State>>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            final ParseObject.State state = states.get(i);
            final ParseDecoder decoder = decoders.get(i);
            tasks.add((Task<ParseObject.State>)batchTasks.get(i).onSuccess((Continuation)new Continuation<JSONObject, ParseObject.State>(){

                public ParseObject.State then(Task<JSONObject> task) throws Exception {
                    JSONObject result = (JSONObject)task.getResult();
                    Object builder = ((ParseObject.State.Init)state.newBuilder()).clear();
                    return ((ParseObject.State.Init)((ParseObject.State.Init)NetworkObjectController.this.coder.decode(builder, result, decoder)).isComplete(false)).build();
                }
            }));
        }
        return tasks;
    }

    @Override
    public Task<Void> deleteAsync(ParseObject.State state, String sessionToken) {
        ParseRESTObjectCommand command = ParseRESTObjectCommand.deleteObjectCommand(state, sessionToken);
        command.enableRetrying();
        return command.executeAsync(this.client).makeVoid();
    }

    @Override
    public List<Task<Void>> deleteAllAsync(List<ParseObject.State> states, String sessionToken) {
        int batchSize = states.size();
        ArrayList<ParseRESTObjectCommand> commands = new ArrayList<ParseRESTObjectCommand>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            ParseObject.State state = states.get(i);
            ParseRESTObjectCommand command = ParseRESTObjectCommand.deleteObjectCommand(state, sessionToken);
            command.enableRetrying();
            commands.add(command);
        }
        List<Task<JSONObject>> batchTasks = ParseRESTObjectBatchCommand.executeBatch(this.client, commands, sessionToken);
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            tasks.add((Task<Void>)batchTasks.get(i).makeVoid());
        }
        return tasks;
    }
}

