/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.InstallationId;
import com.parse.PLog;
import com.parse.ParseCurrentInstallationController;
import com.parse.ParseException;
import com.parse.ParseExecutors;
import com.parse.ParseInstallation;
import com.parse.ParseObject;
import com.parse.ParseObjectStore;
import com.parse.ParseTaskUtils;
import com.parse.TaskQueue;

class CachedCurrentInstallationController
implements ParseCurrentInstallationController {
    static final String TAG = "com.parse.CachedCurrentInstallationController";
    private final Object mutex = new Object();
    private final TaskQueue taskQueue = new TaskQueue();
    private final ParseObjectStore<ParseInstallation> store;
    private final InstallationId installationId;
    ParseInstallation currentInstallation;

    public CachedCurrentInstallationController(ParseObjectStore<ParseInstallation> store, InstallationId installationId) {
        this.store = store;
        this.installationId = installationId;
    }

    @Override
    public Task<Void> setAsync(final ParseInstallation installation) {
        if (!this.isCurrent(installation)) {
            return Task.forResult(null);
        }
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        return CachedCurrentInstallationController.this.store.setAsync(installation);
                    }
                }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        CachedCurrentInstallationController.this.installationId.set(installation.getInstallationId());
                        return task;
                    }
                }, ParseExecutors.io());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task<ParseInstallation> getAsync() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.currentInstallation != null) {
                return Task.forResult((Object)this.currentInstallation);
            }
        }
        return this.taskQueue.enqueue(new Continuation<Void, Task<ParseInstallation>>(){

            public Task<ParseInstallation> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<ParseInstallation>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Task<ParseInstallation> then(Task<Void> task) throws Exception {
                        Object object = CachedCurrentInstallationController.this.mutex;
                        synchronized (object) {
                            if (CachedCurrentInstallationController.this.currentInstallation != null) {
                                return Task.forResult((Object)CachedCurrentInstallationController.this.currentInstallation);
                            }
                        }
                        return CachedCurrentInstallationController.this.store.getAsync().continueWith((Continuation)new Continuation<ParseInstallation, ParseInstallation>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public ParseInstallation then(Task<ParseInstallation> task) throws Exception {
                                ParseInstallation current = (ParseInstallation)task.getResult();
                                if (current == null) {
                                    current = ParseObject.create(ParseInstallation.class);
                                    current.updateDeviceInfo(CachedCurrentInstallationController.this.installationId);
                                } else {
                                    CachedCurrentInstallationController.this.installationId.set(current.getInstallationId());
                                    PLog.v(CachedCurrentInstallationController.TAG, "Successfully deserialized Installation object");
                                }
                                Object object = CachedCurrentInstallationController.this.mutex;
                                synchronized (object) {
                                    CachedCurrentInstallationController.this.currentInstallation = current;
                                }
                                return current;
                            }
                        }, ParseExecutors.io());
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task<Boolean> existsAsync() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.currentInstallation != null) {
                return Task.forResult((Object)true);
            }
        }
        return this.taskQueue.enqueue(new Continuation<Void, Task<Boolean>>(){

            public Task<Boolean> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Boolean>>(){

                    public Task<Boolean> then(Task<Void> task) throws Exception {
                        return CachedCurrentInstallationController.this.store.existsAsync();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFromMemory() {
        Object object = this.mutex;
        synchronized (object) {
            this.currentInstallation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFromDisk() {
        Object object = this.mutex;
        synchronized (object) {
            this.currentInstallation = null;
        }
        try {
            this.installationId.clear();
            ParseTaskUtils.wait(this.store.deleteAsync());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrent(ParseInstallation installation) {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentInstallation == installation;
        }
    }
}

