/*
 * Decompiled with CFR 0.152.
 */
package bolts;

import bolts.AndroidExecutors;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class BoltsExecutors {
    private static final BoltsExecutors INSTANCE = new BoltsExecutors();
    private final ExecutorService background = !BoltsExecutors.isAndroidRuntime() ? Executors.newCachedThreadPool() : AndroidExecutors.newCachedThreadPool();
    private final Executor immediate = new ImmediateExecutor();

    private static boolean isAndroidRuntime() {
        String javaRuntimeName = System.getProperty("java.runtime.name");
        if (javaRuntimeName == null) {
            return false;
        }
        return javaRuntimeName.toLowerCase(Locale.US).contains("android");
    }

    private BoltsExecutors() {
    }

    public static ExecutorService background() {
        return BoltsExecutors.INSTANCE.background;
    }

    static Executor immediate() {
        return BoltsExecutors.INSTANCE.immediate;
    }

    private static class ImmediateExecutor
    implements Executor {
        private static final int MAX_DEPTH = 15;
        private ThreadLocal<Integer> executionDepth = new ThreadLocal();

        private ImmediateExecutor() {
        }

        private int incrementDepth() {
            Integer oldDepth = this.executionDepth.get();
            if (oldDepth == null) {
                oldDepth = 0;
            }
            int newDepth = oldDepth + 1;
            this.executionDepth.set(newDepth);
            return newDepth;
        }

        private int decrementDepth() {
            int newDepth;
            Integer oldDepth = this.executionDepth.get();
            if (oldDepth == null) {
                oldDepth = 0;
            }
            if ((newDepth = oldDepth - 1) == 0) {
                this.executionDepth.remove();
            } else {
                this.executionDepth.set(newDepth);
            }
            return newDepth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            int depth = this.incrementDepth();
            try {
                if (depth <= 15) {
                    command.run();
                } else {
                    BoltsExecutors.background().execute(command);
                }
            }
            finally {
                this.decrementDepth();
            }
        }
    }
}

