/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import com.google.errorprone.annotations.Immutable;
import com.palantir.javaformat.CommentsHelper;
import com.palantir.javaformat.Op;
import com.palantir.javaformat.Output;
import com.palantir.javaformat.doc.Doc;
import com.palantir.javaformat.doc.DocBuilder;
import com.palantir.javaformat.doc.Obs;
import com.palantir.javaformat.doc.State;

@Immutable
public final class NonBreakingSpace
extends Doc
implements Op {
    private NonBreakingSpace() {
    }

    public static NonBreakingSpace make() {
        return new NonBreakingSpace();
    }

    @Override
    public void add(DocBuilder builder) {
        builder.add(this);
    }

    @Override
    protected float computeWidth() {
        return 1.0f;
    }

    @Override
    protected String computeFlat() {
        return " ";
    }

    @Override
    protected Range<Integer> computeRange() {
        return Doc.EMPTY_RANGE;
    }

    @Override
    public State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state, Obs.ExplorationNode observationNode) {
        return state.withColumn(state.column() + 1);
    }

    @Override
    public void write(State state, Output output) {
        output.append(state, " ", this.range());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }
}

