/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.palantir.gradle.ideaconfiguration.IdeaConfigurationExtension;
import com.palantir.gradle.ideaconfiguration.IdeaConfigurationPlugin;
import com.palantir.javaformat.gradle.ConfigureJavaFormatterXml;
import com.palantir.javaformat.gradle.NativeImageFormatProviderPlugin;
import com.palantir.javaformat.gradle.PalantirJavaFormatProviderPlugin;
import groovy.util.Node;
import groovy.util.XmlNodePrinter;
import groovy.util.XmlParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.xml.sax.SAXException;

public final class PalantirJavaFormatIdeaPlugin
implements Plugin<Project> {
    private static final String MIN_IDEA_PLUGIN_VERSION = "2.57.0";

    public void apply(Project rootProject) {
        Preconditions.checkState((rootProject == rootProject.getRootProject() ? 1 : 0) != 0, (Object)"May only apply com.palantir.java-format-idea to the root project");
        rootProject.getPlugins().apply(PalantirJavaFormatProviderPlugin.class);
        rootProject.getPluginManager().withPlugin("idea", ideaPlugin -> {
            Configuration implConfiguration = rootProject.getConfigurations().getByName("palantirJavaFormat");
            Optional<Configuration> nativeImplConfiguration = PalantirJavaFormatIdeaPlugin.maybeGetNativeImplConfiguration(rootProject);
            PalantirJavaFormatIdeaPlugin.configureLegacyIdea(rootProject, implConfiguration, nativeImplConfiguration);
            PalantirJavaFormatIdeaPlugin.configureIntelliJImport(rootProject, implConfiguration, nativeImplConfiguration);
        });
        rootProject.getPluginManager().apply(IdeaConfigurationPlugin.class);
        IdeaConfigurationExtension extension = (IdeaConfigurationExtension)rootProject.getExtensions().getByType(IdeaConfigurationExtension.class);
        extension.externalDependency("palantir-java-format", MIN_IDEA_PLUGIN_VERSION);
    }

    private static Optional<Configuration> maybeGetNativeImplConfiguration(Project rootProject) {
        return NativeImageFormatProviderPlugin.isNativeImageConfigured(rootProject) ? Optional.of(rootProject.getConfigurations().getByName("palantirJavaFormatNative")) : Optional.empty();
    }

    private static void configureLegacyIdea(Project project, Configuration implConfiguration, Optional<Configuration> nativeImplConfiguration) {
        IdeaModel ideaModel = (IdeaModel)project.getExtensions().getByType(IdeaModel.class);
        ideaModel.getProject().getIpr().withXml(xmlProvider -> {
            List<URI> uris = implConfiguration.getFiles().stream().map(File::toURI).collect(Collectors.toList());
            Optional<URI> nativeUri = nativeImplConfiguration.map(conf -> conf.getSingleFile().toURI());
            ConfigureJavaFormatterXml.configureJavaFormat(xmlProvider.asNode(), uris, nativeUri);
        });
        ideaModel.getWorkspace().getIws().withXml(xmlProvider -> ConfigureJavaFormatterXml.configureWorkspaceXml(xmlProvider.asNode()));
    }

    private static void configureIntelliJImport(Project project, Configuration implConfiguration, Optional<Configuration> nativeImplConfiguration) {
        if (!Boolean.getBoolean("idea.active")) {
            return;
        }
        project.getGradle().projectsEvaluated(gradle -> {
            List uris = implConfiguration.getFiles().stream().map(File::toURI).collect(Collectors.toList());
            Optional<URI> nativeImageUri = nativeImplConfiguration.map(conf -> conf.getSingleFile().toURI());
            PalantirJavaFormatIdeaPlugin.createOrUpdateIdeaXmlFile(project.file((Object)".idea/palantir-java-format.xml"), node -> ConfigureJavaFormatterXml.configureJavaFormat(node, uris, nativeImageUri));
            PalantirJavaFormatIdeaPlugin.createOrUpdateIdeaXmlFile(project.file((Object)".idea/workspace.xml"), ConfigureJavaFormatterXml::configureWorkspaceXml);
            PalantirJavaFormatIdeaPlugin.updateIdeaXmlFileIfExists(project.file((Object)(project.getName() + ".ipr")), node -> ConfigureJavaFormatterXml.configureJavaFormat(node, uris, nativeImageUri));
            PalantirJavaFormatIdeaPlugin.updateIdeaXmlFileIfExists(project.file((Object)(project.getName() + ".iws")), ConfigureJavaFormatterXml::configureWorkspaceXml);
        });
    }

    private static void createOrUpdateIdeaXmlFile(File configurationFile, Consumer<Node> configure) {
        PalantirJavaFormatIdeaPlugin.updateIdeaXmlFile(configurationFile, configure, true);
    }

    private static void updateIdeaXmlFileIfExists(File configurationFile, Consumer<Node> configure) {
        PalantirJavaFormatIdeaPlugin.updateIdeaXmlFile(configurationFile, configure, false);
    }

    private static void updateIdeaXmlFile(File configurationFile, Consumer<Node> configure, boolean createIfAbsent) {
        Node rootNode;
        if (configurationFile.isFile()) {
            try {
                rootNode = new XmlParser().parse(configurationFile);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException("Couldn't parse existing configuration file: " + String.valueOf(configurationFile), e);
            }
        } else {
            if (!createIfAbsent) {
                return;
            }
            rootNode = new Node(null, (Object)"project", (Map)ImmutableMap.of((Object)"version", (Object)"4"));
        }
        configure.accept(rootNode);
        try (BufferedWriter writer = Files.newWriter((File)configurationFile, (Charset)Charset.defaultCharset());
             PrintWriter printWriter = new PrintWriter(writer);){
            XmlNodePrinter nodePrinter = new XmlNodePrinter(printWriter);
            nodePrinter.setPreserveWhitespace(true);
            nodePrinter.print(rootNode);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write back to configuration file: " + String.valueOf(configurationFile), e);
        }
    }
}

