/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Git {
    private static final Logger log = LoggerFactory.getLogger(Git.class);
    private final File directory;

    Git(File directory) {
        this(directory, false);
    }

    @VisibleForTesting
    Git(File directory, boolean testing) {
        if (!this.gitCommandExists()) {
            throw new RuntimeException("Git not found in project");
        }
        this.directory = directory;
        if (testing && !this.checkIfUserIsSet()) {
            this.setGitUser();
        }
    }

    private String runGitCmd(String ... commands) throws IOException, InterruptedException {
        return this.runGitCmd(new HashMap<String, String>(), commands);
    }

    private String runGitCmd(Map<String, String> envvars, String ... commands) throws IOException, InterruptedException {
        ArrayList<String> cmdInput = new ArrayList<String>();
        cmdInput.add("git");
        cmdInput.addAll(Arrays.asList(commands));
        ProcessBuilder pb = new ProcessBuilder(cmdInput);
        Map<String, String> environment = pb.environment();
        environment.putAll(envvars);
        pb.directory(this.directory);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        StringBuilder builder = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            builder.append(line);
            builder.append(System.getProperty("line.separator"));
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "";
        }
        return builder.toString().trim();
    }

    public String runGitCommand(Map<String, String> envvar, String ... command) {
        try {
            return this.runGitCmd(envvar, command);
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            log.debug("Native git command {} failed.\n", (Object)command, (Object)e);
            return null;
        }
    }

    public String runGitCommand(String ... command) {
        return this.runGitCommand(new HashMap<String, String>(), command);
    }

    private boolean checkIfUserIsSet() {
        try {
            String userEmail = this.runGitCmd("config", "user.email");
            return !userEmail.isEmpty();
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            log.debug("Native git config user.email failed", (Throwable)e);
            return false;
        }
    }

    private void setGitUser() {
        try {
            this.runGitCommand("config", "--global", "user.email", "email@example.com");
            this.runGitCommand("config", "--global", "user.name", "name");
        }
        catch (RuntimeException e) {
            log.debug("Native git set user failed", (Throwable)e);
        }
    }

    public String getCurrentBranch() {
        try {
            String branch = this.runGitCmd("branch", "--show-current");
            if (branch.isEmpty()) {
                return null;
            }
            return branch;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            log.debug("Native git branch --show-current failed", (Throwable)e);
            return null;
        }
    }

    public String getCurrentHeadFullHash() {
        try {
            return this.runGitCmd("rev-parse", "HEAD");
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            log.debug("Native git rev-parse HEAD failed", (Throwable)e);
            return null;
        }
    }

    public Boolean isClean() {
        try {
            String result = this.runGitCmd("status", "--porcelain");
            if (result.isEmpty()) {
                return true;
            }
            return false;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            log.debug("Native git status --porcelain failed", (Throwable)e);
            return null;
        }
    }

    public String describe(String prefix) {
        try {
            String result = this.runGitCmd("describe", "--tags", "--always", "--first-parent", "--abbrev=7", "--match=" + prefix + "*", "HEAD");
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            log.debug("Native git describe failed", (Throwable)e);
            return null;
        }
    }

    private boolean gitCommandExists() {
        try {
            Process gitVersionProcess = new ProcessBuilder("git", "version").start();
            if (gitVersionProcess.waitFor() != 0) {
                throw new IllegalStateException("error invoking git command");
            }
            return true;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            log.debug("Native git command not found", (Throwable)e);
            return false;
        }
    }
}

