/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.palantir.gradle.gitversion.BuildScanPluginInterop;
import com.palantir.gradle.gitversion.GitVersionPlugin;
import com.palantir.gradle.gitversion.JsonUtils;
import com.palantir.gradle.gitversion.Timer;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

final class GitVersionRootPlugin
implements Plugin<Project> {
    GitVersionRootPlugin() {
    }

    public void apply(Project project) {
        if (project.getRootProject() != project) {
            throw new IllegalStateException(String.format("The %s plugin must be applied to the root project", GitVersionRootPlugin.class.getSimpleName()));
        }
        BuildScanPluginInterop.addBuildScanCustomValues(project, () -> {
            Map<String, Timer> projectPathToTimers = project.getAllprojects().stream().filter(someProject -> someProject.getPlugins().hasPlugin(GitVersionPlugin.class)).collect(Collectors.toMap(Project::getPath, someProject -> ((GitVersionPlugin)someProject.getPlugins().getPlugin(GitVersionPlugin.class)).timer()));
            Map projectPathToTimerJson = Maps.transformValues(projectPathToTimers, Timer::toJson);
            long totalTime = projectPathToTimers.values().stream().mapToLong(Timer::totalMillis).sum();
            String allProjectTimingData = JsonUtils.mapToJson(projectPathToTimerJson);
            return ImmutableMap.of((Object)"com.palantir.git-version.timings", (Object)allProjectTimingData, (Object)"com.palantir.git-version.timings.total", (Object)Long.toString(totalTime));
        });
    }
}

