/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.report;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@JsonDeserialize(builder=Builder.class)
public final class GitInfo {
    private final Optional<String> branch;
    private final Optional<String> commit;
    private final Optional<Boolean> dirty;
    private final Optional<String> originPath;
    private volatile int memoizedHashCode;

    private GitInfo(Optional<String> branch, Optional<String> commit, Optional<Boolean> dirty, Optional<String> originPath) {
        GitInfo.validateFields(branch, commit, dirty, originPath);
        this.branch = branch;
        this.commit = commit;
        this.dirty = dirty;
        this.originPath = originPath;
    }

    @JsonProperty(value="branch")
    public Optional<String> getBranch() {
        return this.branch;
    }

    @JsonProperty(value="commit")
    public Optional<String> getCommit() {
        return this.commit;
    }

    @JsonProperty(value="dirty")
    public Optional<Boolean> getDirty() {
        return this.dirty;
    }

    @JsonProperty(value="originPath")
    public Optional<String> getOriginPath() {
        return this.originPath;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof GitInfo && this.equalTo((GitInfo)other);
    }

    private boolean equalTo(GitInfo other) {
        return this.branch.equals(other.branch) && this.commit.equals(other.commit) && this.dirty.equals(other.dirty) && this.originPath.equals(other.originPath);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            this.memoizedHashCode = result = Objects.hash(this.branch, this.commit, this.dirty, this.originPath);
        }
        return result;
    }

    public String toString() {
        return "GitInfo{branch: " + this.branch + ", commit: " + this.commit + ", dirty: " + this.dirty + ", originPath: " + this.originPath + '}';
    }

    private static void validateFields(Optional<String> branch, Optional<String> commit, Optional<Boolean> dirty, Optional<String> originPath) {
        List<String> missingFields = null;
        missingFields = GitInfo.addFieldIfMissing(missingFields, branch, "branch");
        missingFields = GitInfo.addFieldIfMissing(missingFields, commit, "commit");
        missingFields = GitInfo.addFieldIfMissing(missingFields, dirty, "dirty");
        if ((missingFields = GitInfo.addFieldIfMissing(missingFields, originPath, "originPath")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", new Arg[]{SafeArg.of((String)"missingFields", missingFields)});
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(4);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> branch = Optional.empty();
        private Optional<String> commit = Optional.empty();
        private Optional<Boolean> dirty = Optional.empty();
        private Optional<String> originPath = Optional.empty();

        private Builder() {
        }

        public Builder from(GitInfo other) {
            this.branch(other.getBranch());
            this.commit(other.getCommit());
            this.dirty(other.getDirty());
            this.originPath(other.getOriginPath());
            return this;
        }

        @JsonSetter(value="branch", nulls=Nulls.SKIP)
        public Builder branch(@Nonnull Optional<String> branch) {
            this.branch = (Optional)Preconditions.checkNotNull(branch, (String)"branch cannot be null");
            return this;
        }

        public Builder branch(@Nonnull String branch) {
            this.branch = Optional.of((String)Preconditions.checkNotNull((Object)branch, (String)"branch cannot be null"));
            return this;
        }

        @JsonSetter(value="commit", nulls=Nulls.SKIP)
        public Builder commit(@Nonnull Optional<String> commit) {
            this.commit = (Optional)Preconditions.checkNotNull(commit, (String)"commit cannot be null");
            return this;
        }

        public Builder commit(@Nonnull String commit) {
            this.commit = Optional.of((String)Preconditions.checkNotNull((Object)commit, (String)"commit cannot be null"));
            return this;
        }

        @JsonSetter(value="dirty", nulls=Nulls.SKIP)
        public Builder dirty(@Nonnull Optional<Boolean> dirty) {
            this.dirty = (Optional)Preconditions.checkNotNull(dirty, (String)"dirty cannot be null");
            return this;
        }

        public Builder dirty(boolean dirty) {
            this.dirty = Optional.of(dirty);
            return this;
        }

        @JsonSetter(value="originPath", nulls=Nulls.SKIP)
        public Builder originPath(@Nonnull Optional<String> originPath) {
            this.originPath = (Optional)Preconditions.checkNotNull(originPath, (String)"originPath cannot be null");
            return this;
        }

        public Builder originPath(@Nonnull String originPath) {
            this.originPath = Optional.of((String)Preconditions.checkNotNull((Object)originPath, (String)"originPath cannot be null"));
            return this;
        }

        public GitInfo build() {
            return new GitInfo(this.branch, this.commit, this.dirty, this.originPath);
        }
    }
}

