/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.report;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.conjure.java.lib.internal.ConjureCollections;
import com.palantir.docker.compose.events.Event;
import com.palantir.docker.compose.report.TestDescription;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@JsonDeserialize(builder=Builder.class)
public final class DockerComposeRun {
    private final String runId;
    private final TestDescription testDescription;
    private final OffsetDateTime startTime;
    private final OffsetDateTime finishTime;
    private final List<Event> events;
    private final Optional<String> dockerComposeConfig;
    private final List<String> exceptions;
    private volatile int memoizedHashCode;

    private DockerComposeRun(String runId, TestDescription testDescription, OffsetDateTime startTime, OffsetDateTime finishTime, List<Event> events, Optional<String> dockerComposeConfig, List<String> exceptions) {
        DockerComposeRun.validateFields(runId, testDescription, startTime, finishTime, events, dockerComposeConfig, exceptions);
        this.runId = runId;
        this.testDescription = testDescription;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.events = Collections.unmodifiableList(events);
        this.dockerComposeConfig = dockerComposeConfig;
        this.exceptions = Collections.unmodifiableList(exceptions);
    }

    @JsonProperty(value="runId")
    public String getRunId() {
        return this.runId;
    }

    @JsonProperty(value="testDescription")
    public TestDescription getTestDescription() {
        return this.testDescription;
    }

    @JsonProperty(value="startTime")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="finishTime")
    public OffsetDateTime getFinishTime() {
        return this.finishTime;
    }

    @JsonProperty(value="events")
    public List<Event> getEvents() {
        return this.events;
    }

    @JsonProperty(value="dockerComposeConfig")
    public Optional<String> getDockerComposeConfig() {
        return this.dockerComposeConfig;
    }

    @JsonProperty(value="exceptions")
    public List<String> getExceptions() {
        return this.exceptions;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof DockerComposeRun && this.equalTo((DockerComposeRun)other);
    }

    private boolean equalTo(DockerComposeRun other) {
        return this.runId.equals(other.runId) && this.testDescription.equals(other.testDescription) && this.startTime.isEqual(other.startTime) && this.finishTime.isEqual(other.finishTime) && this.events.equals(other.events) && this.dockerComposeConfig.equals(other.dockerComposeConfig) && this.exceptions.equals(other.exceptions);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            this.memoizedHashCode = result = Objects.hash(this.runId, this.testDescription, this.startTime.toInstant(), this.finishTime.toInstant(), this.events, this.dockerComposeConfig, this.exceptions);
        }
        return result;
    }

    public String toString() {
        return "DockerComposeRun{runId: " + this.runId + ", testDescription: " + this.testDescription + ", startTime: " + this.startTime + ", finishTime: " + this.finishTime + ", events: " + this.events + ", dockerComposeConfig: " + this.dockerComposeConfig + ", exceptions: " + this.exceptions + '}';
    }

    private static void validateFields(String runId, TestDescription testDescription, OffsetDateTime startTime, OffsetDateTime finishTime, List<Event> events, Optional<String> dockerComposeConfig, List<String> exceptions) {
        List<String> missingFields = null;
        missingFields = DockerComposeRun.addFieldIfMissing(missingFields, runId, "runId");
        missingFields = DockerComposeRun.addFieldIfMissing(missingFields, testDescription, "testDescription");
        missingFields = DockerComposeRun.addFieldIfMissing(missingFields, startTime, "startTime");
        missingFields = DockerComposeRun.addFieldIfMissing(missingFields, finishTime, "finishTime");
        missingFields = DockerComposeRun.addFieldIfMissing(missingFields, events, "events");
        missingFields = DockerComposeRun.addFieldIfMissing(missingFields, dockerComposeConfig, "dockerComposeConfig");
        if ((missingFields = DockerComposeRun.addFieldIfMissing(missingFields, exceptions, "exceptions")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", new Arg[]{SafeArg.of((String)"missingFields", missingFields)});
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(7);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String runId;
        private TestDescription testDescription;
        private OffsetDateTime startTime;
        private OffsetDateTime finishTime;
        private List<Event> events = new ArrayList<Event>();
        private Optional<String> dockerComposeConfig = Optional.empty();
        private List<String> exceptions = new ArrayList<String>();

        private Builder() {
        }

        public Builder from(DockerComposeRun other) {
            this.runId(other.getRunId());
            this.testDescription(other.getTestDescription());
            this.startTime(other.getStartTime());
            this.finishTime(other.getFinishTime());
            this.events(other.getEvents());
            this.dockerComposeConfig(other.getDockerComposeConfig());
            this.exceptions(other.getExceptions());
            return this;
        }

        @JsonSetter(value="runId")
        public Builder runId(@Nonnull String runId) {
            this.runId = (String)Preconditions.checkNotNull((Object)runId, (String)"runId cannot be null");
            return this;
        }

        @JsonSetter(value="testDescription")
        public Builder testDescription(@Nonnull TestDescription testDescription) {
            this.testDescription = (TestDescription)Preconditions.checkNotNull((Object)testDescription, (String)"testDescription cannot be null");
            return this;
        }

        @JsonSetter(value="startTime")
        public Builder startTime(@Nonnull OffsetDateTime startTime) {
            this.startTime = (OffsetDateTime)Preconditions.checkNotNull((Object)startTime, (String)"startTime cannot be null");
            return this;
        }

        @JsonSetter(value="finishTime")
        public Builder finishTime(@Nonnull OffsetDateTime finishTime) {
            this.finishTime = (OffsetDateTime)Preconditions.checkNotNull((Object)finishTime, (String)"finishTime cannot be null");
            return this;
        }

        @JsonSetter(value="events", nulls=Nulls.SKIP)
        public Builder events(@Nonnull Iterable<Event> events) {
            this.events.clear();
            ConjureCollections.addAll(this.events, (Iterable)((Iterable)Preconditions.checkNotNull(events, (String)"events cannot be null")));
            return this;
        }

        public Builder addAllEvents(@Nonnull Iterable<Event> events) {
            ConjureCollections.addAll(this.events, (Iterable)((Iterable)Preconditions.checkNotNull(events, (String)"events cannot be null")));
            return this;
        }

        public Builder events(Event events) {
            this.events.add(events);
            return this;
        }

        @JsonSetter(value="dockerComposeConfig", nulls=Nulls.SKIP)
        public Builder dockerComposeConfig(@Nonnull Optional<String> dockerComposeConfig) {
            this.dockerComposeConfig = (Optional)Preconditions.checkNotNull(dockerComposeConfig, (String)"dockerComposeConfig cannot be null");
            return this;
        }

        public Builder dockerComposeConfig(@Nonnull String dockerComposeConfig) {
            this.dockerComposeConfig = Optional.of((String)Preconditions.checkNotNull((Object)dockerComposeConfig, (String)"dockerComposeConfig cannot be null"));
            return this;
        }

        @JsonSetter(value="exceptions", nulls=Nulls.SKIP)
        public Builder exceptions(@Nonnull Iterable<String> exceptions) {
            this.exceptions.clear();
            ConjureCollections.addAll(this.exceptions, (Iterable)((Iterable)Preconditions.checkNotNull(exceptions, (String)"exceptions cannot be null")));
            return this;
        }

        public Builder addAllExceptions(@Nonnull Iterable<String> exceptions) {
            ConjureCollections.addAll(this.exceptions, (Iterable)((Iterable)Preconditions.checkNotNull(exceptions, (String)"exceptions cannot be null")));
            return this;
        }

        public Builder exceptions(String exceptions) {
            this.exceptions.add(exceptions);
            return this;
        }

        public DockerComposeRun build() {
            return new DockerComposeRun(this.runId, this.testDescription, this.startTime, this.finishTime, this.events, this.dockerComposeConfig, this.exceptions);
        }
    }
}

