/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.palantir.logsafe.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;

public final class ClusterWaitType {
    public static final ClusterWaitType NATIVE = new ClusterWaitType(Value.NATIVE, "NATIVE");
    public static final ClusterWaitType USER = new ClusterWaitType(Value.USER, "USER");
    private static final List<ClusterWaitType> values = Collections.unmodifiableList(Arrays.asList(NATIVE, USER));
    private final Value value;
    private final String string;

    private ClusterWaitType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ClusterWaitType && this.string.equals(((ClusterWaitType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator
    public static ClusterWaitType valueOf(@Nonnull String value) {
        String upperCasedValue;
        Preconditions.checkNotNull((Object)value, (String)"value cannot be null");
        switch (upperCasedValue = value.toUpperCase(Locale.ROOT)) {
            case "NATIVE": {
                return NATIVE;
            }
            case "USER": {
                return USER;
            }
        }
        return new ClusterWaitType(Value.UNKNOWN, upperCasedValue);
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (this.value) {
            case NATIVE: {
                return visitor.visitNative();
            }
            case USER: {
                return visitor.visitUser();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    public static List<ClusterWaitType> values() {
        return values;
    }

    public static interface Visitor<T> {
        public T visitNative();

        public T visitUser();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        NATIVE,
        USER,
        UNKNOWN;

    }
}

