/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.report;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.conjure.java.lib.internal.ConjureCollections;
import com.palantir.docker.compose.report.DockerComposeRun;
import com.palantir.docker.compose.report.GitInfo;
import com.palantir.docker.compose.report.Versions;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class Report {
    private final String reportApiVersion;
    private final String reportId;
    private final OffsetDateTime submittedTime;
    private final Optional<String> username;
    private final GitInfo gitInfo;
    private final Map<String, String> whitelistedEnvironmentVariables;
    private final Versions versions;
    private final List<DockerComposeRun> runs;
    private final List<String> exceptions;
    private volatile int memoizedHashCode;

    private Report(String reportApiVersion, String reportId, OffsetDateTime submittedTime, Optional<String> username, GitInfo gitInfo, Map<String, String> whitelistedEnvironmentVariables, Versions versions, List<DockerComposeRun> runs, List<String> exceptions) {
        Report.validateFields(reportApiVersion, reportId, submittedTime, username, gitInfo, whitelistedEnvironmentVariables, versions, runs, exceptions);
        this.reportApiVersion = reportApiVersion;
        this.reportId = reportId;
        this.submittedTime = submittedTime;
        this.username = username;
        this.gitInfo = gitInfo;
        this.whitelistedEnvironmentVariables = Collections.unmodifiableMap(whitelistedEnvironmentVariables);
        this.versions = versions;
        this.runs = Collections.unmodifiableList(runs);
        this.exceptions = Collections.unmodifiableList(exceptions);
    }

    @JsonProperty(value="reportApiVersion")
    public String getReportApiVersion() {
        return this.reportApiVersion;
    }

    @JsonProperty(value="reportId")
    public String getReportId() {
        return this.reportId;
    }

    @JsonProperty(value="submittedTime")
    public OffsetDateTime getSubmittedTime() {
        return this.submittedTime;
    }

    @JsonProperty(value="username")
    public Optional<String> getUsername() {
        return this.username;
    }

    @JsonProperty(value="gitInfo")
    public GitInfo getGitInfo() {
        return this.gitInfo;
    }

    @JsonProperty(value="whitelistedEnvironmentVariables")
    public Map<String, String> getWhitelistedEnvironmentVariables() {
        return this.whitelistedEnvironmentVariables;
    }

    @JsonProperty(value="versions")
    public Versions getVersions() {
        return this.versions;
    }

    @JsonProperty(value="runs")
    public List<DockerComposeRun> getRuns() {
        return this.runs;
    }

    @JsonProperty(value="exceptions")
    public List<String> getExceptions() {
        return this.exceptions;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Report && this.equalTo((Report)other);
    }

    private boolean equalTo(Report other) {
        return this.reportApiVersion.equals(other.reportApiVersion) && this.reportId.equals(other.reportId) && this.submittedTime.isEqual(other.submittedTime) && this.username.equals(other.username) && this.gitInfo.equals(other.gitInfo) && this.whitelistedEnvironmentVariables.equals(other.whitelistedEnvironmentVariables) && this.versions.equals(other.versions) && this.runs.equals(other.runs) && this.exceptions.equals(other.exceptions);
    }

    public int hashCode() {
        if (this.memoizedHashCode == 0) {
            this.memoizedHashCode = Objects.hash(this.reportApiVersion, this.reportId, this.submittedTime.toInstant(), this.username, this.gitInfo, this.whitelistedEnvironmentVariables, this.versions, this.runs, this.exceptions);
        }
        return this.memoizedHashCode;
    }

    public String toString() {
        return "Report" + '{' + "reportApiVersion" + ": " + this.reportApiVersion + ", " + "reportId" + ": " + this.reportId + ", " + "submittedTime" + ": " + this.submittedTime + ", " + "username" + ": " + this.username + ", " + "gitInfo" + ": " + this.gitInfo + ", " + "whitelistedEnvironmentVariables" + ": " + this.whitelistedEnvironmentVariables + ", " + "versions" + ": " + this.versions + ", " + "runs" + ": " + this.runs + ", " + "exceptions" + ": " + this.exceptions + '}';
    }

    private static void validateFields(String reportApiVersion, String reportId, OffsetDateTime submittedTime, Optional<String> username, GitInfo gitInfo, Map<String, String> whitelistedEnvironmentVariables, Versions versions, List<DockerComposeRun> runs, List<String> exceptions) {
        List<String> missingFields = null;
        missingFields = Report.addFieldIfMissing(missingFields, reportApiVersion, "reportApiVersion");
        missingFields = Report.addFieldIfMissing(missingFields, reportId, "reportId");
        missingFields = Report.addFieldIfMissing(missingFields, submittedTime, "submittedTime");
        missingFields = Report.addFieldIfMissing(missingFields, username, "username");
        missingFields = Report.addFieldIfMissing(missingFields, gitInfo, "gitInfo");
        missingFields = Report.addFieldIfMissing(missingFields, whitelistedEnvironmentVariables, "whitelistedEnvironmentVariables");
        missingFields = Report.addFieldIfMissing(missingFields, versions, "versions");
        missingFields = Report.addFieldIfMissing(missingFields, runs, "runs");
        if ((missingFields = Report.addFieldIfMissing(missingFields, exceptions, "exceptions")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", new Arg[]{SafeArg.of((String)"missingFields", missingFields)});
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(9);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String reportApiVersion;
        private String reportId;
        private OffsetDateTime submittedTime;
        private Optional<String> username = Optional.empty();
        private GitInfo gitInfo;
        private Map<String, String> whitelistedEnvironmentVariables = new LinkedHashMap<String, String>();
        private Versions versions;
        private List<DockerComposeRun> runs = new ArrayList<DockerComposeRun>();
        private List<String> exceptions = new ArrayList<String>();

        private Builder() {
        }

        public Builder from(Report other) {
            this.reportApiVersion(other.getReportApiVersion());
            this.reportId(other.getReportId());
            this.submittedTime(other.getSubmittedTime());
            this.username(other.getUsername());
            this.gitInfo(other.getGitInfo());
            this.whitelistedEnvironmentVariables(other.getWhitelistedEnvironmentVariables());
            this.versions(other.getVersions());
            this.runs(other.getRuns());
            this.exceptions(other.getExceptions());
            return this;
        }

        @JsonSetter(value="reportApiVersion")
        public Builder reportApiVersion(String reportApiVersion) {
            this.reportApiVersion = (String)Preconditions.checkNotNull((Object)reportApiVersion, (String)"reportApiVersion cannot be null");
            return this;
        }

        @JsonSetter(value="reportId")
        public Builder reportId(String reportId) {
            this.reportId = (String)Preconditions.checkNotNull((Object)reportId, (String)"reportId cannot be null");
            return this;
        }

        @JsonSetter(value="submittedTime")
        public Builder submittedTime(OffsetDateTime submittedTime) {
            this.submittedTime = (OffsetDateTime)Preconditions.checkNotNull((Object)submittedTime, (String)"submittedTime cannot be null");
            return this;
        }

        @JsonSetter(value="username", nulls=Nulls.SKIP)
        public Builder username(Optional<String> username) {
            this.username = (Optional)Preconditions.checkNotNull(username, (String)"username cannot be null");
            return this;
        }

        public Builder username(String username) {
            this.username = Optional.of((String)Preconditions.checkNotNull((Object)username, (String)"username cannot be null"));
            return this;
        }

        @JsonSetter(value="gitInfo")
        public Builder gitInfo(GitInfo gitInfo) {
            this.gitInfo = (GitInfo)Preconditions.checkNotNull((Object)gitInfo, (String)"gitInfo cannot be null");
            return this;
        }

        @JsonSetter(value="whitelistedEnvironmentVariables", nulls=Nulls.SKIP)
        public Builder whitelistedEnvironmentVariables(Map<String, String> whitelistedEnvironmentVariables) {
            this.whitelistedEnvironmentVariables.clear();
            this.whitelistedEnvironmentVariables.putAll((Map)Preconditions.checkNotNull(whitelistedEnvironmentVariables, (String)"whitelistedEnvironmentVariables cannot be null"));
            return this;
        }

        public Builder putAllWhitelistedEnvironmentVariables(Map<String, String> whitelistedEnvironmentVariables) {
            this.whitelistedEnvironmentVariables.putAll((Map)Preconditions.checkNotNull(whitelistedEnvironmentVariables, (String)"whitelistedEnvironmentVariables cannot be null"));
            return this;
        }

        public Builder whitelistedEnvironmentVariables(String key, String value) {
            this.whitelistedEnvironmentVariables.put(key, value);
            return this;
        }

        @JsonSetter(value="versions")
        public Builder versions(Versions versions) {
            this.versions = (Versions)Preconditions.checkNotNull((Object)versions, (String)"versions cannot be null");
            return this;
        }

        @JsonSetter(value="runs", nulls=Nulls.SKIP)
        public Builder runs(Iterable<DockerComposeRun> runs) {
            this.runs.clear();
            ConjureCollections.addAll(this.runs, (Iterable)((Iterable)Preconditions.checkNotNull(runs, (String)"runs cannot be null")));
            return this;
        }

        public Builder addAllRuns(Iterable<DockerComposeRun> runs) {
            ConjureCollections.addAll(this.runs, (Iterable)((Iterable)Preconditions.checkNotNull(runs, (String)"runs cannot be null")));
            return this;
        }

        public Builder runs(DockerComposeRun runs) {
            this.runs.add(runs);
            return this;
        }

        @JsonSetter(value="exceptions", nulls=Nulls.SKIP)
        public Builder exceptions(Iterable<String> exceptions) {
            this.exceptions.clear();
            ConjureCollections.addAll(this.exceptions, (Iterable)((Iterable)Preconditions.checkNotNull(exceptions, (String)"exceptions cannot be null")));
            return this;
        }

        public Builder addAllExceptions(Iterable<String> exceptions) {
            ConjureCollections.addAll(this.exceptions, (Iterable)((Iterable)Preconditions.checkNotNull(exceptions, (String)"exceptions cannot be null")));
            return this;
        }

        public Builder exceptions(String exceptions) {
            this.exceptions.add(exceptions);
            return this;
        }

        public Report build() {
            return new Report(this.reportApiVersion, this.reportId, this.submittedTime, this.username, this.gitInfo, this.whitelistedEnvironmentVariables, this.versions, this.runs, this.exceptions);
        }
    }
}

